/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ArtifactVersionManagerPlugin;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectStaticVersionPlugin;
import org.azyva.dragom.model.plugin.impl.SelectStaticVersionPluginBaseImpl;

public class PhaseSelectStaticVersionPluginImpl
extends SelectStaticVersionPluginBaseImpl
implements SelectStaticVersionPlugin {
    private static final String RUNTIME_PROPERTY_CURRENT_PHASE = "CURRENT_PHASE";

    public PhaseSelectStaticVersionPluginImpl(Module module) {
        super(module);
    }

    public Version selectStaticVersion(Version versionDynamic) {
        ArtifactVersionManagerPlugin artifactVersionManagerPlugin;
        this.validateVersionDynamic(versionDynamic);
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        String currentPhase = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_CURRENT_PHASE);
        if (currentPhase == null) {
            throw new RuntimeException("The property CURRENT_PHASE must be defined in the context of module " + this.getModule() + '.');
        }
        Version versionStaticSelected = new Version(VersionType.STATIC, versionDynamic.getVersion() + '-' + currentPhase);
        ScmPlugin scmPlugin = (ScmPlugin)this.getModule().getNodePlugin(ScmPlugin.class, null);
        if (!scmPlugin.isVersionExists(versionStaticSelected) && (artifactVersionManagerPlugin = (ArtifactVersionManagerPlugin)this.getModule().getNodePlugin(ArtifactVersionManagerPlugin.class, null)) != null) {
            Path pathModuleWorkspace = scmPlugin.checkoutSystem(versionDynamic);
            ArtifactVersion artifactVersion = artifactVersionManagerPlugin.getArtifactVersion(pathModuleWorkspace);
            WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
            ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)this.getModule().getNodePlugin(ArtifactVersionMapperPlugin.class, null);
            ArtifactVersion artifactVersionFromSelectedStaticVersion = artifactVersionMapperPlugin.mapVersionToArtifactVersion(versionStaticSelected);
            if (!artifactVersion.equals((Object)artifactVersionFromSelectedStaticVersion)) {
                throw new RuntimeException("The current artifact version " + artifactVersion + " for the dynamic version " + versionDynamic + " of module " + this.getModule() + " does not correspond to the artifact version " + artifactVersionFromSelectedStaticVersion + " mapped from the new static version " + versionStaticSelected + '.');
            }
        }
        return versionStaticSelected;
    }
}

