/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.maven.Pom;
import org.azyva.dragom.maven.PomAggregation;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.model.plugin.ReferenceManagerPlugin;
import org.azyva.dragom.model.plugin.impl.MavenArtifactVersionManagerPluginImpl;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.model.plugin.impl.SimplePomResolver;
import org.azyva.dragom.reference.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenReferenceManagerPluginImpl
extends ModulePluginAbstractImpl
implements ReferenceManagerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MavenArtifactVersionManagerPluginImpl.class);
    protected static final String MSG_PATTERN_KEY_ERROR_INVALID_REFERENCED_ARTIFACT = "ERROR_INVALID_REFERENCED_ARTIFACT";
    protected static final ResourceBundle resourceBundle = ResourceBundle.getBundle(MavenReferenceManagerPluginImpl.class.getName() + "ResourceBundle");

    public MavenReferenceManagerPluginImpl(Module module) {
        super(module);
    }

    public List<Reference> getListReference(Path pathModuleWorkspace) {
        Path pathPom = pathModuleWorkspace.resolve("pom.xml");
        PomAggregation pomAggregation = new PomAggregation(pathPom);
        String aggregationVersion = pomAggregation.getPomMain().getVersion();
        Set<ArtifactGroupId> setArtifactGroupIdAggregation = pomAggregation.getSetArtifactGroupId();
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        ArrayList<Reference> listReference = new ArrayList<Reference>();
        Model model = this.getModule().getModel();
        SimplePomResolver pomResolver = new SimplePomResolver(pomAggregation);
        for (Pom pom : pomAggregation.getCollectionPom()) {
            String version = pom.getEffectiveVersion();
            if (version == null) {
                throw new RuntimeException("The module " + this.getModule() + " does not define its artifact version in the POM " + pathPom + '.');
            }
            if (!version.equals(aggregationVersion)) {
                throw new RuntimeException("The submodule POM " + pathPom + " of module " + this.getModule() + " has version " + version + " which is not the same as that of its container " + aggregationVersion + '.');
            }
            List<Pom.ReferencedArtifact> listReferencedArtifact = pom.getListReferencedArtifact(EnumSet.allOf(Pom.ReferencedArtifactType.class), null, null, null);
            for (Pom.ReferencedArtifact referencedArtifact : listReferencedArtifact) {
                ModuleVersion moduleVersion;
                ArtifactVersion artifactVersion;
                ArtifactGroupId artifactGroupId;
                try {
                    artifactGroupId = new ArtifactGroupId(pom.resolveProperties(referencedArtifact.getGroupId(), pomResolver), pom.resolveProperties(referencedArtifact.getArtifactId(), pomResolver));
                    artifactVersion = new ArtifactVersion(pom.resolveProperties(referencedArtifact.getVersion(), pomResolver));
                }
                catch (RuntimeException re) {
                    logger.error("ReferencedArtifact " + referencedArtifact + " could not be resolved and is ignored. Reason:", (Throwable)re);
                    continue;
                }
                if (setArtifactGroupIdAggregation.contains(artifactGroupId)) continue;
                Module module = model.findModuleByArtifactGroupId(artifactGroupId);
                if (module != null) {
                    ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)module.getNodePlugin(ArtifactVersionMapperPlugin.class, null);
                    moduleVersion = new ModuleVersion(module.getNodePath(), artifactVersionMapperPlugin.mapArtifactVersionToVersion(artifactVersion));
                    if (module.getNodePath().equals((Object)this.getNode().getNodePath())) {
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ERROR_INVALID_REFERENCED_ARTIFACT), pathModuleWorkspace, referencedArtifact.toString() + " (" + artifactGroupId + ':' + artifactVersion + ')', module));
                        continue;
                    }
                } else {
                    moduleVersion = null;
                }
                Reference reference = new Reference(moduleVersion, artifactGroupId, artifactVersion, (Object)new ReferenceImplData(pathModuleWorkspace.relativize(pom.getPathPom()), referencedArtifact));
                listReference.add(reference);
            }
        }
        return listReference;
    }

    public boolean updateReferenceVersion(Path pathModuleWorkspace, Reference reference, Version version, ByReference<Reference> byReferenceReference) {
        if (!(reference.getImplData() instanceof ReferenceImplData)) {
            throw new RuntimeException("Within " + this + ", reference extra implementation data must be of type ReferenceImplData.");
        }
        ReferenceImplData referenceImplData = (ReferenceImplData)reference.getImplData();
        if (referenceImplData.getReferenceManagerPluginImpl() != this) {
            throw new RuntimeException("Within " + this + ", reference must have been produced by the same plugin instance.");
        }
        Path pathPom = pathModuleWorkspace.resolve(referenceImplData.pathPom);
        Pom pom = new Pom();
        pom.setPathPom(pathPom);
        pom.loadPom();
        ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)this.getModule().getModel().getModule(reference.getModuleVersion().getNodePath()).getNodePlugin(ArtifactVersionMapperPlugin.class, null);
        ArtifactVersion artifactVersion = artifactVersionMapperPlugin.mapVersionToArtifactVersion(version);
        if (byReferenceReference != null) {
            byReferenceReference.object = new Reference(new ModuleVersion(reference.getModuleVersion().getNodePath(), version), reference.getArtifactGroupId(), artifactVersion, (Object)referenceImplData);
        }
        if (!artifactVersion.toString().equals(reference.getArtifactVersion())) {
            pom.setReferencedArtifactVersion(referenceImplData.referencedArtifact, artifactVersion.toString());
            pom.savePom();
            return true;
        }
        return false;
    }

    public boolean updateReferenceArtifactVersion(Path pathModuleWorkspace, Reference reference, ArtifactVersion artifactVersion, ByReference<Reference> byReferenceReference) {
        throw new RuntimeException("Not implemented yet.");
    }

    private class ReferenceImplData {
        private Path pathPom;
        private Pom.ReferencedArtifact referencedArtifact;

        public ReferenceImplData(Path pathPom, Pom.ReferencedArtifact referencedArtifact) {
            this.pathPom = pathPom;
            this.referencedArtifact = referencedArtifact;
        }

        private MavenReferenceManagerPluginImpl getReferenceManagerPluginImpl() {
            return MavenReferenceManagerPluginImpl.this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Pom.ReferencedArtifactType referencedArtifactType = this.referencedArtifact.getReferencedArtifactType();
            stringBuilder.append("ref ").append(this.pathPom).append(' ').append((Object)referencedArtifactType);
            if (referencedArtifactType == Pom.ReferencedArtifactType.PROFILE_DEPENDENCY || referencedArtifactType == Pom.ReferencedArtifactType.PROFILE_DEPENDENCY_MANAGEMENT) {
                stringBuilder.append('(').append(this.referencedArtifact.getProfile()).append(')');
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pathPom.hashCode();
            result = 31 * result + this.referencedArtifact.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferenceImplData)) {
                return false;
            }
            ReferenceImplData referenceImplDataOther = (ReferenceImplData)other;
            if (!this.pathPom.equals(referenceImplDataOther.pathPom)) {
                return false;
            }
            if (!this.referencedArtifact.getReferencedArtifactType().equals((Object)referenceImplDataOther.referencedArtifact.getReferencedArtifactType())) {
                return false;
            }
            return !(this.referencedArtifact.getProfile() == null ? referenceImplDataOther.referencedArtifact.getProfile() != null : !this.referencedArtifact.getProfile().equals(referenceImplDataOther.referencedArtifact.getProfile()));
        }
    }
}

