/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.plugin.BuilderPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenBuilderPluginImpl
extends ModulePluginAbstractImpl
implements BuilderPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MavenBuilderPluginImpl.class);
    private static final String DRAGOM_PROPERTIES_FILE = "dragom.properties";
    private static final String RUNTIME_PROPERTY_MAVEN_INSTALLATION = "MAVEN_INSTALLATION";
    private static final String RUNTIME_PROPERTY_MAVEN_HOME_DIR = "MAVEN_HOME";
    private static final String RUNTIME_PROPERTY_JDK_HOME_DIR = "MAVEN_JDK_HOME";
    private static final String RUNTIME_PROPERTY_LOCAL_REPO_DIR = "MAVEN_LOCAL_REPO";
    private static final String RUNTIME_PROPERTY_SETTINGS_FILE_PATH = "MAVEN_SETTINGS";
    private static final String RUNTIME_PROPERTY_GLOBAL_SETTINGS_FILE_PATH = "MAVEN_GLOBAL_SETTINGS";
    private static final String RUNTIME_PROPERTY_TARGETS = "MAVEN_TARGETS";
    private static final String RUNTIME_PROPERTY_IND_CLEAN_BEFORE_BUILD = "MAVEN_IND_CLEAN_BEFORE_BUILD";
    private static final String RUNTIME_PROPERTY_PROPERTIES = "MAVEN_PROPERTIES";
    private static final String RUNTIME_PROPERTY_PREFIX_PROPERTY = "MAVEN_PROPERTY.";
    private static final String RUNTIME_PROPERTY_PROFILES = "MAVEN_PROFILES";
    private static final String RUNTIME_PROPERTY_IND_UPDATE_SNAPSHOTS = "MAVEN_IND_UPDATE_SNAPSHOTS";
    private static final String RUNTIME_PROPERTY_IND_FAIL_FAST = "MAVEN_IND_FAIL_FAST";
    private static final String RUNTIME_PROPERTY_POM_FILE = "MAVEN_POM_FILE";
    private static final String RUNTIME_PROPERTY_IND_OFFLINE = "MAVEN_IND_OFFLINE";
    private static final String RUNTIME_PROPERTY_IND_SHOW_VERSION = "MAVEN_IND_SHOW_VERSION";
    private static final String RUNTIME_PROPERTY_EXTRA_OPTIONS = "MAVEN_EXTRA_OPTIONS";
    private static final String RUNTIME_PROPERTY_IND_WRITE_LOG_TO_FILE = "MAVEN_IND_WRITE_LOG_TO_FILE";
    private static final String RUNTIME_PROPERTY_LOG_FILE_PATH = "MAVEN_LOG_FILE";
    private static final String RUNTIME_PROPERTY_RELATIVE_LOG_FILE_BASE = "MAVEN_RELATIVE_LOG_FILE_BASE";
    private static final int READER_BUFFER_SIZE = 8192;

    public MavenBuilderPluginImpl(Module module) {
        super(module);
    }

    public boolean isSomethingToBuild(Path pathModuleWorkspace) {
        return true;
    }

    public boolean build(Path pathModuleWorkspace, String buildContext, Writer writerLog) {
        return this.invokeMaven(pathModuleWorkspace, buildContext, writerLog, false);
    }

    public boolean isCleanSupported() {
        return true;
    }

    public boolean isSomethingToClean(Path pathModuleWorkspace) {
        return true;
    }

    public boolean clean(Path pathModuleWorkspace, Writer writerLog) {
        return this.invokeMaven(pathModuleWorkspace, null, writerLog, true);
    }

    public boolean invokeMaven(Path pathModuleWorkspace, String buildContext, Writer writerLog, boolean indCleanOnly) {
        Properties propertiesModule = this.loadModuleProperties(pathModuleWorkspace);
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        String mavenHomeDir = null;
        String jdkHomeDir = null;
        String localRepoDir = null;
        String settingsFilePath = null;
        String globalSettingsFilePath = null;
        String mavenInstallation = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_MAVEN_INSTALLATION);
        if (mavenInstallation != null) {
            mavenHomeDir = runtimePropertiesPlugin.getProperty((Node)this.getModule(), "MAVEN_HOME." + mavenInstallation);
            jdkHomeDir = runtimePropertiesPlugin.getProperty((Node)this.getModule(), "MAVEN_JDK_HOME." + mavenInstallation);
            localRepoDir = runtimePropertiesPlugin.getProperty((Node)this.getModule(), "MAVEN_LOCAL_REPO." + mavenInstallation);
            settingsFilePath = runtimePropertiesPlugin.getProperty((Node)this.getModule(), "MAVEN_SETTINGS." + mavenInstallation);
            globalSettingsFilePath = runtimePropertiesPlugin.getProperty((Node)this.getModule(), "MAVEN_GLOBAL_SETTINGS." + mavenInstallation);
        }
        if (mavenHomeDir == null) {
            mavenHomeDir = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_MAVEN_HOME_DIR);
        }
        if (mavenHomeDir == null && (mavenHomeDir = System.getenv(RUNTIME_PROPERTY_MAVEN_HOME_DIR)) != null) {
            logger.info("Maven home directory taken from MAVEN_HOME environment variable.");
        }
        if (mavenHomeDir == null) {
            throw new RuntimeException("Maven home directory not set for module " + this.getModule() + '.');
        }
        logger.info("Maven home directory: " + mavenHomeDir);
        if (jdkHomeDir == null) {
            jdkHomeDir = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_JDK_HOME_DIR);
        }
        if (jdkHomeDir == null && (jdkHomeDir = System.getenv("JAVA_HOME")) != null) {
            logger.info("JDK home directory taken from JAVA_HOME environment variable.");
        }
        if (jdkHomeDir == null) {
            throw new RuntimeException("JDK home directory not set for module " + this.getModule() + '.');
        }
        logger.info("JDK home directory: " + jdkHomeDir);
        if (localRepoDir == null) {
            localRepoDir = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_LOCAL_REPO_DIR);
        }
        if (settingsFilePath == null) {
            settingsFilePath = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_SETTINGS_FILE_PATH);
        }
        if (globalSettingsFilePath == null) {
            globalSettingsFilePath = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_GLOBAL_SETTINGS_FILE_PATH);
        }
        String targets = !indCleanOnly ? this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_TARGETS) : null;
        boolean indCleanBeforeBuild = Boolean.parseBoolean(this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_IND_CLEAN_BEFORE_BUILD));
        String properties = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_PROPERTIES);
        String profiles = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_PROFILES);
        boolean indUpdateSnapshots = Boolean.parseBoolean(this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_IND_UPDATE_SNAPSHOTS));
        boolean indFailFast = Boolean.parseBoolean(this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_IND_FAIL_FAST));
        String pomFile = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_POM_FILE);
        boolean indOffline = Boolean.parseBoolean(this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_IND_OFFLINE));
        boolean indShowVersion = Boolean.parseBoolean(this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_IND_SHOW_VERSION));
        String extraOptions = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_EXTRA_OPTIONS);
        boolean indWriteLogToFile = Boolean.parseBoolean(this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_IND_WRITE_LOG_TO_FILE));
        String logFilePath = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_LOG_FILE_PATH);
        if (indWriteLogToFile && logFilePath == null) {
            throw new RuntimeException("Logging the build process is activated but the log file is not specified for module " + this.getModule() + '.');
        }
        String stringRelativeLogFileBase = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_RELATIVE_LOG_FILE_BASE);
        RelativeLogFileBase relativeLogFileBase = stringRelativeLogFileBase != null ? RelativeLogFileBase.valueOf(stringRelativeLogFileBase) : null;
        ArrayList<String> listCommandLine = new ArrayList<String>();
        if (Util.isWindows()) {
            listCommandLine.add(mavenHomeDir + "/bin/mvn.cmd");
        } else {
            listCommandLine.add(mavenHomeDir + "/bin/mvn");
        }
        listCommandLine.add("--batch-mode");
        if (localRepoDir != null) {
            listCommandLine.add("--define");
            listCommandLine.add("maven.repo.local=" + localRepoDir);
        }
        if (settingsFilePath != null) {
            listCommandLine.add("--settings");
            listCommandLine.add(this.convertWorkspaceRelative(((WorkspaceExecContext)execContext).getPathWorkspaceDir(), settingsFilePath));
        }
        if (globalSettingsFilePath != null) {
            listCommandLine.add("--global-settings");
            listCommandLine.add(this.convertWorkspaceRelative(((WorkspaceExecContext)execContext).getPathWorkspaceDir(), globalSettingsFilePath));
        }
        if (properties != null) {
            String[] tabProperty = properties.trim().split("\\s*,\\s*");
            HashSet<String> setProperty = new HashSet<String>();
            for (String property : tabProperty) {
                if (property.length() == 0) continue;
                if (property.charAt(0) == '-') {
                    setProperty.remove(property.substring(1));
                    continue;
                }
                setProperty.add(property);
            }
            for (String property : setProperty) {
                listCommandLine.add("--define");
                String value = this.getRuntimeOrModuleProperty(propertiesModule, RUNTIME_PROPERTY_PREFIX_PROPERTY + property);
                if (value == null) {
                    listCommandLine.add(property);
                    continue;
                }
                listCommandLine.add(property + '=' + value);
            }
        }
        if (buildContext != null) {
            profiles = profiles != null ? buildContext + "," + profiles : buildContext;
        }
        if (profiles != null) {
            String[] tabProfile = profiles.trim().split("\\s*,\\s*");
            HashSet<Object> setProfile = new HashSet<Object>();
            for (String profile : tabProfile) {
                if (profile.length() == 0) continue;
                if (profile.charAt(0) == '-') {
                    setProfile.remove(profile.substring(1));
                    continue;
                }
                setProfile.add(profile);
            }
            listCommandLine.add("--activate-profiles");
            listCommandLine.add(String.join((CharSequence)",", setProfile));
        }
        if (indUpdateSnapshots) {
            listCommandLine.add("--update-snapshots");
        }
        if (indFailFast) {
            listCommandLine.add("--fail-fast");
        }
        if (pomFile != null) {
            listCommandLine.add("--file");
            listCommandLine.add(pomFile);
        }
        if (indOffline) {
            listCommandLine.add("--offline");
        }
        if (indShowVersion) {
            listCommandLine.add("--show-version");
        }
        if (extraOptions != null) {
            listCommandLine.addAll(Arrays.asList(extraOptions.trim().split("\\s+")));
        }
        if (indCleanOnly) {
            targets = "clean";
        } else {
            if (targets == null) {
                targets = "install";
            }
            if (indCleanBeforeBuild) {
                targets = "clean " + targets;
            }
        }
        listCommandLine.addAll(Arrays.asList(targets.trim().split("\\s+")));
        ProcessBuilder processBuilder = new ProcessBuilder(listCommandLine);
        processBuilder.environment().put("JAVA_HOME", jdkHomeDir);
        processBuilder.directory(pathModuleWorkspace.toFile());
        processBuilder.redirectErrorStream(true);
        if (logger.isInfoEnabled()) {
            logger.info("Invoking Maven with JAVA_HOME set to " + jdkHomeDir + ", " + pathModuleWorkspace + " as the current working directory and with the following command and arguments: " + listCommandLine);
        }
        try {
            int nbCharsRead;
            BufferedWriter bufferedWriterLogFile;
            if (indWriteLogToFile) {
                logFilePath = relativeLogFileBase == null || relativeLogFileBase.equals((Object)RelativeLogFileBase.WORKSPACE) ? this.convertWorkspaceRelative(((WorkspaceExecContext)execContext).getPathWorkspaceDir(), logFilePath) : this.convertWorkspaceRelative(pathModuleWorkspace, logFilePath);
                bufferedWriterLogFile = new BufferedWriter(new FileWriter(logFilePath, relativeLogFileBase == null || relativeLogFileBase != RelativeLogFileBase.MODULE_REPLACE));
            } else {
                bufferedWriterLogFile = null;
            }
            Process process = processBuilder.start();
            process.getOutputStream().close();
            char[] buffer = new char[8192];
            InputStreamReader reader = new InputStreamReader(process.getInputStream());
            while ((nbCharsRead = reader.read(buffer)) != -1) {
                if (writerLog != null) {
                    writerLog.write(buffer, 0, nbCharsRead);
                }
                if (bufferedWriterLogFile == null) continue;
                bufferedWriterLogFile.write(buffer, 0, nbCharsRead);
            }
            if (bufferedWriterLogFile != null) {
                bufferedWriterLogFile.close();
            }
            return process.exitValue() == 0;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private Properties loadModuleProperties(Path pathModuleWorkspace) {
        File fileProperties = pathModuleWorkspace.resolve(DRAGOM_PROPERTIES_FILE).toFile();
        if (fileProperties.isFile()) {
            Properties propertiesModule = new Properties();
            try {
                propertiesModule.load(new FileInputStream(fileProperties));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return propertiesModule;
        }
        return null;
    }

    private String getRuntimeOrModuleProperty(Properties propertiesModule, String name) {
        String value = null;
        if (propertiesModule != null) {
            value = propertiesModule.getProperty(name);
        }
        if (value == null) {
            ExecContext execContext = ExecContextHolder.get();
            RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
            value = runtimePropertiesPlugin.getProperty((Node)this.getModule(), name);
        }
        return value;
    }

    private String convertWorkspaceRelative(Path pathBaseDir, String filePath) {
        Path pathFile = Paths.get(filePath, new String[0]);
        if (pathFile.isAbsolute()) {
            return filePath;
        }
        return pathBaseDir.resolve(pathFile).toString();
    }

    private static enum RelativeLogFileBase {
        WORKSPACE,
        MODULE,
        MODULE_REPLACE;

    }
}

