/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectDynamicVersionPlugin;
import org.azyva.dragom.model.plugin.impl.SelectDynamicVersionPluginBaseImpl;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;

public class HotfixSelectDynamicVersionPluginImpl
extends SelectDynamicVersionPluginBaseImpl
implements SelectDynamicVersionPlugin {
    private static final String MSG_PATTERN_KEY_VERSIONS_REFERENCE_PATH_STATIC = "VERSIONS_REFERENCE_PATH_STATIC";
    private static final String MSG_PATTERN_KEY_USE_CURRENT_HOTFIX_VERSION_BASE_UNKNOWN = "USE_CURRENT_HOTFIX_VERSION_BASE_UNKNOWN";
    private static final String MSG_PATTERN_KEY_USE_CURRENT_HOTFIX_VERSION_FOR_BASE = "USE_CURRENT_HOTFIX_VERSION_FOR_BASE";
    private static final String MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_DOES_NOT_EXIST_CURRENT_VERSION_BASE = "SELECTED_DYNAMIC_VERSION_DOES_NOT_EXIST_CURRENT_VERSION_BASE";
    private static final String MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_ALREADY_EXISTS_CURRENT_VERSION_NOT_BASE = "SELECTED_DYNAMIC_VERSION_ALREADY_EXISTS_CURRENT_VERSION_NOT_BASE";
    private static final String MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_ALREADY_EXISTS_BASE_UNKNOWN = "SELECTED_DYNAMIC_VERSION_ALREADY_EXISTS_BASE_UNKNOWN";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(HotfixSelectDynamicVersionPluginImpl.class.getName() + "ResourceBundle");

    public HotfixSelectDynamicVersionPluginImpl(Module module) {
        super(module);
    }

    public Version selectDynamicVersion(Version version, ByReference<Version> byReferenceVersionBase, ReferencePath referencePath) {
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        Module module = this.getModule();
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        if (referencePath.size() > 1 && referencePath.get(0).getModuleVersion().getVersion().getVersionType() != VersionType.STATIC) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERSIONS_REFERENCE_PATH_STATIC), new ModuleVersion(module.getNodePath(), version), referencePath));
            if (!Util.handleDoYouWantToContinue("NON_STATIC_VERSIONS_REFERENCE_PATH")) {
                return null;
            }
        }
        if (version.getVersionType() != VersionType.STATIC) {
            ScmPlugin.BaseVersion baseVersion = scmPlugin.getBaseVersion(version);
            if (baseVersion == null) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_USE_CURRENT_HOTFIX_VERSION_BASE_UNKNOWN), new ModuleVersion(module.getNodePath(), version)));
            } else {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_USE_CURRENT_HOTFIX_VERSION_FOR_BASE), new ModuleVersion(module.getNodePath(), version), baseVersion.versionBase));
            }
            if (!Util.handleDoYouWantToContinue("USE_CURRENT_HOTFIX_VERSION")) {
                return null;
            }
            return version;
        }
        Version versionDynamicSelected = this.handleReuseDynamicVersion(version);
        if (!scmPlugin.isVersionExists(versionDynamicSelected)) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_DOES_NOT_EXIST_CURRENT_VERSION_BASE), module, versionDynamicSelected, version));
            byReferenceVersionBase.object = version;
        } else {
            ScmPlugin.BaseVersion baseVersion = scmPlugin.getBaseVersion(versionDynamicSelected);
            if (baseVersion == null) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_ALREADY_EXISTS_BASE_UNKNOWN), module, versionDynamicSelected, version));
            }
            if (!baseVersion.versionBase.equals((Object)version)) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_ALREADY_EXISTS_CURRENT_VERSION_NOT_BASE), module, versionDynamicSelected, version));
            }
        }
        return versionDynamicSelected;
    }
}

