/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.CredentialStorePlugin;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirSystemModule;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.git.Git;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.event.DynamicVersionCreatedEvent;
import org.azyva.dragom.model.event.NodeEvent;
import org.azyva.dragom.model.event.StaticVersionCreatedEvent;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.ServiceLocator;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScmPluginImpl
extends ModulePluginAbstractImpl
implements ScmPlugin {
    private static final Logger logger = LoggerFactory.getLogger(GitScmPluginImpl.class);
    private static final String MODEL_PROPERTY_GIT_REPOS_COMPLETE_URL = "GIT_REPOS_COMPLETE_URL";
    private static final String MODEL_PROPERTY_GIT_REPOS_BASE_URL = "GIT_REPOS_BASE_URL";
    private static final String MODEL_PROPERTY_GIT_REPOS_DOMAIN_FOLDER = "GIT_REPOS_DOMAIN_FOLDER";
    private static final String MODEL_PROPERTY_GIT_REPOS_NAME = "GIT_REPOS_NAME";
    private static final String MODEL_PROPERTY_GIT_REPOS_SUFFIX = "GIT_REPOS_SUFFIX";
    private static final String EXEC_CONTEXT_PROPERTY_PREFIX_MAIN_WORKSPACE_DIR = "MAIN_WORKSPACE_DIR.";
    private static final String RUNTIME_PROPERTY_GIT_HTTP_CREDENTIAL_HANDLING = "GIT_HTTP_CREDENTIAL_HANDLING";
    private static final String RUNTIME_PROPERTY_GIT_HTTP_USER = "GIT_HTTP_USER";
    private static final String RUNTIME_PROPERTY_GIT_PATH_EXECUTABLE = "GIT_PATH_EXECUTABLE";
    private static final String RUNTIME_PROPERTY_GIT_FETCH_PUSH_BEHAVIOR = "GIT_FETCH_PUSH_BEHAVIOR";
    private static final String RUNTIME_PROPERTY_GIT_IND_PUSH_ALL = "GIT_IND_PUSH_ALL";
    private static final String RUNTIME_PROPERTY_IND_PULL_REBASE = "GIT_IND_PULL_REBASE";
    private static final String TRANSIENT_DATA_PATH_ALREADY_FETCHED = GitScmPluginImpl.class.getName() + ".PathAlreadyFetched";
    private static final String TRANSIENT_DATA_PREFIX_GIT = GitScmPluginImpl.class.getName() + ".Git.";
    private static final String TRANSIENT_DATA_PREFIX_TEMP_DYNAMIC_VERSION_BASE = GitScmPluginImpl.class.getName() + ".TempDynamicVersionBase.";
    private static final String VERSION_ATTR_BASE_VERSION = "dragom-base-version";
    private static final String VERSION_ATTR_BASE_VERSION_COMMIT_ID = "dragom-base-version-commit-id";
    private static final Version VERSION_DEFAULT = new Version(VersionType.DYNAMIC, "master");
    private static final String MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS_FROM_WORKSPACE = "ACCESS_REMOTE_REPOS_FROM_WORKSPACE";
    private static final String MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS = "ACCESS_REMOTE_REPOS";
    private static final String MSG_PATTERN_KEY_WARNING_MERGE_CONFLICTS = "WARNING_MERGE_CONFLICTS";
    private static final String MSG_PATTERN_KEY_PUSHING_UNPUSHED_COMMITS = "PUSHING_UNPUSHED_COMMITS";
    private static final String MSG_PATTERN_KEY_WARNING_UNPUSHED_COMMITS = "WARNING_UNPUSHED_COMMITS";
    private static final String MSG_PATTERN_KEY_NO_DIVERGING_COMMITS = "NO_DIVERGING_COMMITS";
    private static final String MSG_PATTERN_KEY_VERSIONS_EQUAL = "VERSIONS_EQUAL";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(GitScmPluginImpl.class.getName() + "ResourceBundle");
    private static final Pattern patternTestHttpProtocol = Pattern.compile("[hH][tT][tT][pP][sS]?://.*");
    private String gitReposCompleteUrl;

    public GitScmPluginImpl(Module module) {
        super(module);
        String property = module.getProperty(MODEL_PROPERTY_GIT_REPOS_COMPLETE_URL);
        if (property != null) {
            this.gitReposCompleteUrl = property;
        } else {
            StringBuilder stringBuilderGitReposCompleteUrl = new StringBuilder();
            property = module.getProperty(MODEL_PROPERTY_GIT_REPOS_BASE_URL);
            if (property == null) {
                throw new RuntimeException("The property GIT_REPOS_BASE_URL is not defined for plugin " + this.toString() + '.');
            }
            stringBuilderGitReposCompleteUrl.append(property);
            stringBuilderGitReposCompleteUrl.append('/');
            property = module.getProperty(MODEL_PROPERTY_GIT_REPOS_DOMAIN_FOLDER);
            if (property == null) {
                stringBuilderGitReposCompleteUrl.append(module.getNodePath().getNodePathParent().toString());
            } else {
                stringBuilderGitReposCompleteUrl.append(property);
                stringBuilderGitReposCompleteUrl.append('/');
            }
            property = module.getProperty(MODEL_PROPERTY_GIT_REPOS_NAME);
            if (property == null) {
                stringBuilderGitReposCompleteUrl.append(module.getName());
            } else {
                stringBuilderGitReposCompleteUrl.append(property);
            }
            property = module.getProperty(MODEL_PROPERTY_GIT_REPOS_SUFFIX);
            if (property == null) {
                stringBuilderGitReposCompleteUrl.append(".git");
            } else {
                stringBuilderGitReposCompleteUrl.append(property);
            }
            this.gitReposCompleteUrl = stringBuilderGitReposCompleteUrl.toString();
        }
    }

    public boolean isModuleExists() {
        Git git = this.getGit();
        ((UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class)).provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS), this.gitReposCompleteUrl, "ls-remote (isModuleExists)"));
        return git.isReposExists();
    }

    public Version getDefaultVersion() {
        return VERSION_DEFAULT;
    }

    private void gitClone(Version version, Path pathRemote, Path pathModuleWorkspace) {
        Git git = this.getGit();
        if (pathRemote != null) {
            this.gitFetch(pathRemote, null, null, false);
            String reposUrl = "file://" + pathRemote.toAbsolutePath();
            git.clone(reposUrl, null, pathModuleWorkspace);
            git.config(pathModuleWorkspace, "remote.origin.url", this.gitReposCompleteUrl);
            git.fetch(pathModuleWorkspace, reposUrl, "refs/remotes/origin/*:refs/remotes/origin/*", false, true);
            if (version != null) {
                git.checkout(pathModuleWorkspace, version);
            }
        } else {
            ((UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class)).provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS_FROM_WORKSPACE), this.gitReposCompleteUrl, pathModuleWorkspace, "clone"));
            git.clone(null, version, pathModuleWorkspace);
            this.hasFetched(pathModuleWorkspace);
        }
    }

    private void fetch(Path pathModuleWorkspace) {
        NodePath nodePathModule = this.getModule().getNodePath();
        Path pathMainUserWorkspaceDir = this.getPathMainUserWorkspaceDir(nodePathModule);
        if (pathMainUserWorkspaceDir != null && !pathMainUserWorkspaceDir.equals(pathModuleWorkspace)) {
            this.gitFetch(pathMainUserWorkspaceDir, null, null, false);
            this.gitFetch(pathModuleWorkspace, pathMainUserWorkspaceDir, "refs/remotes/origin/*:refs/remotes/origin/*", false);
        } else {
            this.gitFetch(pathModuleWorkspace, null, null, false);
        }
    }

    private void gitFetch(Path pathModuleWorkspace, Path pathRemote, String refspec, boolean indFetchingIntoCurrentBranch) {
        String reposUrl;
        Git git = this.getGit();
        if (pathRemote != null) {
            if (refspec == null) {
                throw new RuntimeException("refspec must not be null.");
            }
            reposUrl = "file://" + pathRemote.toAbsolutePath();
        } else {
            if (!this.mustFetch(pathModuleWorkspace)) {
                return;
            }
            ((UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class)).provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS_FROM_WORKSPACE), this.gitReposCompleteUrl, pathModuleWorkspace, "fetch" + (refspec != null ? " refspec=" + refspec : "")));
            reposUrl = null;
        }
        git.fetch(pathModuleWorkspace, reposUrl, refspec, indFetchingIntoCurrentBranch, false);
        if (indFetchingIntoCurrentBranch) {
            git.executeGitCommand(new String[]{"reset", "--hard", "HEAD"}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
        }
        if (pathRemote == null) {
            this.hasFetched(pathModuleWorkspace);
        }
    }

    private boolean gitPull(Path pathModuleWorkspace) {
        Git git = this.getGit();
        String branch = git.getBranch(pathModuleWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathModuleWorkspace + " the HEAD is not a branch.");
        }
        this.fetch(pathModuleWorkspace);
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        Boolean indPullRebase = Boolean.valueOf(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_IND_PULL_REBASE));
        if (indPullRebase.booleanValue()) {
            return git.rebaseSimple(pathModuleWorkspace);
        }
        return git.mergeSimple(pathModuleWorkspace);
    }

    private void push(Path pathModuleWorkspace, String gitRef) {
        Git git = this.getGit();
        String branch = git.getBranch(pathModuleWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathModuleWorkspace + " the HEAD is not a branch.");
        }
        NodePath nodePathModule = this.getModule().getNodePath();
        Path pathMainUserWorkspaceDir = this.getPathMainUserWorkspaceDir(nodePathModule);
        if (pathMainUserWorkspaceDir != null && !pathMainUserWorkspaceDir.equals(pathModuleWorkspace)) {
            this.gitFetch(pathMainUserWorkspaceDir, pathModuleWorkspace, "refs/heads/" + branch + ":refs/heads/" + branch, false);
            this.gitPush(pathMainUserWorkspaceDir, "refs/heads/" + branch);
            this.gitPush(pathModuleWorkspace, "refs/heads/" + branch);
            this.gitFetch(pathModuleWorkspace, pathMainUserWorkspaceDir, "refs/remotes/origin/*:refs/remotes/origin/*", false);
        } else {
            this.gitPush(pathModuleWorkspace, gitRef);
        }
    }

    private void gitPush(Path pathModuleWorkspace, String gitRef) {
        Git git = this.getGit();
        if (!this.getFetchPushBehavior().isPush()) {
            logger.trace("Pushing is disabled for module " + this.getModule() + " within " + pathModuleWorkspace + '.');
            return;
        }
        ((UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class)).provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS_FROM_WORKSPACE), this.gitReposCompleteUrl, pathModuleWorkspace, "push" + (gitRef != null ? " gitRef=" + gitRef : "")));
        git.push(pathModuleWorkspace, gitRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(Version version, Path pathModuleWorkspace) {
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        NodePath nodePathModule = this.getModule().getNodePath();
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        Path pathMainUserWorkspaceDir = this.getPathMainUserWorkspaceDir(nodePathModule);
        if (pathMainUserWorkspaceDir != null) {
            this.gitClone(version, pathMainUserWorkspaceDir, pathModuleWorkspace);
            return;
        }
        WorkspaceDirSystemModule workspaceDirSystemModule = new WorkspaceDirSystemModule(nodePathModule);
        Path pathModuleWorkspaceRemote = workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirSystemModule) ? workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirSystemModule, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ) : null;
        try {
            this.gitClone(version, pathModuleWorkspaceRemote, pathModuleWorkspace);
        }
        finally {
            if (pathModuleWorkspaceRemote != null) {
                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceRemote);
            }
        }
        this.setPathMainUserWorkspaceDir(nodePathModule, pathModuleWorkspace);
    }

    public Path checkoutSystem(Version version) {
        WorkspaceDirSystemModule workspaceDirSystemModule;
        Git git = this.getGit();
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        NodePath nodePathModule = this.getModule().getNodePath();
        if (version != null) {
            WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(new ModuleVersion(nodePathModule, version));
            if (workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirUserModuleVersion)) {
                return workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            }
        } else {
            Set setWorkspaceDir = workspacePlugin.getSetWorkspaceDir((WorkspaceDir)new WorkspaceDirUserModuleVersion(new ModuleVersion(nodePathModule)));
            if (setWorkspaceDir.size() >= 1) {
                return workspacePlugin.getWorkspaceDir((WorkspaceDir)setWorkspaceDir.iterator().next(), WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            }
        }
        if (workspacePlugin.isWorkspaceDirExist((WorkspaceDir)(workspaceDirSystemModule = new WorkspaceDirSystemModule(nodePathModule)))) {
            Path pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirSystemModule, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            Version versionTempDynamicBase = this.getVersionTempDynamicBase(pathModuleWorkspace);
            if (versionTempDynamicBase != null) {
                if (version != null && !versionTempDynamicBase.equals((Object)version)) {
                    throw new RuntimeException("A temporary dynamic Version " + versionTempDynamicBase + " is in effect in " + pathModuleWorkspace + " but is not the same as the requested Version " + version + '.');
                }
                return pathModuleWorkspace;
            }
            this.fetch(pathModuleWorkspace);
            if (version != null) {
                git.checkout(pathModuleWorkspace, version);
                if (version.getVersionType() == VersionType.DYNAMIC) {
                    Path pathMainUserWorkspaceDir = this.getPathMainUserWorkspaceDir(nodePathModule);
                    if (pathMainUserWorkspaceDir != null && !pathMainUserWorkspaceDir.equals(pathModuleWorkspace) && git.executeGitCommand(new String[]{"rev-parse", "refs/heads/" + version.getVersion(), "--"}, false, Git.AllowExitCode.ALL, pathMainUserWorkspaceDir, null, false) == 0) {
                        this.gitFetch(pathModuleWorkspace, pathMainUserWorkspaceDir, "refs/heads/" + version.getVersion() + ":refs/heads/" + version.getVersion(), true);
                    }
                    if (this.gitPull(pathModuleWorkspace)) {
                        throw new RuntimeException("Conflicts were encountered while pulling changes into " + pathModuleWorkspace + ". This is not expected here.");
                    }
                }
            }
            return pathModuleWorkspace;
        }
        Path pathModuleWorkspace = null;
        try {
            WorkspaceDirSystemModule workspaceDirSystemModuleConflict = (WorkspaceDirSystemModule)workspacePlugin.getWorkspaceDirConflict((WorkspaceDir)workspaceDirSystemModule);
            if (workspaceDirSystemModuleConflict != null) {
                pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirSystemModuleConflict, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
                workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirSystemModuleConflict);
            }
            pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirSystemModule, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_CREATE_NEW_NO_PATH, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            Path pathMainUserWorkspaceDir = this.getPathMainUserWorkspaceDir(nodePathModule);
            this.gitClone(version, pathMainUserWorkspaceDir, pathModuleWorkspace);
        }
        catch (Exception e) {
            if (pathModuleWorkspace != null) {
                workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirSystemModule);
                pathModuleWorkspace.toFile().delete();
            }
            throw e;
        }
        return pathModuleWorkspace;
    }

    private Path getPathModuleWorkspace() {
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        NodePath nodePathModule = this.getModule().getNodePath();
        Path pathModuleWorkspace = this.getPathMainUserWorkspaceDir(nodePathModule);
        if (pathModuleWorkspace != null) {
            if (this.getVersionTempDynamicBase(pathModuleWorkspace) == null) {
                this.fetch(pathModuleWorkspace);
            }
            return pathModuleWorkspace;
        }
        WorkspaceDirSystemModule workspaceDirSystemModule = new WorkspaceDirSystemModule(nodePathModule);
        if (workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirSystemModule)) {
            pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirSystemModule, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.PEEK);
            if (this.getVersionTempDynamicBase(pathModuleWorkspace) == null) {
                this.fetch(pathModuleWorkspace);
            }
            return pathModuleWorkspace;
        }
        pathModuleWorkspace = this.checkoutSystem(null);
        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
        this.fetch(pathModuleWorkspace);
        return pathModuleWorkspace;
    }

    public boolean isVersionExists(Version version) {
        Git git = this.getGit();
        return git.isVersionExists(this.getPathModuleWorkspace(), version);
    }

    private boolean isSync(Path pathModuleWorkspace, EnumSet<ScmPlugin.IsSyncFlag> enumSetIsSyncFlag, boolean indExternal) {
        Git git = this.getGit();
        if (git.getBranch(pathModuleWorkspace) == null) {
            return true;
        }
        this.fetch(pathModuleWorkspace);
        Git.AheadBehindInfo aheadBehindInfo = git.getAheadBehindInfo(pathModuleWorkspace);
        if (enumSetIsSyncFlag.contains(ScmPlugin.IsSyncFlag.REMOTE_CHANGES) && aheadBehindInfo.behind != 0) {
            return false;
        }
        if (enumSetIsSyncFlag.contains(ScmPlugin.IsSyncFlag.LOCAL_CHANGES)) {
            UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
            boolean indPushAll = this.isPushAll();
            if (indPushAll) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_PUSHING_UNPUSHED_COMMITS), pathModuleWorkspace));
                git.push(pathModuleWorkspace);
            }
            if (git.isLocalChanges(pathModuleWorkspace)) {
                return false;
            }
            if (indExternal && !indPushAll && aheadBehindInfo.ahead != 0) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_WARNING_UNPUSHED_COMMITS), pathModuleWorkspace));
            }
        }
        return true;
    }

    public boolean isSync(Path pathModuleWorkspace, EnumSet<ScmPlugin.IsSyncFlag> enumSetIsSyncFlag) {
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        return this.isSync(pathModuleWorkspace, enumSetIsSyncFlag, true);
    }

    public boolean update(Path pathModuleWorkspace) {
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        return this.gitPull(pathModuleWorkspace);
    }

    public Version getVersion(Path pathModuleWorkspace) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        return git.getVersion(pathModuleWorkspace);
    }

    public List<ScmPlugin.Commit> getListCommit(Version version, ScmPlugin.CommitPaging commitPaging, EnumSet<ScmPlugin.GetListCommitFlag> enumSetGetListCommitFlag) {
        return this.getListCommitDiverge(version, null, commitPaging, enumSetGetListCommitFlag);
    }

    public List<ScmPlugin.Commit> getListCommitDiverge(Version versionSrc, Version versionDest, ScmPlugin.CommitPaging commitPaging, EnumSet<ScmPlugin.GetListCommitFlag> enumSetGetListCommitFlag) {
        ArrayList<ScmPlugin.Commit> listCommit;
        HashMap<String, Object> mapTag = null;
        Git git = this.getGit();
        if (commitPaging != null && commitPaging.indDone) {
            throw new RuntimeException("getListCommit called after commit enumeration completed.");
        }
        Path pathModuleWorkspace = this.getPathModuleWorkspace();
        try {
            String commitString;
            listCommit = new ArrayList<ScmPlugin.Commit>();
            StringBuilder stringBuilderCommits = new StringBuilder();
            ArrayList<String> listArg = new ArrayList<String>();
            listArg.add("rev-list");
            listArg.add("--pretty=oneline");
            if (commitPaging != null) {
                if (commitPaging.startIndex != 0) {
                    listArg.add("--skip=" + commitPaging.startIndex);
                }
                if (commitPaging.maxCount != -1) {
                    listArg.add("--max-count=" + commitPaging.maxCount);
                }
            }
            String revisionRange = git.convertToRef(pathModuleWorkspace, versionSrc);
            if (versionDest != null) {
                revisionRange = git.convertToRef(pathModuleWorkspace, versionDest) + ".." + revisionRange;
            }
            listArg.add(revisionRange);
            listArg.add("--");
            git.executeGitCommand(listArg.toArray(new String[0]), false, Git.AllowExitCode.NONE, pathModuleWorkspace, stringBuilderCommits, true);
            BufferedReader bufferedReaderCommits = new BufferedReader(new StringReader(stringBuilderCommits.toString()));
            if (enumSetGetListCommitFlag != null && enumSetGetListCommitFlag.contains(ScmPlugin.GetListCommitFlag.IND_INCLUDE_VERSION_STATIC)) {
                String tagLine;
                StringBuilder stringBuilderTags = new StringBuilder();
                git.executeGitCommand(new String[]{"show-ref", "--tag", "-d"}, false, Git.AllowExitCode.ONE, pathModuleWorkspace, stringBuilderTags, true);
                BufferedReader bufferedReaderTags = new BufferedReader(new StringReader(stringBuilderTags.toString()));
                mapTag = new HashMap<String, Object>();
                while ((tagLine = bufferedReaderTags.readLine()) != null) {
                    String[] arrayTagLineComponent = tagLine.split("\\s+");
                    String commitId = arrayTagLineComponent[0];
                    String tagRef = arrayTagLineComponent[1];
                    if (!tagRef.endsWith("^{}")) continue;
                    String tagName = tagRef.substring(10, tagRef.length() - 3);
                    Object value = mapTag.get(commitId);
                    if (value != null) {
                        if (value instanceof String) {
                            ArrayList<String> listTagName = new ArrayList<String>();
                            listTagName.add((String)value);
                            listTagName.add(tagName);
                            mapTag.put(commitId, listTagName);
                            continue;
                        }
                        ((List)value).add(tagName);
                        continue;
                    }
                    mapTag.put(commitId, tagName);
                }
            }
            while ((commitString = bufferedReaderCommits.readLine()) != null) {
                int indexSplit = commitString.indexOf(32);
                String commitMessage = commitString.substring(indexSplit + 1);
                Map<String, String> mapCommitAttr = Util.getJsonAttr(commitMessage, null);
                if (mapCommitAttr.get(VERSION_ATTR_BASE_VERSION) != null) {
                    if (commitPaging != null) {
                        commitPaging.indDone = true;
                    }
                    break;
                }
                ScmPlugin.Commit commit = new ScmPlugin.Commit();
                commit.id = commitString.substring(0, indexSplit);
                if (enumSetGetListCommitFlag != null && enumSetGetListCommitFlag.contains(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MESSAGE)) {
                    commit.message = Util.getCommitMessageWithoutAttr(commitMessage);
                }
                if (enumSetGetListCommitFlag != null && enumSetGetListCommitFlag.contains(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR)) {
                    commit.mapAttr = mapCommitAttr;
                }
                if (enumSetGetListCommitFlag != null && enumSetGetListCommitFlag.contains(ScmPlugin.GetListCommitFlag.IND_INCLUDE_VERSION_STATIC)) {
                    Object value = mapTag.get(commit.id);
                    if (value != null) {
                        if (value instanceof String) {
                            commit.arrayVersionStatic = new Version[1];
                            commit.arrayVersionStatic[0] = new Version(VersionType.STATIC, (String)value);
                        } else {
                            List listTagName = (List)value;
                            commit.arrayVersionStatic = new Version[listTagName.size()];
                            for (int i = 0; i < listTagName.size(); ++i) {
                                commit.arrayVersionStatic[i] = new Version(VersionType.STATIC, (String)listTagName.get(i));
                            }
                        }
                    } else {
                        commit.arrayVersionStatic = new Version[0];
                    }
                }
                listCommit.add(commit);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (commitPaging != null) {
            commitPaging.returned = listCommit.size();
            if (commitPaging.returned == 0) {
                commitPaging.indDone = true;
            }
        }
        if (enumSetGetListCommitFlag != null && enumSetGetListCommitFlag.contains(ScmPlugin.GetListCommitFlag.IND_UPDATE_START_INDEX)) {
            if (commitPaging == null) {
                throw new RuntimeException("Request to update startIndex but commitPaging is null.");
            }
            commitPaging.startIndex += commitPaging.returned;
        }
        return listCommit;
    }

    public ScmPlugin.BaseVersion getBaseVersion(Version version) {
        Map<String, String> mapVersionAttr = this.getMapVersionAttr(version);
        String stringBaseVersion = mapVersionAttr.get(VERSION_ATTR_BASE_VERSION);
        if (stringBaseVersion != null) {
            ScmPlugin.BaseVersion baseVersion = new ScmPlugin.BaseVersion();
            baseVersion.version = version;
            baseVersion.versionBase = new Version(stringBaseVersion);
            baseVersion.commitId = mapVersionAttr.get(VERSION_ATTR_BASE_VERSION_COMMIT_ID);
            return baseVersion;
        }
        return null;
    }

    public List<Version> getListVersionStatic() {
        Git git = this.getGit();
        return git.getListVersionStatic(this.getPathModuleWorkspace());
    }

    public void switchVersion(Path pathModuleWorkspace, Version version) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        if (!this.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.ALL_CHANGES, false)) {
            throw new RuntimeException("Working directory " + pathModuleWorkspace + " must be synchronized before switching to a new version.");
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        WorkspaceDir workspaceDir = workspacePlugin.getWorkspaceDirFromPath(pathModuleWorkspace);
        if (!(workspaceDir instanceof WorkspaceDirUserModuleVersion)) {
            throw new RuntimeException("Workspace directory " + pathModuleWorkspace + " must be a user workspace directory.");
        }
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        if (version.equals((Object)this.getVersion(pathModuleWorkspace))) {
            return;
        }
        git.checkout(pathModuleWorkspace, version);
        if (version.getVersionType() == VersionType.DYNAMIC && this.gitPull(pathModuleWorkspace)) {
            throw new RuntimeException("Conflicts were encountered while pulling changes into " + pathModuleWorkspace + ". This is not expected here.");
        }
        workspacePlugin.updateWorkspaceDir(workspaceDir, (WorkspaceDir)new WorkspaceDirUserModuleVersion(new ModuleVersion(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath(), version)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVersion(Path pathModuleWorkspace, Version versionTarget, Map<String, String> mapVersionAttr, boolean indSwitch) {
        String message;
        Git git = this.getGit();
        Version versionTempDynamicBase = this.getVersionTempDynamicBase(pathModuleWorkspace);
        if (versionTempDynamicBase == null && !this.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.ALL_CHANGES, false)) {
            throw new RuntimeException("Working directory " + pathModuleWorkspace + " must be synchronized before creating a new version.");
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        WorkspaceDir workspaceDir = workspacePlugin.getWorkspaceDirFromPath(pathModuleWorkspace);
        boolean indUserWorkspaceDir = workspaceDir instanceof WorkspaceDirUserModuleVersion;
        HashMap<Object, Object> mapVersionAttr2 = mapVersionAttr != null ? new HashMap<String, String>(mapVersionAttr) : new HashMap();
        if (versionTempDynamicBase == null) {
            mapVersionAttr2.put(VERSION_ATTR_BASE_VERSION, this.getVersion(pathModuleWorkspace).toString());
        } else {
            mapVersionAttr2.put(VERSION_ATTR_BASE_VERSION, versionTempDynamicBase.toString());
        }
        try {
            message = new ObjectMapper().writeValueAsString(mapVersionAttr2);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        message = message.replace("\"", "\\\"");
        switch (versionTarget.getVersionType()) {
            case DYNAMIC: {
                String branch = versionTarget.getVersion();
                git.createBranch(pathModuleWorkspace, branch, indSwitch);
                if (versionTempDynamicBase != null) {
                    ExecContextHolder.get().setTransientData(TRANSIENT_DATA_PREFIX_TEMP_DYNAMIC_VERSION_BASE + pathModuleWorkspace, null);
                }
                if (indSwitch && workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                    workspacePlugin.updateWorkspaceDir(workspaceDir, (WorkspaceDir)new WorkspaceDirUserModuleVersion(new ModuleVersion(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath(), versionTarget)));
                }
                if (!indSwitch) {
                    if (versionTempDynamicBase != null && indUserWorkspaceDir) {
                        git.checkout(pathModuleWorkspace, versionTempDynamicBase);
                    }
                    pathModuleWorkspace = this.checkoutSystem(versionTarget);
                }
                try {
                    message = message + " Dummy commit introduced to record the version attributes including the base version of the newly created version " + versionTarget + '.';
                    git.executeGitCommand(new String[]{"commit", "--allow-empty", "-m", message}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
                    this.push(pathModuleWorkspace, "refs/heads/" + branch);
                    this.getModule().raiseNodeEvent((NodeEvent)new DynamicVersionCreatedEvent(this.getModule(), versionTarget));
                    break;
                }
                finally {
                    if (!indSwitch) {
                        workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    }
                }
            }
            case STATIC: {
                String tag = versionTarget.getVersion();
                git.createTag(pathModuleWorkspace, tag, message);
                if (versionTempDynamicBase != null) {
                    ExecContextHolder.get().setTransientData(TRANSIENT_DATA_PREFIX_TEMP_DYNAMIC_VERSION_BASE + pathModuleWorkspace, null);
                }
                if (indSwitch) {
                    git.checkout(pathModuleWorkspace, versionTarget);
                    if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                        workspacePlugin.updateWorkspaceDir(workspaceDir, (WorkspaceDir)new WorkspaceDirUserModuleVersion(new ModuleVersion(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath(), versionTarget)));
                    }
                } else if (versionTempDynamicBase != null) {
                    git.checkout(pathModuleWorkspace, versionTempDynamicBase);
                }
                this.push(pathModuleWorkspace, "refs/tags/" + versionTarget.getVersion());
                this.getModule().raiseNodeEvent((NodeEvent)new StaticVersionCreatedEvent(this.getModule(), versionTarget));
                break;
            }
            default: {
                throw new RuntimeException("Invalid version type.");
            }
        }
    }

    public Map<String, String> getMapVersionAttr(Version version) {
        Git git = this.getGit();
        Path pathModuleWorkspace = this.getPathModuleWorkspace();
        Map<String, String> mapVersionAttr = new HashMap<String, String>();
        switch (version.getVersionType()) {
            case DYNAMIC: {
                StringBuilder stringBuilderCommits = new StringBuilder();
                git.executeGitCommand(new String[]{"rev-list", "--pretty=oneline", git.convertToRef(pathModuleWorkspace, version)}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, stringBuilderCommits, true);
                BufferedReader bufferedReaderCommits = new BufferedReader(new StringReader(stringBuilderCommits.toString()));
                try {
                    String commitString;
                    while ((commitString = bufferedReaderCommits.readLine()) != null) {
                        int indexSplit = commitString.indexOf(32);
                        String commitMessage = commitString.substring(indexSplit + 1);
                        mapVersionAttr = Util.getJsonAttr(commitMessage, mapVersionAttr);
                        String stringBaseVersion = mapVersionAttr.get(VERSION_ATTR_BASE_VERSION);
                        if (stringBaseVersion == null) continue;
                        commitString = bufferedReaderCommits.readLine();
                        mapVersionAttr.put(VERSION_ATTR_BASE_VERSION_COMMIT_ID, commitString.substring(0, commitString.indexOf(32)));
                        return mapVersionAttr;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return Collections.emptyMap();
            }
            case STATIC: {
                StringBuilder stringBuilder = new StringBuilder();
                git.executeGitCommand(new String[]{"tag", "-n", "-l", version.getVersion()}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, stringBuilder, true);
                if (stringBuilder.toString().isEmpty()) {
                    throw new RuntimeException("Static version " + version + " does not exist.");
                }
                String tagMessage = stringBuilder.toString().split("\\s+")[1];
                mapVersionAttr = Util.getJsonAttr(tagMessage, mapVersionAttr);
                stringBuilder.setLength(0);
                git.executeGitCommand(new String[]{"rev-parse", version.getVersion() + "^{}"}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, stringBuilder, true);
                if (stringBuilder.toString().isEmpty()) {
                    throw new RuntimeException("Static version " + version + " does not exist.");
                }
                mapVersionAttr.put(VERSION_ATTR_BASE_VERSION_COMMIT_ID, stringBuilder.toString());
            }
        }
        throw new RuntimeException("Invalid version type.");
    }

    public void createTempDynamicVersion(Path pathModuleWorkspace) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        Version versionCurrent = this.getVersion(pathModuleWorkspace);
        git.executeGitCommand(new String[]{"checkout", "--detach"}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
        ExecContextHolder.get().setTransientData(TRANSIENT_DATA_PREFIX_TEMP_DYNAMIC_VERSION_BASE + pathModuleWorkspace, (Object)versionCurrent);
    }

    public void releaseTempDynamicVersion(Path pathModuleWorkspace) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, true);
        Version versionTempDynamicBase = this.getVersionTempDynamicBase(pathModuleWorkspace);
        ExecContext execContext = ExecContextHolder.get();
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        git.checkout(pathModuleWorkspace, versionTempDynamicBase);
        execContext.setTransientData(TRANSIENT_DATA_PREFIX_TEMP_DYNAMIC_VERSION_BASE + pathModuleWorkspace, null);
    }

    private Version getVersionTempDynamicBase(Path pathModuleWorkspace) {
        return (Version)ExecContextHolder.get().getTransientData(TRANSIENT_DATA_PREFIX_TEMP_DYNAMIC_VERSION_BASE + pathModuleWorkspace);
    }

    public boolean isTempDynamicVersion(Version versionBase) {
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        NodePath nodePathModule = this.getModule().getNodePath();
        Path pathModuleWorkspace = this.getPathMainUserWorkspaceDir(nodePathModule);
        if (pathModuleWorkspace != null && this.getVersionTempDynamicBase(pathModuleWorkspace) != null) {
            return true;
        }
        WorkspaceDirSystemModule workspaceDirSystemModule = new WorkspaceDirSystemModule(nodePathModule);
        if (workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirSystemModule)) {
            pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirSystemModule, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.PEEK);
            return this.getVersionTempDynamicBase(pathModuleWorkspace) != null;
        }
        return false;
    }

    private void validateTempDynamicVersion(Path pathModuleWorkspace, boolean indTempDynamicVersionRequired) {
        boolean indTempDynamicVersion;
        boolean bl = indTempDynamicVersion = this.getVersionTempDynamicBase(pathModuleWorkspace) != null;
        if (indTempDynamicVersion ^ indTempDynamicVersion) {
            throw new RuntimeException("Mismatch between current temporary dynamic Version state " + indTempDynamicVersion + " and expected state " + indTempDynamicVersionRequired + " for workspace module path " + pathModuleWorkspace + '.');
        }
    }

    public void commit(Path pathModuleWorkspace, String message, Map<String, String> mapCommitAttr) {
        boolean indTempDynamicVersion;
        Git git = this.getGit();
        boolean bl = indTempDynamicVersion = this.getVersionTempDynamicBase(pathModuleWorkspace) != null;
        if (indTempDynamicVersion && !this.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.REMOTE_CHANGES_ONLY, false)) {
            throw new RuntimeException("Working directory " + pathModuleWorkspace + " must be synchronized with remote changes before committing.");
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        git.addCommit(pathModuleWorkspace, message, mapCommitAttr, false);
        if (!indTempDynamicVersion) {
            this.push(pathModuleWorkspace, "refs/heads/" + git.getBranch(pathModuleWorkspace));
        }
    }

    public ScmPlugin.MergeResult merge(Path pathModuleWorkspace, Version versionSrc, String message) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        Version versionDest = this.getVersion(pathModuleWorkspace);
        if (versionDest.getVersionType() == VersionType.STATIC) {
            throw new RuntimeException("Current version " + versionDest + " in working directory " + pathModuleWorkspace + " must be dynamic for merging into.");
        }
        if (!this.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.ALL_CHANGES, false)) {
            throw new RuntimeException("Working directory " + pathModuleWorkspace + " must be synchronized before merging.");
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        List<ScmPlugin.Commit> listCommit = this.getListCommitDiverge(versionSrc, versionDest, null, null);
        if (listCommit.isEmpty()) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_DIVERGING_COMMITS), pathModuleWorkspace, versionSrc, versionDest));
            return ScmPlugin.MergeResult.NOTHING_TO_MERGE;
        }
        String mergeMessage = "Merged " + versionSrc + " into " + versionDest + '.';
        if (message != null) {
            message = message.replace("\"", "\\\"");
            mergeMessage = message + '\n' + mergeMessage;
        }
        if (git.executeGitCommand(new String[]{"merge", "--no-edit", "--no-ff", "-m", mergeMessage, git.convertToRef(pathModuleWorkspace, versionSrc)}, false, Git.AllowExitCode.ONE, pathModuleWorkspace, null, false) == 1) {
            return ScmPlugin.MergeResult.CONFLICTS;
        }
        this.push(pathModuleWorkspace, "refs/heads/" + versionDest.getVersion());
        return ScmPlugin.MergeResult.MERGED;
    }

    public ScmPlugin.MergeResult mergeExcludeCommits(Path pathModuleWorkspace, Version versionSrc, List<ScmPlugin.Commit> listCommitExclude, String message) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        Version versionDest = this.getVersion(pathModuleWorkspace);
        if (versionDest.getVersionType() == VersionType.STATIC) {
            throw new RuntimeException("Current version " + versionDest + " in working directory " + pathModuleWorkspace + " must be dynamic for merging into.");
        }
        if (!this.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.ALL_CHANGES, false)) {
            throw new RuntimeException("Working directory " + pathModuleWorkspace + " must be synchronized before merging.");
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        try {
            int patchIndex;
            String lastCommitIdExclude;
            List<ScmPlugin.Commit> listCommit = this.getListCommitDiverge(versionSrc, versionDest, null, null);
            if (listCommit.isEmpty()) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_DIVERGING_COMMITS), pathModuleWorkspace, versionSrc, versionDest));
                return ScmPlugin.MergeResult.NOTHING_TO_MERGE;
            }
            String commitIdRangeStart = git.convertToRef(pathModuleWorkspace, versionDest);
            Collections.reverse(listCommit);
            Iterator<ScmPlugin.Commit> iteratorCommit = listCommit.iterator();
            int patchCount = 0;
            do {
                lastCommitIdExclude = null;
                String commitIdRangeEnd = null;
                block9: while (iteratorCommit.hasNext()) {
                    String commitId = iteratorCommit.next().id;
                    for (ScmPlugin.Commit commitExclude : listCommitExclude) {
                        if (!commitId.equals(commitExclude.id)) continue;
                        lastCommitIdExclude = commitId;
                        break block9;
                    }
                    commitIdRangeEnd = commitId;
                }
                if (commitIdRangeEnd == null) continue;
                StringBuilder stringBuilderPatch = new StringBuilder();
                git.executeGitCommand(new String[]{"diff", "--binary", commitIdRangeStart + ".." + commitIdRangeEnd}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, stringBuilderPatch, false);
                ++patchCount;
                try {
                    OutputStreamWriter outputStreamWriterPatch = new OutputStreamWriter(new FileOutputStream(pathModuleWorkspace.resolve("dragom-patch-" + String.format("%02d", patchCount) + ".patch").toFile()));
                    outputStreamWriterPatch.append(stringBuilderPatch);
                    outputStreamWriterPatch.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            } while ((commitIdRangeStart = lastCommitIdExclude) != null);
            if (patchCount == 0) {
                return ScmPlugin.MergeResult.NOTHING_TO_MERGE;
            }
            StringBuilder stringBuilderMergeMessage = new StringBuilder();
            if (message != null) {
                message = message.replace("\"", "\\\"");
                stringBuilderMergeMessage.append(message).append('\n');
            }
            stringBuilderMergeMessage.append("Merged ").append(versionSrc).append(" into ").append(versionDest).append(" excluding the following commits:\n");
            for (ScmPlugin.Commit commit : listCommitExclude) {
                stringBuilderMergeMessage.append(commit.id);
                if (commit.message != null) {
                    stringBuilderMergeMessage.append(' ').append(commit.message);
                }
                stringBuilderMergeMessage.append('\n');
            }
            if (!listCommitExclude.isEmpty()) {
                stringBuilderMergeMessage.setLength(stringBuilderMergeMessage.length() - 1);
            }
            git.executeGitCommand(new String[]{"merge", "--no-commit", "--strategy", "ours", "-m", stringBuilderMergeMessage.toString(), git.convertToRef(pathModuleWorkspace, versionSrc)}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
            for (patchIndex = 1; patchIndex <= patchCount; ++patchIndex) {
                String patchFileName = "dragom-patch-" + String.format("%02d", patchIndex) + ".patch";
                String patchFileNameCurrent = patchFileName + ".current";
                try {
                    FileUtils.moveFile((File)pathModuleWorkspace.resolve(patchFileName).toFile(), (File)pathModuleWorkspace.resolve(patchFileNameCurrent).toFile());
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                if (git.executeGitCommand(new String[]{"apply", "--3way", "--whitespace=nowarn", patchFileNameCurrent}, false, Git.AllowExitCode.ONE, pathModuleWorkspace, null, false) == 1) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_WARNING_MERGE_CONFLICTS), pathModuleWorkspace, versionSrc, versionDest));
                    return ScmPlugin.MergeResult.CONFLICTS;
                }
                try {
                    FileUtils.moveFile((File)pathModuleWorkspace.resolve(patchFileNameCurrent).toFile(), (File)pathModuleWorkspace.resolve(patchFileName + ".done").toFile());
                    continue;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            for (patchIndex = 1; patchIndex <= patchCount; ++patchIndex) {
                pathModuleWorkspace.resolve("dragom-patch-" + String.format("%02d", patchIndex) + ".patch.done").toFile().delete();
            }
            git.executeGitCommand(new String[]{"commit", "--no-edit"}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
            this.push(pathModuleWorkspace, "refs/heads/" + versionDest.getVersion());
            return ScmPlugin.MergeResult.MERGED;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("An unexpected exception occurred during the merge of version " + versionSrc + " into version " + versionDest + " within " + pathModuleWorkspace + ".\n" + "The merge has not been aborted and dragom-patch-##.patch files may still be present in the root of the workspace directory for the module.\n" + "IT IS VERY IMPORTANT that the merge operation not be completed with \"git commit\" as is.\n" + "If it is, the merge commit will tell Git that the merge is complete, whereas unmerged changes probably exist.\n" + "It MAY be possible to complete the merge process by manually applying the remaining patch files with \"git apply --3way <patch file>\" and \"git commit\".\n" + "But after investigating the problem it is preferable to abort the merge operation with \"git merge --abort\", reset the workspace directory with \"git reset --hard HEAD\" and perform the merge again.", re);
        }
    }

    public ScmPlugin.MergeResult replace(Path pathModuleWorkspace, Version versionSrc, String message) {
        Git git = this.getGit();
        this.validateTempDynamicVersion(pathModuleWorkspace, false);
        Version versionDest = this.getVersion(pathModuleWorkspace);
        if (versionDest.getVersionType() == VersionType.STATIC) {
            throw new RuntimeException("Current version " + versionDest + " in working directory " + pathModuleWorkspace + " must be dynamic for merging into.");
        }
        if (!this.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.ALL_CHANGES, false)) {
            throw new RuntimeException("Working directory " + pathModuleWorkspace + " must be synchronized before merging.");
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (workspacePlugin.getWorkspaceDirAccessMode(pathModuleWorkspace) != WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
            throw new RuntimeException(pathModuleWorkspace.toString() + " must be accessed for writing.");
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        if (git.executeGitCommand(new String[]{"diff", "--quiet", git.convertToRef(pathModuleWorkspace, versionSrc)}, false, Git.AllowExitCode.ONE, pathModuleWorkspace, null, false) == 0) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERSIONS_EQUAL), pathModuleWorkspace, versionSrc, versionDest));
            return ScmPlugin.MergeResult.NOTHING_TO_MERGE;
        }
        String mergeMessage = "Replaced version " + versionDest + " with version " + versionSrc + '.';
        if (message != null) {
            message = message.replace("\"", "\\\"");
            mergeMessage = message + '\n' + mergeMessage;
        }
        git.executeGitCommand(new String[]{"merge", "--strategy", "ours", "--no-commit", "-m", mergeMessage, git.convertToRef(pathModuleWorkspace, versionSrc)}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
        git.executeGitCommand(new String[]{"rm", "-r", "."}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
        git.executeGitCommand(new String[]{"checkout", git.convertToRef(pathModuleWorkspace, versionSrc), "."}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
        git.executeGitCommand(new String[]{"commit", "--no-edit"}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null, false);
        this.push(pathModuleWorkspace, "refs/heads/" + versionDest.getVersion());
        return ScmPlugin.MergeResult.MERGED;
    }

    public String getScmType() {
        return "git";
    }

    public String getScmUrl(Path pathModuleWorkspace) {
        return this.gitReposCompleteUrl;
    }

    private Git getGit() {
        ExecContext execContext = ExecContextHolder.get();
        Git git = (Git)execContext.getTransientData(TRANSIENT_DATA_PREFIX_GIT + this.getModule().getNodePath().toString());
        if (git != null) {
            return git;
        }
        git = ServiceLocator.getService(Git.class);
        git.setReposUrl(this.gitReposCompleteUrl);
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_GIT_PATH_EXECUTABLE);
        if (runtimeProperty != null) {
            git.setPathExecutable(Paths.get(runtimeProperty, new String[0]));
        }
        final String gitPathExecutable = runtimeProperty;
        runtimeProperty = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_GIT_HTTP_CREDENTIAL_HANDLING);
        HttpCredentialHandling httpCredentialHandling = runtimeProperty == null ? HttpCredentialHandling.ONLY_IF_HTTP : HttpCredentialHandling.valueOf(runtimeProperty);
        if (httpCredentialHandling != HttpCredentialHandling.NONE) {
            boolean isHttpProtocol = patternTestHttpProtocol.matcher(this.gitReposCompleteUrl).matches();
            if (httpCredentialHandling == HttpCredentialHandling.ALWAYS_HTTP && !isHttpProtocol) {
                throw new RuntimeException("Git repository URL " + this.gitReposCompleteUrl + " does not use the HTTP[S] protocol but the runtime property GIT_CREDENTIAL_HANDLING is ALWAYS_HTTP.");
            }
            if (isHttpProtocol) {
                runtimeProperty = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_GIT_HTTP_USER);
                final UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
                CredentialStorePlugin credentialStorePlugin = (CredentialStorePlugin)execContext.getExecContextPlugin(CredentialStorePlugin.class);
                CredentialStorePlugin.Credentials credentials = credentialStorePlugin.getCredentials(this.gitReposCompleteUrl, runtimeProperty, new CredentialStorePlugin.CredentialValidator(){

                    public boolean validateCredentials(String resource, String user, String password) {
                        Git git = ServiceLocator.getService(Git.class);
                        if (gitPathExecutable != null) {
                            git.setPathExecutable(Paths.get(gitPathExecutable, new String[0]));
                        }
                        git.setReposUrl(GitScmPluginImpl.this.gitReposCompleteUrl);
                        git.setUser(user);
                        git.setPassword(password);
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(GitScmPluginImpl.MSG_PATTERN_KEY_ACCESS_REMOTE_REPOS), GitScmPluginImpl.this.gitReposCompleteUrl, "ls-remote (validateCredentials), " + user));
                        return git.validateCredentials();
                    }
                });
                git.setUser(credentials.user);
                git.setPassword(credentials.password);
            }
        }
        execContext.setTransientData(TRANSIENT_DATA_PREFIX_GIT + this.getModule().getNodePath().toString(), (Object)git);
        return git;
    }

    private Path getPathMainUserWorkspaceDir(NodePath nodePathModule) {
        ExecContext execContext = ExecContextHolder.get();
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
        String stringPathMainWorkspaceDir = execContext.getProperty(EXEC_CONTEXT_PROPERTY_PREFIX_MAIN_WORKSPACE_DIR + this.getModule().getNodePath().getPropertyNameSegment());
        if (stringPathMainWorkspaceDir == null) {
            return null;
        }
        Path pathMainUserWorkspaceDir = workspacePlugin.getPathWorkspace().resolve(stringPathMainWorkspaceDir);
        if (!(workspacePlugin.isPathWorkspaceDirExists(pathMainUserWorkspaceDir) && workspacePlugin.getWorkspaceDirFromPath(pathMainUserWorkspaceDir) instanceof WorkspaceDirUserModuleVersion && ((WorkspaceDirUserModuleVersion)workspacePlugin.getWorkspaceDirFromPath(pathMainUserWorkspaceDir)).getModuleVersion().getNodePath().equals((Object)nodePathModule))) {
            Set setWorkspaceDir = workspacePlugin.getSetWorkspaceDir((WorkspaceDir)new WorkspaceDirUserModuleVersion(new ModuleVersion(nodePathModule)));
            if (!setWorkspaceDir.isEmpty()) {
                WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = (WorkspaceDirUserModuleVersion)setWorkspaceDir.iterator().next();
                pathMainUserWorkspaceDir = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ);
                workspacePlugin.releaseWorkspaceDir(pathMainUserWorkspaceDir);
            } else {
                pathMainUserWorkspaceDir = null;
            }
            this.setPathMainUserWorkspaceDir(nodePathModule, pathMainUserWorkspaceDir);
        }
        return pathMainUserWorkspaceDir;
    }

    private void setPathMainUserWorkspaceDir(NodePath nodePathModule, Path pathMainUserWorkspaceDir) {
        ExecContext execContext = ExecContextHolder.get();
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
        if (pathMainUserWorkspaceDir == null) {
            execContext.setProperty(EXEC_CONTEXT_PROPERTY_PREFIX_MAIN_WORKSPACE_DIR + this.getModule().getNodePath().getPropertyNameSegment(), null);
        } else {
            execContext.setProperty(EXEC_CONTEXT_PROPERTY_PREFIX_MAIN_WORKSPACE_DIR + this.getModule().getNodePath().getPropertyNameSegment(), workspacePlugin.getPathWorkspace().relativize(pathMainUserWorkspaceDir).toString());
        }
    }

    private FetchPushBehavior getFetchPushBehavior() {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        String fetchPushBehavior = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_GIT_FETCH_PUSH_BEHAVIOR);
        if (fetchPushBehavior == null) {
            return FetchPushBehavior.FETCH_PUSH;
        }
        return FetchPushBehavior.valueOf(fetchPushBehavior);
    }

    private boolean mustFetch(Path pathModuleWorkspace) {
        switch (this.getFetchPushBehavior()) {
            case NO_FETCH_NO_PUSH: {
                logger.trace("Fetching is disabled for module " + this.getModule() + " within " + pathModuleWorkspace + '.');
                return false;
            }
            case FETCH_NO_PUSH: 
            case FETCH_PUSH: {
                boolean indMustFetch;
                ExecContext execContext = ExecContextHolder.get();
                Set setPathAlreadyFetched = (Set)execContext.getTransientData(TRANSIENT_DATA_PATH_ALREADY_FETCHED);
                if (setPathAlreadyFetched == null) {
                    indMustFetch = true;
                } else {
                    boolean bl = indMustFetch = !setPathAlreadyFetched.contains(pathModuleWorkspace);
                }
                if (indMustFetch) {
                    logger.trace("Fetching is enabled only once for module " + this.getModule() + " within " + pathModuleWorkspace + '.');
                } else {
                    logger.trace("Fetching is now disabled for module " + this.getModule() + " within " + pathModuleWorkspace + '.');
                }
                return indMustFetch;
            }
        }
        throw new RuntimeException("Invalid fetch behavior.");
    }

    private void hasFetched(Path pathWorkspace) {
        if (this.getFetchPushBehavior().isFetch()) {
            ExecContext execContext = ExecContextHolder.get();
            HashSet<Path> setPathAlreadyFetched = (HashSet<Path>)execContext.getTransientData(TRANSIENT_DATA_PATH_ALREADY_FETCHED);
            if (setPathAlreadyFetched == null) {
                setPathAlreadyFetched = new HashSet<Path>();
                execContext.setTransientData(TRANSIENT_DATA_PATH_ALREADY_FETCHED, setPathAlreadyFetched);
            }
            setPathAlreadyFetched.add(pathWorkspace);
        }
    }

    private boolean isPushAll() {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        return Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_GIT_IND_PUSH_ALL));
    }

    private static enum FetchPushBehavior {
        NO_FETCH_NO_PUSH,
        FETCH_NO_PUSH,
        FETCH_PUSH;


        private boolean isFetch() {
            return this != NO_FETCH_NO_PUSH;
        }

        private boolean isPush() {
            return this == FETCH_PUSH;
        }
    }

    private static enum HttpCredentialHandling {
        NONE,
        ONLY_IF_HTTP,
        ALWAYS_HTTP;

    }
}

