/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigArtifactVersionMapperPluginImpl
extends ModulePluginAbstractImpl
implements ArtifactVersionMapperPlugin {
    private static final Logger logger = LoggerFactory.getLogger(ConfigArtifactVersionMapperPluginImpl.class);
    private static final String RUNTIME_PROPERTY_ARTIFACT_VERSION_TO_VERSION_MAPPINGS = "ARTIFACT_VERSION_TO_VERSION_MAPPINGS";
    private static final String RUNTIME_PROPERTY_PREFIX_ARTIFACT_VERSION_TO_VERSION_MAPPING_GROUP = "ARTIFACT_VERSION_TO_VERSION_MAPPING_GROUP.";
    private static final String RUNTIME_PROPERTY_PREFIX_ARTIFACT_VERSION_TO_VERSION_MAPPING = "ARTIFACT_VERSION_TO_VERSION_MAPPING.";
    private static final String RUNTIME_PROPERTY_PREFIX_ARTIFACT_VERSION_TO_VERSION_MAPPING_TEST_EXISTENCE = "ARTIFACT_VERSION_TO_VERSION_MAPPING_TEST_EXISTENCE.";
    private static final String RUNTIME_PROPERTY_VERSION_TO_ARTIFACT_VERSION_MAPPINGS = "VERSION_TO_ARTIFACT_VERSION_MAPPINGS";
    private static final String RUNTIME_PROPERTY_PREFIX_VERSION_TO_ARTIFACT_VERSION_MAPPING_GROUP = "VERSION_TO_ARTIFACT_VERSION_MAPPING_GROUP.";
    private static final String RUNTIME_PROPERTY_PREFIX_VERSION_TO_ARTIFACT_VERSION_MAPPING = "VERSION_TO_ARTIFACT_VERSION_MAPPING.";
    private static final String RUNTIME_PROPERTY_PREFIX_VERSION_TO_ARTIFACT_VERSION_MAPPING_ADD_PHASE = "VERSION_TO_ARTIFACT_VERSION_MAPPING_ADD_PHASE.";
    private static final String RUNTIME_PROPERTY_PHASE = "PHASE";
    private static final String RUNTIME_PROPERTY_CAN_REUSE_PHASE = "CAN_REUSE_PHASE";
    private static final String TRANSIENT_DATA_PREFIX_LIST_ARTIFACT_VERSION_TO_VERSION_MAPPING = ConfigArtifactVersionMapperPluginImpl.class.getName() + ".ListArtifactVersionToVersionMapping.";
    private static final String TRANSIENT_DATA_PREFIX_LIST_VERSION_TO_ARTIFACT_VERSION_MAPPING = ConfigArtifactVersionMapperPluginImpl.class.getName() + ".ListVersionToArtifactVersionMapping.";
    private static final String MSG_PATTERN_KEY_INPUT_PHASE = "INPUT_PHASE";
    private static final String MSG_PATTERN_KEY_INPUT_PHASE_WITH_DEFAULT = "INPUT_PHASE_WITH_DEFAULT";
    private static final String MSG_PATTERN_KEY_REUSE_PHASE = "REUSE_PHASE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ConfigArtifactVersionMapperPluginImpl.class.getName() + "ResourceBundle");

    public ConfigArtifactVersionMapperPluginImpl(Module module) {
        super(module);
    }

    public Version mapArtifactVersionToVersion(ArtifactVersion artifactVersion) {
        ScmPlugin scmPlugin = (ScmPlugin)this.getModule().getNodePlugin(ScmPlugin.class, null);
        for (VersionMapping versionMapping : this.getListVersionMappingArtifactVersionToVersion()) {
            logger.debug("Attempting to match ArtifactVersion {} to version matching pattern {}.", (Object)artifactVersion, (Object)versionMapping.patternSrcVersion);
            Matcher matcher = versionMapping.patternSrcVersion.matcher(artifactVersion.toString());
            if (!matcher.matches()) continue;
            Version version = new Version(matcher.replaceAll(versionMapping.destinationVersion));
            if (versionMapping.indTestExistence) {
                if (scmPlugin.isVersionExists(version)) {
                    logger.debug("ArtifactVersion {} mapped to version {} which exists.", (Object)artifactVersion, (Object)version);
                    return version;
                }
                logger.debug("ArtifactVersion {} mapped to version {} which does not exist and is therefore skipped.", (Object)artifactVersion, (Object)version);
                continue;
            }
            logger.debug("ArtifactVersion {} mapped to version {}.", (Object)artifactVersion, (Object)version);
            return version;
        }
        throw new RuntimeException("No corresponding Version is mapped to ArtifactVersion " + artifactVersion + " for Module " + this.getModule() + '.');
    }

    public ArtifactVersion mapVersionToArtifactVersion(Version version) {
        for (VersionMapping versionMapping : this.getListVersionMappingVersionToArtifactVersion()) {
            logger.debug("Attempting to match Version {} to Version matching pattern {}.", (Object)version, (Object)versionMapping.patternSrcVersion);
            Matcher matcher = versionMapping.patternSrcVersion.matcher(version.toString());
            if (!matcher.matches()) continue;
            String stringArtifactVersion = matcher.replaceAll(versionMapping.destinationVersion);
            logger.debug("Version {} mapped to ArtifactVersion {}.", (Object)version, (Object)stringArtifactVersion);
            if (versionMapping.indAddPhase) {
                int indexPhase;
                ExecContext execContext = ExecContextHolder.get();
                RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
                UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
                String phase = (String)execContext.getTransientData(ConfigArtifactVersionMapperPluginImpl.class.getName() + '.' + this.getModule() + ".Phase");
                if (phase == null) {
                    phase = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_PHASE);
                    AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReusePhase = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_CAN_REUSE_PHASE));
                    if (phase == null && alwaysNeverAskUserResponseCanReusePhase.isAlways()) {
                        alwaysNeverAskUserResponseCanReusePhase = AlwaysNeverAskUserResponse.YES_ASK;
                    }
                    if (!alwaysNeverAskUserResponseCanReusePhase.isAlways()) {
                        phase = phase == null ? userInteractionCallbackPlugin.getInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_PHASE), this.getModule(), version, stringArtifactVersion)) : userInteractionCallbackPlugin.getInfoWithDefault(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_PHASE_WITH_DEFAULT), this.getModule(), version, stringArtifactVersion, phase), phase);
                        runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_PHASE, phase);
                        Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CAN_REUSE_PHASE, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REUSE_PHASE), phase));
                    }
                    execContext.setTransientData(ConfigArtifactVersionMapperPluginImpl.class.getName() + '.' + this.getModule() + ".Phase", (Object)phase);
                }
                if ((indexPhase = stringArtifactVersion.indexOf("@PHASE")) == -1) {
                    throw new RuntimeException("Version regex " + versionMapping.patternSrcVersion + " to ArtifactVersion " + versionMapping.destinationVersion + " for module " + this.getModule() + " specified to add a phase but the destination version does not contain the @{PHASE} parameter.");
                }
                logger.debug("@PHASE within ArtifactVersion {} replaced with {}.", (Object)stringArtifactVersion, (Object)phase);
                return new ArtifactVersion(stringArtifactVersion.substring(0, indexPhase) + phase + stringArtifactVersion.substring(indexPhase + 6));
            }
            return new ArtifactVersion(stringArtifactVersion);
        }
        throw new RuntimeException("No corresponding ArtifactVersion is mapped to Version " + version + " for Module " + this.getModule() + '.');
    }

    private List<VersionMapping> getListVersionMappingArtifactVersionToVersion() {
        ExecContext execContext = ExecContextHolder.get();
        Module module = this.getModule();
        ArrayList<VersionMapping> listVersionMapping = (ArrayList<VersionMapping>)execContext.getTransientData(TRANSIENT_DATA_PREFIX_LIST_VERSION_TO_ARTIFACT_VERSION_MAPPING + module.getNodePath());
        if (listVersionMapping != null) {
            return listVersionMapping;
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        listVersionMapping = new ArrayList<VersionMapping>();
        List<String> listMappingKey = this.getListMappingKey(RUNTIME_PROPERTY_ARTIFACT_VERSION_TO_VERSION_MAPPINGS, RUNTIME_PROPERTY_PREFIX_ARTIFACT_VERSION_TO_VERSION_MAPPING_GROUP);
        for (String mappingKey : listMappingKey) {
            String property = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_PREFIX_ARTIFACT_VERSION_TO_VERSION_MAPPING + mappingKey);
            if (property == null) {
                throw new RuntimeException("The runtime property ARTIFACT_VERSION_TO_VERSION_MAPPING." + mappingKey + " is not defined for module " + module + '.');
            }
            String[] arrayMappingComponent = property.split(":");
            if (arrayMappingComponent.length != 2) {
                throw new RuntimeException("The mapping " + property + " is not composed of two components separated by \":\".");
            }
            VersionMapping versionMapping = new VersionMapping();
            versionMapping.patternSrcVersion = Pattern.compile(arrayMappingComponent[0]);
            versionMapping.destinationVersion = arrayMappingComponent[1];
            property = module.getProperty(RUNTIME_PROPERTY_PREFIX_ARTIFACT_VERSION_TO_VERSION_MAPPING_TEST_EXISTENCE + mappingKey);
            versionMapping.indTestExistence = Util.isNotNullAndTrue(property);
            listVersionMapping.add(versionMapping);
        }
        execContext.setTransientData(TRANSIENT_DATA_PREFIX_LIST_VERSION_TO_ARTIFACT_VERSION_MAPPING + module.getNodePath(), listVersionMapping);
        return listVersionMapping;
    }

    private List<VersionMapping> getListVersionMappingVersionToArtifactVersion() {
        ExecContext execContext = ExecContextHolder.get();
        Module module = this.getModule();
        ArrayList<VersionMapping> listVersionMapping = (ArrayList<VersionMapping>)execContext.getTransientData(TRANSIENT_DATA_PREFIX_LIST_ARTIFACT_VERSION_TO_VERSION_MAPPING + module.getNodePath());
        if (listVersionMapping != null) {
            return listVersionMapping;
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        listVersionMapping = new ArrayList<VersionMapping>();
        List<String> listMappingKey = this.getListMappingKey(RUNTIME_PROPERTY_VERSION_TO_ARTIFACT_VERSION_MAPPINGS, RUNTIME_PROPERTY_PREFIX_VERSION_TO_ARTIFACT_VERSION_MAPPING_GROUP);
        for (String mappingKey : listMappingKey) {
            String property = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_PREFIX_VERSION_TO_ARTIFACT_VERSION_MAPPING + mappingKey);
            if (property == null) {
                throw new RuntimeException("The runtime property VERSION_TO_ARTIFACT_VERSION_MAPPING." + mappingKey + " is not defined for module " + module + '.');
            }
            String[] arrayMappingComponent = property.split(":");
            if (arrayMappingComponent.length != 2) {
                throw new RuntimeException("The mapping " + property + " is not composed of two components separated by \":\".");
            }
            VersionMapping versionMapping = new VersionMapping();
            versionMapping.patternSrcVersion = Pattern.compile(arrayMappingComponent[0]);
            versionMapping.destinationVersion = arrayMappingComponent[1];
            property = module.getProperty(RUNTIME_PROPERTY_PREFIX_VERSION_TO_ARTIFACT_VERSION_MAPPING_ADD_PHASE + mappingKey);
            versionMapping.indAddPhase = Util.isNotNullAndTrue(property);
            listVersionMapping.add(versionMapping);
        }
        execContext.setTransientData(TRANSIENT_DATA_PREFIX_LIST_ARTIFACT_VERSION_TO_VERSION_MAPPING + module.getNodePath(), listVersionMapping);
        return listVersionMapping;
    }

    private List<String> getListMappingKey(String runtimePropertyMappingKeys, String runtimePropertyMappingGroupPrefix) {
        String[] arrayMappingKey;
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        Module module = this.getModule();
        ArrayList<String> listMappingKey = new ArrayList<String>();
        String mappingKeys = runtimePropertiesPlugin.getProperty((Node)module, runtimePropertyMappingKeys);
        if (mappingKeys == null) {
            throw new RuntimeException("The runtime property " + runtimePropertyMappingKeys + " is not defined for module " + module + '.');
        }
        for (String mappingKey : arrayMappingKey = mappingKeys.split(",")) {
            if ((mappingKey = mappingKey.trim()).startsWith("$")) {
                listMappingKey.addAll(this.getListMappingKey(runtimePropertyMappingGroupPrefix + mappingKey.substring(1), runtimePropertyMappingGroupPrefix));
                continue;
            }
            listMappingKey.add(mappingKey);
        }
        return listMappingKey;
    }

    private static class VersionMapping {
        Pattern patternSrcVersion;
        String destinationVersion;
        boolean indTestExistence;
        boolean indAddPhase;

        private VersionMapping() {
        }
    }
}

