/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.xml;

import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.plugin.NodePlugin;
import org.azyva.dragom.util.Util;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="plugin")
public class XmlPluginDefConfig
implements PluginDefConfig {
    @XmlElement(name="plugin-interface")
    private String stringClassNodePluginXml;
    private Class<? extends NodePlugin> classNodePlugin;
    @XmlElement(name="plugin-id")
    private String pluginIdXml;
    private String pluginId;
    @XmlElement(name="plugin-class")
    private String pluginClass;
    @XmlElement(name="ind-only-this-node")
    private boolean indOnlyThisNode;

    public XmlPluginDefConfig() {
    }

    public XmlPluginDefConfig(Class<? extends NodePlugin> classNodePlugin, String pluginId, String pluginClass) {
        if (this.pluginClass == null || this.pluginClass.isEmpty()) {
            throw new RuntimeException("PluginDef cannot specify a null or empty plugin class.");
        }
        this.pluginId = pluginId;
        this.pluginClass = pluginClass;
        try {
            Class.forName(this.pluginClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (classNodePlugin == null) {
            this.classNodePlugin = Util.getDefaultClassNodePlugin(this.pluginClass);
        } else {
            classNodePlugin.asSubclass(NodePlugin.class);
            this.classNodePlugin = classNodePlugin;
        }
        this.pluginClass = pluginClass;
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.pluginClass == null || this.pluginClass.isEmpty()) {
            throw new RuntimeException("PluginDef cannot specify a null or empty plugin class.");
        }
        try {
            Class.forName(this.pluginClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (this.stringClassNodePluginXml == null) {
            this.classNodePlugin = Util.getDefaultClassNodePlugin(this.pluginClass);
        } else {
            try {
                this.classNodePlugin = Class.forName(this.stringClassNodePluginXml).asSubclass(NodePlugin.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
        this.pluginId = this.pluginIdXml == null ? Util.getDefaultPluginId(this.classNodePlugin, this.pluginClass) : this.pluginIdXml;
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.stringClassNodePluginXml = this.classNodePlugin.getName();
        this.pluginIdXml = this.pluginId;
    }

    public Class<? extends NodePlugin> getClassNodePlugin() {
        return this.classNodePlugin;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public boolean isOnlyThisNode() {
        return this.indOnlyThisNode;
    }

    public String toString() {
        return "XmlPluginDefConfig [classNodePlugin=" + this.classNodePlugin.getName() + ", pluginId=" + this.pluginId + ", pluginClass=" + this.pluginClass + ", indOnlyThisNode=" + this.indOnlyThisNode + "]";
    }
}

