/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.simple;

import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.plugin.NodePlugin;
import org.azyva.dragom.util.Util;

public class SimplePluginDefConfig
implements PluginDefConfig {
    private Class<? extends NodePlugin> classNodePlugin;
    private String pluginId;
    private String pluginClass;
    private boolean indOnlyThisNode;

    protected SimplePluginDefConfig() {
    }

    public SimplePluginDefConfig(Class<? extends NodePlugin> classNodePlugin, String pluginId, String pluginClass, boolean indOnlyThisNode) {
        if (this.pluginClass == null || this.pluginClass.isEmpty()) {
            throw new RuntimeException("PluginDef cannot specify a null or empty plugin class.");
        }
        this.pluginId = pluginId;
        this.pluginClass = pluginClass;
        try {
            Class.forName(this.pluginClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (classNodePlugin == null) {
            this.classNodePlugin = Util.getDefaultClassNodePlugin(this.pluginClass);
        } else {
            classNodePlugin.asSubclass(NodePlugin.class);
            this.classNodePlugin = classNodePlugin;
        }
        this.pluginClass = pluginClass;
    }

    public Class<? extends NodePlugin> getClassNodePlugin() {
        return this.classNodePlugin;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public boolean isOnlyThisNode() {
        return this.indOnlyThisNode;
    }

    public String toString() {
        return "SimplePluginDefConfig [classNodePlugin=" + this.classNodePlugin.getName() + ", pluginId=" + this.pluginId + ", pluginClass=" + this.pluginClass + ", indOnlyThisNode=" + this.indOnlyThisNode + "]";
    }
}

