/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.simple;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.azyva.dragom.model.config.DuplicateNodeException;
import org.azyva.dragom.model.config.MutableNodeConfig;
import org.azyva.dragom.model.config.NodeConfig;
import org.azyva.dragom.model.config.NodeConfigTransferObject;
import org.azyva.dragom.model.config.OptimisticLockException;
import org.azyva.dragom.model.config.OptimisticLockHandle;
import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.config.PluginKey;
import org.azyva.dragom.model.config.PropertyDefConfig;
import org.azyva.dragom.model.config.impl.simple.SimpleClassificationNodeConfig;
import org.azyva.dragom.model.config.impl.simple.SimpleNodeConfigTransferObject;
import org.azyva.dragom.model.config.impl.simple.SimpleOptimisticLockHandle;
import org.azyva.dragom.model.plugin.NodePlugin;

public abstract class SimpleNodeConfig
implements NodeConfig,
MutableNodeConfig {
    protected boolean indNew = true;
    private SimpleClassificationNodeConfig simpleClassificationNodeConfigParent;
    protected int revision;
    private String name;
    private Map<String, PropertyDefConfig> mapPropertyDefConfig;
    private Map<PluginKey, PluginDefConfig> mapPluginDefConfig;

    SimpleNodeConfig(SimpleClassificationNodeConfig simpleClassificationNodeConfigParent) {
        this.simpleClassificationNodeConfigParent = simpleClassificationNodeConfigParent;
        this.revision = 1;
        this.mapPropertyDefConfig = new LinkedHashMap<String, PropertyDefConfig>();
        this.mapPluginDefConfig = new LinkedHashMap<PluginKey, PluginDefConfig>();
    }

    public String getName() {
        return this.name;
    }

    public PropertyDefConfig getPropertyDefConfig(String name) {
        return this.mapPropertyDefConfig.get(name);
    }

    public boolean isPropertyExists(String name) {
        return this.mapPropertyDefConfig.containsKey(name);
    }

    public List<PropertyDefConfig> getListPropertyDefConfig() {
        return new ArrayList<PropertyDefConfig>(this.mapPropertyDefConfig.values());
    }

    public PluginDefConfig getPluginDefConfig(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        return this.mapPluginDefConfig.get(new PluginKey(classNodePlugin, pluginId));
    }

    public boolean isPluginDefConfigExists(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        return this.mapPluginDefConfig.containsKey(new PluginKey(classNodePlugin, pluginId));
    }

    public List<PluginDefConfig> getListPluginDefConfig() {
        return new ArrayList<PluginDefConfig>(this.mapPluginDefConfig.values());
    }

    public boolean isNew() {
        return this.indNew;
    }

    protected void checkOptimisticLock(OptimisticLockHandle optimisticLockHandle, boolean indRequireLock) {
        if (optimisticLockHandle != null) {
            if (optimisticLockHandle.isLocked()) {
                if (((SimpleOptimisticLockHandle)optimisticLockHandle).getRevision() != this.revision) {
                    throw new OptimisticLockException();
                }
            } else {
                if (indRequireLock) {
                    throw new RuntimeException("Lock required.");
                }
                ((SimpleOptimisticLockHandle)optimisticLockHandle).setRevision(this.revision);
            }
        }
    }

    public OptimisticLockHandle createOptimisticLockHandle(boolean indLock) {
        return new SimpleOptimisticLockHandle(indLock ? this.revision : 0);
    }

    public boolean isOptimisticLockValid(OptimisticLockHandle optimisticLockHandle) {
        return ((SimpleOptimisticLockHandle)optimisticLockHandle).getRevision() == this.revision;
    }

    public NodeConfigTransferObject getNodeConfigTransferObject(OptimisticLockHandle optimisticLockHandle) throws OptimisticLockException {
        this.checkOptimisticLock(optimisticLockHandle, false);
        SimpleNodeConfigTransferObject nodeConfigTransferObject = new SimpleNodeConfigTransferObject();
        nodeConfigTransferObject.setName(this.name);
        for (PropertyDefConfig propertyDefConfig : this.mapPropertyDefConfig.values()) {
            nodeConfigTransferObject.setPropertyDefConfig(propertyDefConfig);
        }
        for (PluginDefConfig pluginDefConfig : this.mapPluginDefConfig.values()) {
            nodeConfigTransferObject.setPluginDefConfig(pluginDefConfig);
        }
        return nodeConfigTransferObject;
    }

    protected void extractNodeConfigTransferObject(NodeConfigTransferObject nodeConfigTransferObject, OptimisticLockHandle optimisticLockHandle) throws DuplicateNodeException {
        this.checkOptimisticLock(optimisticLockHandle, !this.indNew);
        if (nodeConfigTransferObject.getName() == null && this.simpleClassificationNodeConfigParent != null) {
            throw new RuntimeException("Name of NodeConfigTrnmsferObject must not be null for non-root SimpleClassificationNodeConfig.");
        }
        String previousName = this.name;
        this.name = nodeConfigTransferObject.getName();
        if (this.indNew) {
            if (this.simpleClassificationNodeConfigParent != null) {
                this.simpleClassificationNodeConfigParent.setSimpleNodeConfigChild(this);
            }
        } else if (this.simpleClassificationNodeConfigParent != null && !this.name.equals(previousName)) {
            this.simpleClassificationNodeConfigParent.renameSimpleNodeConfigChild(previousName, this.name);
        }
        this.mapPropertyDefConfig.clear();
        for (PropertyDefConfig propertyDefConfig : nodeConfigTransferObject.getListPropertyDefConfig()) {
            this.mapPropertyDefConfig.put(propertyDefConfig.getName(), propertyDefConfig);
        }
        this.mapPluginDefConfig.clear();
        for (PluginDefConfig pluginDefConfig : nodeConfigTransferObject.getListPluginDefConfig()) {
            this.mapPluginDefConfig.put(new PluginKey(pluginDefConfig.getClassNodePlugin(), pluginDefConfig.getPluginId()), pluginDefConfig);
        }
        if (!this.indNew) {
            ++this.revision;
        }
        if (optimisticLockHandle != null) {
            ((SimpleOptimisticLockHandle)optimisticLockHandle).setRevision(this.revision);
        }
    }

    public void delete() {
        if (!this.indNew && this.simpleClassificationNodeConfigParent != null) {
            this.simpleClassificationNodeConfigParent.removeChildNodeConfig(this.name);
            this.simpleClassificationNodeConfigParent = null;
        }
    }
}

