/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.reference.ReferencePathMatcher;
import org.azyva.dragom.reference.ReferencePathMatcherAll;
import org.azyva.dragom.reference.ReferencePathMatcherAnd;
import org.azyva.dragom.reference.ReferencePathMatcherVersionAttribute;
import org.azyva.dragom.util.ModuleReentryAvoider;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootModuleVersionJobAbstractImpl {
    private static final Logger logger = LoggerFactory.getLogger(RootModuleVersionJobAbstractImpl.class);
    protected static final String RUNTIME_PROPERTY_SYNC_WORKSPACE_DIR = "SYNC_WORKSPACE_DIR";
    protected static final String RUNTIME_PROPERTY_PROJECT_CODE = "PROJECT_CODE";
    protected static final String MSG_PATTERN_KEY_ROOT_MODULE_VERSION_NOT_KNOWN = "ROOT_MODULE_VERSION_NOT_KNOWN";
    protected static final String MSG_PATTERN_KEY_MULTIPLE_WORKSPACE_DIRECTORIES_FOR_MODULE = "MULTIPLE_WORKSPACE_DIRECTORIES_FOR_MODULE";
    protected static final String MSG_PATTERN_KEY_UPDATE_ROOT_MODULE_VERSION_TO_WORKSPACE_DIRECTORY_VERSION = "UPDATE_ROOT_MODULE_VERSION_TO_WORKSPACE_DIRECTORY_VERSION";
    protected static final String MSG_PATTERN_KEY_UPDATE_ROOT_MODULE_VERSION_TO_DEFAULT = "UPDATE_ROOT_MODULE_VERSION_TO_DEFAULT";
    protected static final String MSG_PATTERN_KEY_VERSION_DOES_NOT_EXIST = "VERSION_DOES_NOT_EXIST";
    protected static final String MSG_PATTERN_KEY_INITIATING_TRAVERSAL_REFERENCE_GRAPH_ROOT_MODULE_VERSION = "INITIATING_TRAVERSAL_REFERENCE_GRAPH_ROOT_MODULE_VERSION";
    protected static final String MSG_PATTERN_KEY_TRAVERSAL_REFERENCE_GRAPH_ROOT_MODULE_VERSION_COMPLETED = "TRAVERSAL_REFERENCE_GRAPH_ROOT_MODULE_VERSION_COMPLETED";
    protected static final String MSG_PATTERN_KEY_UPDATE_CHANGED_ROOT_MODULE_VERSION = "UPDATE_CHANGED_ROOT_MODULE_VERSION";
    protected static final String MSG_PATTERN_KEY_VISITING_LEAF_MODULE_VERSION = "VISITING_LEAF_MODULE_VERSION";
    protected static final String MSG_PATTERN_KEY_CANNOT_PROCEED_WITH_UNSYNC_LOCAL_CHANGES = "CANNOT_PROCEED_WITH_UNSYNC_LOCAL_CHANGES";
    protected static final String MSG_PATTERN_KEY_DO_YOU_WANT_TO_UPDATE_UNSYNC_REMOTE_CHANGES = "DO_YOU_WANT_TO_UPDATE_UNSYNC_REMOTE_CHANGES";
    protected static final String MSG_PATTERN_KEY_UPDATING = "UPDATING";
    protected static final String MSG_PATTERN_KEY_CONFLICTS_WHILE_UPDATING = "CONFLICTS_WHILE_UPDATING";
    protected static final String MSG_PATTERN_KEY_VISITING_LEAF_REFERENCE_MATCHED = "VISITING_LEAF_REFERENCE_MATCHED";
    protected static final String MSG_PATTERN_KEY_ACTIONS_PERFORMED = "ACTIONS_PERFORMED";
    protected static final String MSG_PATTERN_KEY_NO_ACTIONS_PERFORMED = "NO_ACTIONS_PERFORMED";
    protected static final String MSG_PATTERN_KEY_MATCH_MESSAGES = "MATCH_MESSAGES";
    protected static final ResourceBundle resourceBundle = ResourceBundle.getBundle(RootModuleVersionJobAbstractImpl.class.getName() + "ResourceBundle");
    protected List<ModuleVersion> listModuleVersionRoot;
    private ReferencePathMatcher referencePathMatcherProvided;
    private ReferencePathMatcher referencePathMatcherProjectCode;
    private ReferencePathMatcher referencePathMatcherCombined;
    protected boolean indHandleDynamicVersion = true;
    protected boolean indHandleStaticVersion = true;
    protected boolean indAvoidReentry = true;
    protected boolean indDepthFirst;
    protected UnsyncChangesBehavior unsyncChangesBehaviorLocal;
    protected UnsyncChangesBehavior unsyncChangesBehaviorRemote;
    protected ModuleReentryAvoider moduleReentryAvoider;
    protected ReferencePath referencePath;
    protected List<String> listActionsPerformed;
    protected List<String> listMatchMessages;
    protected boolean indListModuleVersionRootChanged;

    protected RootModuleVersionJobAbstractImpl(List<ModuleVersion> listModuleVersionRoot) {
        this.listModuleVersionRoot = listModuleVersionRoot;
        this.moduleReentryAvoider = new ModuleReentryAvoider();
        this.unsyncChangesBehaviorLocal = UnsyncChangesBehavior.DO_NOT_HANDLE;
        this.unsyncChangesBehaviorRemote = UnsyncChangesBehavior.DO_NOT_HANDLE;
        this.referencePath = new ReferencePath();
        this.listActionsPerformed = new ArrayList<String>();
        this.listMatchMessages = new ArrayList<String>();
    }

    public void setReferencePathMatcherProvided(ReferencePathMatcher referencePathMatcherProvided) {
        this.referencePathMatcherProvided = referencePathMatcherProvided;
    }

    protected String getProjectCode() {
        return ((RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class)).getProperty(null, RUNTIME_PROPERTY_PROJECT_CODE);
    }

    protected void setupReferencePathMatcherForProjectCode() {
        String projectCode = this.getProjectCode();
        if (projectCode != null) {
            this.referencePathMatcherProjectCode = new ReferencePathMatcherVersionAttribute("dragom-project-code", projectCode, ExecContextHolder.get().getModel());
        }
    }

    protected ReferencePathMatcher getReferencePathMatcher() {
        if (this.referencePathMatcherCombined == null) {
            if (this.referencePathMatcherProvided != null && this.referencePathMatcherProjectCode != null) {
                ReferencePathMatcherAnd referencePathMatcherAnd = new ReferencePathMatcherAnd();
                referencePathMatcherAnd.addReferencePathMatcher(this.referencePathMatcherProvided);
                referencePathMatcherAnd.addReferencePathMatcher(this.referencePathMatcherProjectCode);
                this.referencePathMatcherCombined = referencePathMatcherAnd;
            } else {
                this.referencePathMatcherCombined = this.referencePathMatcherProvided != null ? this.referencePathMatcherProvided : (this.referencePathMatcherProjectCode != null ? this.referencePathMatcherProjectCode : new ReferencePathMatcherAll());
            }
        }
        return this.referencePathMatcherCombined;
    }

    protected void setIndHandleDynamicVersion(boolean indHandleDynamicVersion) {
        this.indHandleDynamicVersion = indHandleDynamicVersion;
    }

    protected void setIndHandleStaticVersion(boolean indHandleStaticVersion) {
        this.indHandleStaticVersion = indHandleStaticVersion;
    }

    protected void setIndAvoidReentry(boolean indAvoidReentry) {
        this.indAvoidReentry = indAvoidReentry;
    }

    protected void setIndDepthFirst(boolean indDepthFirst) {
        this.indDepthFirst = indDepthFirst;
    }

    public void setUnsyncChangesBehaviorLocal(UnsyncChangesBehavior unsyncChangesBehaviorLocal) {
        this.unsyncChangesBehaviorLocal = unsyncChangesBehaviorLocal;
    }

    public void setUnsyncChangesBehaviorRemote(UnsyncChangesBehavior unsyncChangesBehaviorRemote) {
        this.unsyncChangesBehaviorRemote = unsyncChangesBehaviorRemote;
    }

    protected void setIndListModuleVersionRootChanged() {
        this.indListModuleVersionRootChanged = true;
    }

    public boolean isListModuleVersionRootChanged() {
        return this.indListModuleVersionRootChanged;
    }

    public void performJob() {
        this.beforeIterateListModuleVersionRoot();
        this.iterateListModuleVersionRoot();
        this.afterIterateListModuleVersionRoot();
    }

    protected void beforeIterateListModuleVersionRoot() {
    }

    protected void iterateListModuleVersionRoot() {
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        ByReference byReferenceVersion = new ByReference();
        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Util.getLocalizedMsgPattern("STARTING_JOB"), this.getClass().getSimpleName()));
        logger.info("Starting the iteration among the root ModuleVersion's " + this.listModuleVersionRoot + '.');
        for (int indexModuleVersionRoot = 0; indexModuleVersionRoot < this.listModuleVersionRoot.size(); ++indexModuleVersionRoot) {
            boolean indVersionChanged;
            ModuleVersion moduleVersion = this.listModuleVersionRoot.get(indexModuleVersionRoot);
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INITIATING_TRAVERSAL_REFERENCE_GRAPH_ROOT_MODULE_VERSION), moduleVersion));
            try {
                indVersionChanged = this.visitModuleVersion(new Reference(moduleVersion), (ByReference<Version>)byReferenceVersion);
            }
            catch (RuntimeExceptionUserError reue) {
                throw reue;
            }
            catch (RuntimeException re) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Util.getLocalizedMsgPattern("EXCEPTION_THROWN_WHILE_VISITING"), moduleVersion));
                logger.error("Exception thrown while visiting " + moduleVersion + '.', (Throwable)re);
                continue;
            }
            logger.info("The current traversal of the reference graph rooted at ModuleVersion " + moduleVersion + " is completed.");
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_TRAVERSAL_REFERENCE_GRAPH_ROOT_MODULE_VERSION_COMPLETED), moduleVersion));
            if (indVersionChanged) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_UPDATE_CHANGED_ROOT_MODULE_VERSION), moduleVersion, byReferenceVersion.object));
                moduleVersion = new ModuleVersion(moduleVersion.getNodePath(), (Version)byReferenceVersion.object);
                this.listModuleVersionRoot.set(indexModuleVersionRoot, moduleVersion);
                this.setIndListModuleVersionRootChanged();
            }
            if (!Util.isAbort()) continue;
            userInteractionCallbackPlugin.provideInfo(Util.getLocalizedMsgPattern("JOB_ABORTED_BY_USER"));
            break;
        }
        logger.info("Iteration among all root ModuleVersions " + this.listModuleVersionRoot + " completed.");
        if (this.listActionsPerformed.size() != 0) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ACTIONS_PERFORMED), StringUtils.join(this.listActionsPerformed, (char)'\n')));
        } else {
            userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_NO_ACTIONS_PERFORMED));
        }
        if (this.listMatchMessages.size() != 0) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MATCH_MESSAGES), StringUtils.join(this.listMatchMessages, (char)'\n')));
        }
        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Util.getLocalizedMsgPattern("JOB_COMPLETED"), this.getClass().getSimpleName()));
    }

    /*
     * Exception decompiling
     */
    protected boolean visitModuleVersion(Reference reference, ByReference<Version> byReferenceVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean visitMatchedModuleVersion(Reference reference) {
        throw new RuntimeException("Must not get here.");
    }

    protected void afterIterateListModuleVersionRoot() {
    }

    public static enum UnsyncChangesBehavior {
        DO_NOT_HANDLE,
        USER_ERROR,
        INTERACT;

    }
}

