/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.execcontext.plugin.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.plugin.CredentialStorePlugin;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.security.CredentialStore;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;

public class DefaultCredentialStorePluginImpl
implements CredentialStorePlugin {
    private static final String INIT_PROPERTY_CREDENTIAL_FILE = "CREDENTIAL_FILE";
    private static final String DEFAULT_CREDENTIAL_FILE = "credentials.properties";
    public static final String INIT_PROPERTY_MASTER_KEY_FILE = "MASTER_KEY_FILE";
    public static final String INIT_PROPERTY_RESOURCE_PATTERN_REALM_USER_MAPPINGS = "RESOURCE_PATTERN_REALM_USER_MAPPINGS";
    public static final String INIT_PROPERTY_PREFIX_RESOURCE_PATTERN_REALM_USER_MAPPING_RESOURCE_PATTERN = "RESOURCE_PATTERN_REALM_USER_MAPPING_RESOURCE_PATTERN.";
    public static final String INIT_PROPERTY_PREFIX_RESOURCE_PATTERN_REALM_USER_MAPPING_REALM = "RESOURCE_PATTERN_REALM_USER_MAPPING_REALM.";
    public static final String INIT_PROPERTY_PREFIX_RESOURCE_PATTERN_REALM_USER_MAPPING_USER = "RESOURCE_PATTERN_REALM_USER_MAPPING_USER.";
    private static final String TRANSIENT_DATA_PREFIX_CREDENTIALS_ALREADY_VALIDATED = DefaultCredentialStorePluginImpl.class.getName() + ".CredentialsAlreadyValidated.";
    private static final String MSG_PATTERN_MASTER_KEY_FILE_CREATED = "MASTER_KEY_FILE_CREATED";
    private static final String MSG_PATTERN_CREDENTIAL_KEY_FILE_CREATED = "CREDENTIAL_FILE_CREATED";
    private static final String MSG_PATTERN_KEY_INPUT_USER_FOR_RESOURCE = "INPUT_USER_FOR_RESOURCE";
    private static final String MSG_PATTERN_KEY_INPUT_PASSWORD_FOR_USER_RESOURCE = "INPUT_PASSWORD_FOR_USER_RESOURCE";
    private static final String MSG_PATTERN_KEY_USER_PASSWORD_INVALID = "USER_PASSWORD_INVALID";
    private static final String MSG_PATTERN_KEY_USER_NOT_SAME_AS_RESOURCE = "USER_NOT_SAME_AS_RESOURCE";
    private static final String MSG_PATTERN_KEY_NO_RESOURCE_REALM_MAPPING_FOUND = "NO_RESOURCE_REALM_MAPPING_FOUND";
    private static final String MSG_PATTERN_KEY_PASSWORD_NOT_AVAILABLE = "PASSWORD_NOT_AVAILABLE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(DefaultCredentialStorePluginImpl.class.getName() + "ResourceBundle");
    private CredentialStore credentialStore;

    public DefaultCredentialStorePluginImpl(ExecContext execContext) {
        Path pathCredentialFile;
        Util.applyDragomSystemProperties();
        String stringCredentialFile = execContext.getInitProperty(INIT_PROPERTY_CREDENTIAL_FILE);
        if (stringCredentialFile == null) {
            Path pathMetadataDir = ((WorkspaceExecContext)ExecContextHolder.get()).getPathMetadataDir();
            pathCredentialFile = pathMetadataDir.resolve(DEFAULT_CREDENTIAL_FILE);
        } else {
            stringCredentialFile = stringCredentialFile.replace("~", Matcher.quoteReplacement(System.getProperty("user.home")));
            pathCredentialFile = Paths.get(stringCredentialFile, new String[0]);
        }
        String stringMasterKeyFile = execContext.getInitProperty(INIT_PROPERTY_MASTER_KEY_FILE);
        if (stringMasterKeyFile == null) {
            throw new RuntimeException("Initialization property MASTER_KEY_FILE is not defined.");
        }
        stringMasterKeyFile = stringMasterKeyFile.replaceAll("~", Matcher.quoteReplacement(System.getProperty("user.home")));
        Path pathMasterKeyFile = Paths.get(stringMasterKeyFile, new String[0]);
        ArrayList<CredentialStore.ResourcePatternRealmUser> listResourcePatternRealmUser = new ArrayList<CredentialStore.ResourcePatternRealmUser>();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        String stringRuntimeProperty = runtimePropertiesPlugin.getProperty(null, INIT_PROPERTY_RESOURCE_PATTERN_REALM_USER_MAPPINGS);
        for (String mapping : stringRuntimeProperty.split(",")) {
            CredentialStore.ResourcePatternRealmUser resourcePatternRealmUser = new CredentialStore.ResourcePatternRealmUser();
            mapping = mapping.trim();
            stringRuntimeProperty = runtimePropertiesPlugin.getProperty(null, INIT_PROPERTY_PREFIX_RESOURCE_PATTERN_REALM_USER_MAPPING_RESOURCE_PATTERN + mapping);
            resourcePatternRealmUser.patternResource = Pattern.compile(stringRuntimeProperty);
            resourcePatternRealmUser.realm = runtimePropertiesPlugin.getProperty(null, INIT_PROPERTY_PREFIX_RESOURCE_PATTERN_REALM_USER_MAPPING_REALM + mapping);
            if (resourcePatternRealmUser.realm == null) {
                throw new RuntimeException("Realm cannot be null for mapping " + mapping + '.');
            }
            resourcePatternRealmUser.user = runtimePropertiesPlugin.getProperty(null, INIT_PROPERTY_PREFIX_RESOURCE_PATTERN_REALM_USER_MAPPING_USER + mapping);
            listResourcePatternRealmUser.add(resourcePatternRealmUser);
        }
        boolean indMasterKeyFileExists = pathMasterKeyFile.toFile().isFile();
        boolean indCredentialFileExists = pathCredentialFile.toFile().isFile();
        this.credentialStore = new CredentialStore(pathCredentialFile, pathMasterKeyFile, listResourcePatternRealmUser);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        if (!indMasterKeyFileExists && pathMasterKeyFile.toFile().isFile()) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_MASTER_KEY_FILE_CREATED), pathMasterKeyFile));
        }
        if (!indCredentialFileExists && pathCredentialFile.toFile().isFile()) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_CREDENTIAL_KEY_FILE_CREATED), pathCredentialFile));
        }
    }

    public CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public boolean isCredentialsExist(String resource, String user, CredentialStorePlugin.CredentialValidator credentialValidator) {
        return this.getCredentialsInternal(resource, user, credentialValidator) != null;
    }

    public CredentialStorePlugin.Credentials getCredentials(String resource, String user, CredentialStorePlugin.CredentialValidator credentialValidator) {
        CredentialStorePlugin.Credentials credentials = this.getCredentialsInternal(resource, user, credentialValidator);
        if (credentials == null) {
            throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_PASSWORD_NOT_AVAILABLE), user, resource));
        }
        return credentials;
    }

    private CredentialStorePlugin.Credentials getCredentialsInternal(String resource, String user, CredentialStorePlugin.CredentialValidator credentialValidator) {
        boolean indSetPassword;
        boolean indSetDefaultUser;
        String password;
        CredentialStore.ResourceInfo resourceInfo;
        block14: {
            ExecContext execContext = ExecContextHolder.get();
            UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
            resourceInfo = this.credentialStore.getResourceInfo(resource);
            if (resourceInfo == null) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_RESOURCE_REALM_MAPPING_FOUND), resource));
            }
            if (user != null && resourceInfo.user != null && !user.equals(resourceInfo.user)) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_USER_NOT_SAME_AS_RESOURCE), user, resourceInfo.user, resource));
            }
            if (user == null) {
                user = resourceInfo.user;
            }
            if (user == null) {
                user = this.credentialStore.getDefaultUser(resource);
            }
            if ((password = this.credentialStore.getPassword(resource, user)) != null && credentialValidator != null && !Util.isNotNullAndTrue((Boolean)execContext.getTransientData(TRANSIENT_DATA_PREFIX_CREDENTIALS_ALREADY_VALIDATED + resourceInfo.realm + '.' + user))) {
                if (!credentialValidator.validateCredentials(resource, user, password)) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_USER_PASSWORD_INVALID), user, resource));
                    password = null;
                }
                execContext.setTransientData(TRANSIENT_DATA_PREFIX_CREDENTIALS_ALREADY_VALIDATED + resourceInfo.realm + '.' + user, (Object)true);
            }
            if (password != null) {
                CredentialStorePlugin.Credentials credentials = new CredentialStorePlugin.Credentials();
                credentials.resource = resource;
                credentials.user = user;
                credentials.password = password;
                credentials.indUserSpecificResource = resourceInfo.user != null;
                return credentials;
            }
            boolean bl = indSetDefaultUser = user == null;
            while (true) {
                if (user == null) {
                    if (userInteractionCallbackPlugin.isBatchMode()) {
                        return null;
                    }
                    String defaultUser = System.getProperty("user.name");
                    user = userInteractionCallbackPlugin.getInfoWithDefault(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_USER_FOR_RESOURCE), resource, resourceInfo.realm, defaultUser), defaultUser);
                }
                indSetPassword = false;
                password = this.credentialStore.getPassword(resource, user);
                if (password == null) {
                    if (userInteractionCallbackPlugin.isBatchMode()) {
                        return null;
                    }
                    password = userInteractionCallbackPlugin.getInfoPassword(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_PASSWORD_FOR_USER_RESOURCE), user, resource, resourceInfo.realm));
                    indSetPassword = true;
                    execContext.setTransientData(TRANSIENT_DATA_PREFIX_CREDENTIALS_ALREADY_VALIDATED + resourceInfo.realm + '.' + user, null);
                }
                if (credentialValidator == null || Util.isNotNullAndTrue((Boolean)execContext.getTransientData(TRANSIENT_DATA_PREFIX_CREDENTIALS_ALREADY_VALIDATED + resourceInfo.realm + '.' + user))) break block14;
                if (credentialValidator.validateCredentials(resource, user, password)) break;
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_USER_PASSWORD_INVALID), user, resource));
            }
            execContext.setTransientData(TRANSIENT_DATA_PREFIX_CREDENTIALS_ALREADY_VALIDATED + resourceInfo.realm + '.' + user, (Object)true);
        }
        if (indSetDefaultUser) {
            this.credentialStore.setDefaultUser(resource, user);
        }
        if (indSetPassword) {
            this.credentialStore.setPassword(resource, user, password);
        }
        CredentialStorePlugin.Credentials credentials = new CredentialStorePlugin.Credentials();
        credentials.resource = resource;
        credentials.user = user;
        credentials.password = password;
        credentials.indUserSpecificResource = resourceInfo.user != null;
        return credentials;
    }

    public void resetCredentials(String resource, String user) {
        this.credentialStore.deletePassword(resource, user);
    }
}

