/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.azyva.dragom.cliutil.CliUtil;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirSystemModule;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.BuildReferenceGraph;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.BuilderPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.ReferenceGraph;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;
import org.azyva.dragom.util.YesAlwaysNoUserResponse;

public class WorkspaceManagerTool {
    private static final String MSG_PATTERN_KEY_STATUS_WORKSPACE_DIRECTORY = "STATUS_WORKSPACE_DIRECTORY";
    private static final String MSG_PATTERN_KEY_STATUS_MODULE_VERSION = "STATUS_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_STATUS_SCM_TYPE = "STATUS_SCM_TYPE";
    private static final String MSG_PATTERN_KEY_STATUS_SCM_URL = "STATUS_SCM_URL";
    private static final String MSG_PATTERN_KEY_STATUS_VERSION = "STATUS_VERSION";
    private static final String MSG_PATTERN_KEY_STATUS_BASE_VERSION = "STATUS_BASE_VERSION";
    private static final String MSG_PATTERN_KEY_STATUS_HAS_UNSYNC_LOCAL_CHANGES = "STATUS_HAS_UNSYNC_LOCAL_CHANGES";
    private static final String MSG_PATTERN_KEY_STATUS_HAS_UNSYNC_REMOTE_CHANGES = "STATUS_HAS_UNSYNC_REMOTE_CHANGES";
    private static final String MSG_PATTERN_KEY_UPDATE_UPDATING = "UPDATE_UPDATING";
    private static final String MSG_PATTERN_KEY_UPDATE_CONFLICTS_WHILE_UPDATING = "UPDATE_CONFLICTS_WHILE_UPDATING";
    private static final String MSG_PATTERN_KEY_UPDATE_NO_UNSYNC_REMOTE_CHANGES = "UPDATE_NO_UNSYNC_REMOTE_CHANGES";
    private static final String MSG_PATTERN_KEY_UPDATE_NO_UPDATE_STATIC_VERSION = "UPDATE_NO_UPDATE_STATIC_VERSION";
    private static final String MSG_PATTERN_KEY_COMMIT_HAS_LOCAL_UNSYNC_CHANGES = "COMMIT_HAS_LOCAL_UNSYNC_CHANGES";
    private static final String MSG_PATTERN_KEY_COMMIT_HAS_UNSYNC_REMOTE_CHANGES = "COMMIT_HAS_UNSYNC_REMOTE_CHANGES";
    private static final String MSG_PATTERN_KEY_COMMIT_SPECIFY_MESSAGE = "COMMIT_SPECIFY_MESSAGE";
    private static final String MSG_PATTERN_KEY_COMMIT_REUSE_COMMIT_MESSAGE = "COMMIT_REUSE_COMMIT_MESSAGE";
    private static final String MSG_PATTERN_KEY_COMMIT_COMMITTING = "COMMIT_COMMITTING";
    private static final String MSG_PATTERN_KEY_COMMIT_NO_UNSYNC_LOCAL_CHANGES = "COMMIT_NO_UNSYNC_LOCAL_CHANGES";
    private static final String MSG_PATTERN_KEY_COMMIT_NO_COMMIT_STATIC_VERSION = "COMMIT_NO_COMMIT_STATIC_VERSION";
    private static final String MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY_UNSYNC_LOCAL_CHANGES = "DELETE_WORKSPACE_DIRECTORY_UNSYNC_LOCAL_CHANGES";
    private static final String MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY = "DELETE_WORKSPACE_DIRECTORY";
    private static final String MSG_PATTERN_KEY_NO_WORKSPACE_DIRECTORY_FOR_MODULE_VERSION = "NO_WORKSPACE_DIRECTORY_FOR_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_UNKNOWN = "WORKSPACE_DIRECTORY_UNKNOWN";
    private static final String MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_NOT_USER = "WORKSPACE_DIRECTORY_NOT_USER";
    private static final String MSG_PATTERN_KEY_CLEAN = "CLEAN";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(WorkspaceManagerTool.class.getName() + "ResourceBundle");
    private static boolean indInit;
    private static Options options;
    CommandLine commandLine;
    ExecContext execContext;
    WorkspacePlugin workspacePlugin;
    UserInteractionCallbackPlugin userInteractionCallbackPlugin;
    Model model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block24: {
            WorkspaceManagerTool.init();
            try {
                CommandLine commandLine;
                DefaultParser defaultParser = new DefaultParser();
                try {
                    commandLine = defaultParser.parse(options, args);
                }
                catch (org.apache.commons.cli.ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("ERROR_PARSING_COMMAND_LINE"), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
                if (CliUtil.hasHelpOption(commandLine)) {
                    WorkspaceManagerTool.help();
                    break block24;
                }
                args = commandLine.getArgs();
                if (args.length < 1) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
                }
                String command = args[0];
                WorkspaceManagerTool workspaceManagerTool = new WorkspaceManagerTool();
                workspaceManagerTool.commandLine = commandLine;
                workspaceManagerTool.execContext = CliUtil.setupExecContext(commandLine, true);
                workspaceManagerTool.workspacePlugin = (WorkspacePlugin)workspaceManagerTool.execContext.getExecContextPlugin(WorkspacePlugin.class);
                workspaceManagerTool.userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
                workspaceManagerTool.model = ExecContextHolder.get().getModel();
                if (command.equals("status")) {
                    workspaceManagerTool.statusCommand();
                    break block24;
                }
                if (command.equals("update")) {
                    workspaceManagerTool.updateCommand();
                    break block24;
                }
                if (command.equals("commit")) {
                    workspaceManagerTool.commitCommand();
                    break block24;
                }
                if (command.equals("clean-all")) {
                    workspaceManagerTool.cleanAllCommand();
                    break block24;
                }
                if (command.equals("clean-system")) {
                    workspaceManagerTool.cleanSystemCommand();
                    break block24;
                }
                if (command.equals("clean-user")) {
                    workspaceManagerTool.cleanUserCommand();
                    break block24;
                }
                if (command.equals("clean-non-root-reachable")) {
                    workspaceManagerTool.cleanNonRootReachableCommand();
                    break block24;
                }
                if (command.equals("remove-module-version")) {
                    workspaceManagerTool.removeModuleVersionCommand();
                    break block24;
                }
                if (command.equals("remove-dir")) {
                    workspaceManagerTool.removeDirCommand();
                    break block24;
                }
                if (command.equals("build-clean-all")) {
                    workspaceManagerTool.buildCleanAllCommand();
                    break block24;
                }
                if (command.equals("build-clean-module-version")) {
                    workspaceManagerTool.buildCleanModuleVersionCommand();
                    break block24;
                }
                if (command.equals("build-clean-dir")) {
                    workspaceManagerTool.buildCleanDirCommand();
                    break block24;
                }
                if (command.equals("fix")) {
                    workspaceManagerTool.fixCommand();
                    break block24;
                }
                throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_COMMAND"), command, CliUtil.getHelpCommandLineOption()));
            }
            catch (RuntimeExceptionUserError reue) {
                System.err.println(CliUtil.getLocalizedMsgPattern("USER_ERROR_PREFIX") + reue.getMessage());
                System.exit(1);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                System.exit(1);
            }
            finally {
                ExecContextHolder.endToolAndUnset();
            }
        }
    }

    private static synchronized void init() {
        if (!indInit) {
            CliUtil.initJavaUtilLogging();
            options = new Options();
            Option option = new Option(null, null);
            option.setLongOpt("commit-message");
            option.setArgs(1);
            options.addOption(option);
            CliUtil.addStandardOptions(options);
            indInit = true;
        }
    }

    private void statusCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        SortedSet<WorkspaceDirPath> sortedSetWorkspaceDirPath = WorkspaceManagerTool.getSortedSetWorkspaceDirPath();
        for (WorkspaceDirPath workspaceDirPath : sortedSetWorkspaceDirPath) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_WORKSPACE_DIRECTORY), workspaceDirPath.pathWorkspaceDir)).append('\n');
            stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_MODULE_VERSION), workspaceDirPath.moduleVersion)).append('\n');
            Module module = this.model.getModule(workspaceDirPath.moduleVersion.getNodePath());
            ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
            stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_SCM_TYPE), scmPlugin.getScmType())).append('\n');
            stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_SCM_URL), scmPlugin.getScmUrl(workspaceDirPath.pathWorkspaceDir))).append('\n');
            Version version = scmPlugin.getVersion(workspaceDirPath.pathWorkspaceDir);
            stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_VERSION), version)).append('\n');
            ScmPlugin.BaseVersion baseVersion = scmPlugin.getBaseVersion(version);
            stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_BASE_VERSION), baseVersion == null ? null : baseVersion.versionBase)).append('\n');
            if (workspaceDirPath.moduleVersion.getVersion().getVersionType() == VersionType.DYNAMIC) {
                stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_HAS_UNSYNC_LOCAL_CHANGES), !scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY))).append('\n');
                stringBuilder.append(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATUS_HAS_UNSYNC_REMOTE_CHANGES), !scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.REMOTE_CHANGES_ONLY))).append('\n');
            }
            this.userInteractionCallbackPlugin.provideInfo(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        SortedSet<WorkspaceDirPath> sortedSetWorkspaceDirPath = WorkspaceManagerTool.getSortedSetWorkspaceDirPath();
        for (WorkspaceDirPath workspaceDirPath : sortedSetWorkspaceDirPath) {
            this.workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            try {
                Module module = this.model.getModule(workspaceDirPath.moduleVersion.getNodePath());
                ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                if (workspaceDirPath.moduleVersion.getVersion().getVersionType() == VersionType.DYNAMIC) {
                    if (!scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.REMOTE_CHANGES_ONLY)) {
                        this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_UPDATE_UPDATING), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                        if (!scmPlugin.update(workspaceDirPath.pathWorkspaceDir)) continue;
                        this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_UPDATE_CONFLICTS_WHILE_UPDATING), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                        continue;
                    }
                    this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_UPDATE_NO_UNSYNC_REMOTE_CHANGES), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                    continue;
                }
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_UPDATE_NO_UPDATE_STATIC_VERSION), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
            }
            finally {
                this.workspacePlugin.releaseWorkspaceDir(workspaceDirPath.pathWorkspaceDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String message = this.commandLine.getOptionValue("commit-message");
        boolean indReuseCommitMessage = message != null;
        boolean indAskReuseCommitMessage = true;
        SortedSet<WorkspaceDirPath> sortedSetWorkspaceDirPath = WorkspaceManagerTool.getSortedSetWorkspaceDirPath();
        for (WorkspaceDirPath workspaceDirPath : sortedSetWorkspaceDirPath) {
            this.workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            try {
                Module module = this.model.getModule(workspaceDirPath.moduleVersion.getNodePath());
                ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                if (workspaceDirPath.moduleVersion.getVersion().getVersionType() == VersionType.DYNAMIC) {
                    if (!scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY)) {
                        if (!scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.REMOTE_CHANGES_ONLY)) {
                            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_HAS_UNSYNC_REMOTE_CHANGES), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                            if (Util.handleDoYouWantToContinue((String)"UNSYNC_REMOTE_CHANGES_WHILE_COMMIT")) continue;
                            return;
                        }
                        this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_HAS_LOCAL_UNSYNC_CHANGES), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                        if (!indReuseCommitMessage) {
                            message = this.userInteractionCallbackPlugin.getInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_SPECIFY_MESSAGE), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                            if (indAskReuseCommitMessage) {
                                if (Util.getInfoYesNoUserResponse((UserInteractionCallbackPlugin)this.userInteractionCallbackPlugin, (String)resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_REUSE_COMMIT_MESSAGE), (YesAlwaysNoUserResponse)YesAlwaysNoUserResponse.YES) == YesAlwaysNoUserResponse.YES) {
                                    indReuseCommitMessage = true;
                                } else {
                                    indAskReuseCommitMessage = false;
                                }
                            }
                        }
                        this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_COMMITTING), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                        if (!Util.handleDoYouWantToContinueWithIndividualNo((String)"COMMIT")) {
                            if (!Util.isAbort()) continue;
                            return;
                        }
                        scmPlugin.commit(workspaceDirPath.pathWorkspaceDir, message, null);
                        continue;
                    }
                    this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_NO_UNSYNC_LOCAL_CHANGES), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                    continue;
                }
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_COMMIT_NO_COMMIT_STATIC_VERSION), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
            }
            finally {
                this.workspacePlugin.releaseWorkspaceDir(workspaceDirPath.pathWorkspaceDir);
            }
        }
    }

    private void cleanAllCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        this.cleanSystemCommand();
        this.cleanUserCommand();
    }

    private void cleanSystemCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        Set setWorkspaceDir = this.workspacePlugin.getSetWorkspaceDir(WorkspaceDirSystemModule.class);
        for (WorkspaceDir workspaceDir : setWorkspaceDir) {
            this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            this.workspacePlugin.deleteWorkspaceDir(workspaceDir);
        }
    }

    private void cleanUserCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        SortedSet<WorkspaceDirPath> setWorkspaceDirPath = WorkspaceManagerTool.getSortedSetWorkspaceDirPath();
        for (WorkspaceDirPath workspaceDirPath : setWorkspaceDirPath) {
            Module module = this.model.getModule(workspaceDirPath.moduleVersion.getNodePath());
            ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
            if (!scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY)) {
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY_UNSYNC_LOCAL_CHANGES), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                if (!Util.handleDoYouWantToContinueWithIndividualNo((String)"DELETE_WORKSPACE_DIRECTORY_WITH_UNSYNC_LOCAL_CHANGES")) {
                    if (!Util.isAbort()) continue;
                    return;
                }
            } else {
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                if (!Util.handleDoYouWantToContinueWithIndividualNo((String)MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY)) {
                    if (!Util.isAbort()) continue;
                    return;
                }
            }
            this.workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            this.workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion);
        }
    }

    private void cleanNonRootReachableCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        BuildReferenceGraph buildReferenceGraph = new BuildReferenceGraph(null, CliUtil.getListModuleVersionRoot(null));
        buildReferenceGraph.setReferencePathMatcherProvided(CliUtil.getReferencePathMatcher(null));
        buildReferenceGraph.setupReferencePathMatcherForProjectCode();
        buildReferenceGraph.performJob();
        ReferenceGraph referenceGraph = buildReferenceGraph.getReferenceGraph();
        this.workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        SortedSet<WorkspaceDirPath> setWorkspaceDirPath = WorkspaceManagerTool.getSortedSetWorkspaceDirPath();
        for (WorkspaceDirPath workspaceDirPath : setWorkspaceDirPath) {
            if (referenceGraph.moduleVersionExists(workspaceDirPath.moduleVersion)) continue;
            Module module = this.model.getModule(workspaceDirPath.moduleVersion.getNodePath());
            ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
            if (!scmPlugin.isSync(workspaceDirPath.pathWorkspaceDir, ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY)) {
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY_UNSYNC_LOCAL_CHANGES), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                if (!Util.handleDoYouWantToContinueWithIndividualNo((String)"DELETE_WORKSPACE_DIRECTORY_WITH_UNSYNC_LOCAL_CHANGES")) {
                    if (!Util.isAbort()) continue;
                    return;
                }
            } else {
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                if (!Util.handleDoYouWantToContinueWithIndividualNo((String)MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY)) {
                    if (!Util.isAbort()) continue;
                    return;
                }
            }
            this.workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            this.workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion);
        }
    }

    private void removeModuleVersionCommand() {
        ModuleVersion moduleVersion;
        if (this.commandLine.getArgs().length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        try {
            moduleVersion = ModuleVersion.parse((String)this.commandLine.getArgs()[1]);
        }
        catch (ParseException pe) {
            throw new RuntimeExceptionUserError(pe.getMessage());
        }
        WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(moduleVersion);
        Set setWorkspaceDir = this.workspacePlugin.getSetWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion);
        if (setWorkspaceDir.isEmpty()) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_WORKSPACE_DIRECTORY_FOR_MODULE_VERSION), moduleVersion));
        }
        for (WorkspaceDir workspaceDir : setWorkspaceDir) {
            Path pathWorkspaceDir;
            Module module = this.model.getModule(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath());
            ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
            if (!scmPlugin.isSync(pathWorkspaceDir = this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.PEEK), ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY)) {
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY_UNSYNC_LOCAL_CHANGES), pathWorkspaceDir, ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion()));
                if (!Util.handleDoYouWantToContinueWithIndividualNo((String)"DELETE_WORKSPACE_DIRECTORY_WITH_UNSYNC_LOCAL_CHANGES")) {
                    if (!Util.isAbort()) continue;
                    return;
                }
            } else {
                this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY), pathWorkspaceDir, ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion()));
                if (!Util.handleDoYouWantToContinueWithIndividualNo((String)MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY)) {
                    if (!Util.isAbort()) continue;
                    return;
                }
            }
            this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            this.workspacePlugin.deleteWorkspaceDir(workspaceDir);
        }
    }

    private void removeDirCommand() {
        if (this.commandLine.getArgs().length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        Path pathWorkspaceDir = ((WorkspaceExecContext)this.execContext).getPathWorkspaceDir().resolve(this.commandLine.getArgs()[1]);
        if (!this.workspacePlugin.isPathWorkspaceDirExists(pathWorkspaceDir)) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_UNKNOWN), pathWorkspaceDir));
            return;
        }
        WorkspaceDir workspaceDir = this.workspacePlugin.getWorkspaceDirFromPath(pathWorkspaceDir);
        if (!(workspaceDir instanceof WorkspaceDirUserModuleVersion)) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_NOT_USER), pathWorkspaceDir));
            return;
        }
        Module module = this.model.getModule(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath());
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        if (!scmPlugin.isSync(pathWorkspaceDir = this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.PEEK), ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY)) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY_UNSYNC_LOCAL_CHANGES), pathWorkspaceDir, ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion()));
            if (!Util.handleDoYouWantToContinue((String)"DELETE_WORKSPACE_DIRECTORY_WITH_UNSYNC_LOCAL_CHANGES")) {
                return;
            }
        } else {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY), pathWorkspaceDir, ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion()));
            if (!Util.handleDoYouWantToContinue((String)MSG_PATTERN_KEY_DELETE_WORKSPACE_DIRECTORY)) {
                return;
            }
        }
        this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
        this.workspacePlugin.deleteWorkspaceDir(workspaceDir);
    }

    private void buildCleanAllCommand() {
        if (this.commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        SortedSet<WorkspaceDirPath> setWorkspaceDirPath = WorkspaceManagerTool.getSortedSetWorkspaceDirPath();
        for (WorkspaceDirPath workspaceDirPath : setWorkspaceDirPath) {
            Module module = this.model.getModule(workspaceDirPath.moduleVersion.getNodePath());
            BuilderPlugin builderPlugin = (BuilderPlugin)module.getNodePlugin(BuilderPlugin.class, null);
            this.workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirPath.workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            try {
                Writer writerLog = this.userInteractionCallbackPlugin.provideInfoWithWriter(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CLEAN), workspaceDirPath.pathWorkspaceDir, workspaceDirPath.moduleVersion));
                Throwable throwable = null;
                try {
                    builderPlugin.clean(workspaceDirPath.pathWorkspaceDir, writerLog);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writerLog == null) continue;
                    if (throwable != null) {
                        try {
                            writerLog.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writerLog.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                this.workspacePlugin.releaseWorkspaceDir(workspaceDirPath.pathWorkspaceDir);
            }
        }
    }

    private void buildCleanModuleVersionCommand() {
        ModuleVersion moduleVersion;
        if (this.commandLine.getArgs().length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        try {
            moduleVersion = ModuleVersion.parse((String)this.commandLine.getArgs()[1]);
        }
        catch (ParseException pe) {
            throw new RuntimeExceptionUserError(pe.getMessage());
        }
        WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(moduleVersion);
        Set setWorkspaceDir = this.workspacePlugin.getSetWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion);
        if (setWorkspaceDir.isEmpty()) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_WORKSPACE_DIRECTORY_FOR_MODULE_VERSION), moduleVersion));
        }
        for (WorkspaceDir workspaceDir : setWorkspaceDir) {
            Module module = this.model.getModule(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath());
            BuilderPlugin builderPlugin = (BuilderPlugin)module.getNodePlugin(BuilderPlugin.class, null);
            Path pathWorkspaceDir = this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            try {
                Writer writerLog = this.userInteractionCallbackPlugin.provideInfoWithWriter(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CLEAN), pathWorkspaceDir, ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion()));
                Throwable throwable = null;
                try {
                    builderPlugin.clean(pathWorkspaceDir, writerLog);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writerLog == null) continue;
                    if (throwable != null) {
                        try {
                            writerLog.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writerLog.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                this.workspacePlugin.releaseWorkspaceDir(pathWorkspaceDir);
            }
        }
    }

    private void buildCleanDirCommand() {
        if (this.commandLine.getArgs().length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        Path pathWorkspaceDir = ((WorkspaceExecContext)this.execContext).getPathWorkspaceDir().resolve(this.commandLine.getArgs()[1]);
        if (!this.workspacePlugin.isPathWorkspaceDirExists(pathWorkspaceDir)) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_UNKNOWN), pathWorkspaceDir));
            return;
        }
        WorkspaceDir workspaceDir = this.workspacePlugin.getWorkspaceDirFromPath(pathWorkspaceDir);
        if (!(workspaceDir instanceof WorkspaceDirUserModuleVersion)) {
            this.userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_WORKSPACE_DIRECTORY_NOT_USER), pathWorkspaceDir));
            return;
        }
        Module module = this.model.getModule(((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath());
        BuilderPlugin builderPlugin = (BuilderPlugin)module.getNodePlugin(BuilderPlugin.class, null);
        this.workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
        try (Writer writerLog = this.userInteractionCallbackPlugin.provideInfoWithWriter(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CLEAN), pathWorkspaceDir, ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion()));){
            builderPlugin.clean(pathWorkspaceDir, writerLog);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.workspacePlugin.releaseWorkspaceDir(pathWorkspaceDir);
        }
    }

    private void fixCommand() {
        throw new RuntimeException("Not implemented yet.");
    }

    private static void help() {
        try {
            IOUtils.copy((InputStream)CliUtil.getLocalizedResourceAsStream(WorkspaceManagerTool.class, "WorkspaceManagerToolHelp.txt"), (OutputStream)System.out);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static SortedSet<WorkspaceDirPath> getSortedSetWorkspaceDirPath() {
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        TreeSet<WorkspaceDirPath> sortedSetWorkspaceDirPath = new TreeSet<WorkspaceDirPath>();
        for (WorkspaceDir workspaceDir : workspacePlugin.getSetWorkspaceDir(WorkspaceDirUserModuleVersion.class)) {
            WorkspaceDirPath workspaceDirPath = new WorkspaceDirPath();
            workspaceDirPath.workspaceDirUserModuleVersion = (WorkspaceDirUserModuleVersion)workspaceDir;
            workspaceDirPath.moduleVersion = ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion();
            workspaceDirPath.pathWorkspaceDir = workspacePlugin.getWorkspaceDir(workspaceDir, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.PEEK);
            sortedSetWorkspaceDirPath.add(workspaceDirPath);
        }
        return sortedSetWorkspaceDirPath;
    }

    private static class WorkspaceDirPath
    implements Comparable<WorkspaceDirPath> {
        WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion;
        ModuleVersion moduleVersion;
        Path pathWorkspaceDir;

        private WorkspaceDirPath() {
        }

        @Override
        public int compareTo(WorkspaceDirPath workspaceDirPathOther) {
            return this.pathWorkspaceDir.compareTo(workspaceDirPathOther.pathWorkspaceDir);
        }

        public boolean equals(Object other) {
            return this.pathWorkspaceDir.equals(((WorkspaceDirPath)other).pathWorkspaceDir);
        }
    }
}

