/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.azyva.dragom.cliutil.CliUtil;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.ToolLifeCycleExecContext;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class ExecContextManagerTool {
    private static boolean indInit;
    private static Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block21: {
            ExecContextManagerTool.init();
            try {
                CommandLine commandLine;
                DefaultParser defaultParser = new DefaultParser();
                try {
                    commandLine = defaultParser.parse(options, args);
                }
                catch (ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("ERROR_PARSING_COMMAND_LINE"), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
                if (CliUtil.hasHelpOption(commandLine)) {
                    ExecContextManagerTool.help();
                    break block21;
                }
                args = commandLine.getArgs();
                if (args.length < 1) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
                }
                String command = args[0];
                if (command.equals("force-unlock")) {
                    ExecContextHolder.forceUnset((ExecContext)CliUtil.setupExecContext(commandLine, false));
                    break block21;
                }
                CliUtil.setupExecContext(commandLine, true);
                if (command.equals("release")) {
                    ExecContextManagerTool.releaseCommand(commandLine);
                    break block21;
                }
                if (command.equals("get-properties")) {
                    ExecContextManagerTool.getPropertiesCommand(commandLine);
                    break block21;
                }
                if (command.equals("get-property")) {
                    ExecContextManagerTool.getPropertyCommand(commandLine);
                    break block21;
                }
                if (command.equals("set-property")) {
                    ExecContextManagerTool.setPropertyCommand(commandLine);
                    break block21;
                }
                if (command.equals("set-properties-from-tool-properties")) {
                    ExecContextManagerTool.setPropertiesFromToolPropertiesCommand(commandLine);
                    break block21;
                }
                if (command.equals("remove-property")) {
                    ExecContextManagerTool.removePropertyCommand(commandLine);
                    break block21;
                }
                if (command.equals("remove-properties")) {
                    ExecContextManagerTool.removePropertiesCommand(commandLine);
                    break block21;
                }
                if (command.equals("get-init-properties")) {
                    ExecContextManagerTool.getInitPropertiesCommand(commandLine);
                    break block21;
                }
                if (command.equals("get-init-property")) {
                    ExecContextManagerTool.getInitPropertyCommand(commandLine);
                    break block21;
                }
                throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_COMMAND"), command, CliUtil.getHelpCommandLineOption()));
            }
            catch (RuntimeExceptionUserError reue) {
                System.err.println(CliUtil.getLocalizedMsgPattern("USER_ERROR_PREFIX") + reue.getMessage());
                System.exit(1);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                System.exit(1);
            }
            finally {
                ExecContextHolder.endToolAndUnset();
            }
        }
    }

    private static synchronized void init() {
        if (!indInit) {
            CliUtil.initJavaUtilLogging();
            options = new Options();
            CliUtil.addStandardOptions(options);
            indInit = true;
        }
    }

    private static void help() {
        try {
            IOUtils.copy((InputStream)CliUtil.getLocalizedResourceAsStream(ExecContextManagerTool.class, "ExecContextManagerToolHelp.txt"), (OutputStream)System.out);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void releaseCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        execContext.release();
    }

    private static void getPropertiesCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length > 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        Set setProperty = execContext.getSetProperty(args.length == 2 ? args[1] : null);
        ArrayList listProperty = new ArrayList(setProperty);
        Collections.sort(listProperty);
        for (String property : listProperty) {
            System.out.println(property + "=" + execContext.getProperty(property));
        }
    }

    private static void getPropertyCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        System.out.println(args[1] + "=" + execContext.getProperty(args[1]));
    }

    private static void setPropertyCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 3) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        execContext.setProperty(args[1], args[2]);
        System.out.println(args[1] + "=" + args[2]);
    }

    private static void setPropertiesFromToolPropertiesCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        if (!(execContext instanceof ToolLifeCycleExecContext)) {
            throw new RuntimeException("ExecContext does not implement ToolLifeCycleExecContext.");
        }
        ToolLifeCycleExecContext toolLifeCycleExecContext = (ToolLifeCycleExecContext)execContext;
        for (String property : toolLifeCycleExecContext.getSetToolProperty()) {
            String value = toolLifeCycleExecContext.getToolProperty(property);
            execContext.setProperty(property, value);
            System.out.println(property + "=" + value);
        }
    }

    private static void removePropertyCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        execContext.removeProperty(args[1]);
    }

    private static void removePropertiesCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        execContext.removeProperties(args[1]);
    }

    private static void getInitPropertiesCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        Set setInitProperty = execContext.getSetInitProperty();
        ArrayList listInitProperty = new ArrayList(setInitProperty);
        Collections.sort(listInitProperty);
        for (String initProperty : listInitProperty) {
            System.out.println(initProperty + "=" + execContext.getInitProperty(initProperty));
        }
    }

    private static void getInitPropertyCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ExecContext execContext = ExecContextHolder.get();
        System.out.println(args[1] + "=" + execContext.getInitProperty(args[1]));
    }
}

