/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.azyva.dragom.cliutil.CliUtil;
import org.azyva.dragom.execcontext.plugin.CredentialStorePlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.impl.DefaultCredentialStorePluginImpl;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.security.CredentialStore;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class CredentialManagerTool {
    private static final String MSG_PATTERN_KEY_USER = "USER";
    private static final String MSG_PATTERN_KEY_REALM = "REALM";
    private static final String MSG_PATTERN_KEY_INTERACTIVE_MODE_REQUIRED = "INTERACTIVE_MODE_REQUIRED";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(CredentialManagerTool.class.getName() + "ResourceBundle");
    private static boolean indInit;
    private static Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block20: {
            CredentialManagerTool.init();
            try {
                CommandLine commandLine;
                DefaultParser defaultParser = new DefaultParser();
                try {
                    commandLine = defaultParser.parse(options, args);
                }
                catch (ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("ERROR_PARSING_COMMAND_LINE"), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
                if (CliUtil.hasHelpOption(commandLine)) {
                    CredentialManagerTool.help();
                    break block20;
                }
                args = commandLine.getArgs();
                if (args.length == 0) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
                }
                CliUtil.setupExecContext(commandLine, true);
                String command = args[0];
                if (command.equals("enum-resource-realm-mappings")) {
                    CredentialManagerTool.enumResourceRealmMappingsCommand(commandLine);
                    break block20;
                }
                if (command.equals("enum-passwords")) {
                    CredentialManagerTool.enumPasswordsCommand(commandLine);
                    break block20;
                }
                if (command.equals("get-password")) {
                    CredentialManagerTool.getPasswordCommand(commandLine);
                    break block20;
                }
                if (command.equals("set-password")) {
                    CredentialManagerTool.setPasswordCommand(commandLine);
                    break block20;
                }
                if (command.equals("remove-password")) {
                    CredentialManagerTool.removePasswordCommand(commandLine);
                    break block20;
                }
                if (command.equals("enum-default-users")) {
                    CredentialManagerTool.enumDefaultUsersCommand(commandLine);
                    break block20;
                }
                if (command.equals("get-default-user")) {
                    CredentialManagerTool.getDefaultUserCommand(commandLine);
                    break block20;
                }
                if (command.equals("set-default-user")) {
                    CredentialManagerTool.setDefaultUserCommand(commandLine);
                    break block20;
                }
                if (command.equals("remove-default-user")) {
                    CredentialManagerTool.removeDefaultUserCommand(commandLine);
                    break block20;
                }
                throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_COMMAND"), command, CliUtil.getHelpCommandLineOption()));
            }
            catch (RuntimeExceptionUserError reue) {
                System.err.println(CliUtil.getLocalizedMsgPattern("USER_ERROR_PREFIX") + reue.getMessage());
                System.exit(1);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                System.exit(1);
            }
            finally {
                ExecContextHolder.endToolAndUnset();
            }
        }
    }

    private static synchronized void init() {
        if (!indInit) {
            CliUtil.initJavaUtilLogging();
            options = new Options();
            CliUtil.addStandardOptions(options);
            indInit = true;
        }
    }

    private static void enumResourceRealmMappingsCommand(CommandLine commandLine) {
        if (commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        List listResourcePatternRealmUser = defaultCredentialStorePluginImpl.getCredentialStore().getListResourcePatternRealmUser();
        StringBuilder stringBuilder = new StringBuilder();
        for (CredentialStore.ResourcePatternRealmUser resourcePatternRealmUser : listResourcePatternRealmUser) {
            stringBuilder.append(resourcePatternRealmUser.patternResource.toString()).append(" -> ").append(resourcePatternRealmUser.realm);
            if (resourcePatternRealmUser.user != null) {
                stringBuilder.append(" (").append(resourceBundle.getString(MSG_PATTERN_KEY_USER)).append(": ").append(resourcePatternRealmUser.user).append(')');
            }
            stringBuilder.append('\n');
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            userInteractionCallbackPlugin.provideInfo(stringBuilder.toString());
        }
    }

    private static void enumPasswordsCommand(CommandLine commandLine) {
        if (commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        List listRealmUser = defaultCredentialStorePluginImpl.getCredentialStore().getListRealmUser();
        StringBuilder stringBuilder = new StringBuilder();
        for (CredentialStore.RealmUser realmUser : listRealmUser) {
            stringBuilder.append(resourceBundle.getString(MSG_PATTERN_KEY_REALM)).append(": ").append(realmUser.realm).append(' ').append(resourceBundle.getString(MSG_PATTERN_KEY_USER)).append(": ").append(realmUser.user).append('\n');
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            userInteractionCallbackPlugin.provideInfo(stringBuilder.toString());
        }
    }

    private static void getPasswordCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2 || args.length > 3) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String resource = args[1];
        String user = args.length == 3 ? args[2] : null;
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        String password = defaultCredentialStorePluginImpl.getCredentialStore().getPassword(resource, user);
        if (password != null) {
            System.out.print(password);
        } else {
            System.exit(1);
        }
    }

    private static void setPasswordCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2 || args.length > 3) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String resource = args[1];
        String user = args.length == 3 ? args[2] : null;
        if (((UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class)).isBatchMode()) {
            throw new RuntimeExceptionUserError(resourceBundle.getString(MSG_PATTERN_KEY_INTERACTIVE_MODE_REQUIRED));
        }
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        defaultCredentialStorePluginImpl.resetCredentials(resource, user);
        if (defaultCredentialStorePluginImpl.getCredentials(resource, user, null) == null) {
            System.exit(1);
        }
    }

    private static void removePasswordCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2 || args.length > 3) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String resource = args[1];
        String user = args.length == 3 ? args[2] : null;
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        defaultCredentialStorePluginImpl.resetCredentials(resource, user);
    }

    private static void enumDefaultUsersCommand(CommandLine commandLine) {
        if (commandLine.getArgs().length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        List listRealmUser = defaultCredentialStorePluginImpl.getCredentialStore().getListRealmUserDefault();
        StringBuilder stringBuilder = new StringBuilder();
        for (CredentialStore.RealmUser realmUser : listRealmUser) {
            stringBuilder.append(resourceBundle.getString(MSG_PATTERN_KEY_REALM)).append(": ").append(realmUser.realm).append(' ').append(resourceBundle.getString(MSG_PATTERN_KEY_USER)).append(": ").append(realmUser.user).append('\n');
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            userInteractionCallbackPlugin.provideInfo(stringBuilder.toString());
        }
    }

    private static void getDefaultUserCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String resource = args[1];
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        String user = defaultCredentialStorePluginImpl.getCredentialStore().getDefaultUser(resource);
        if (user != null) {
            System.out.print(user);
        } else {
            System.exit(1);
        }
    }

    private static void setDefaultUserCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 3) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String resource = args[1];
        String user = args[2];
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        if (!defaultCredentialStorePluginImpl.getCredentialStore().setDefaultUser(resource, user)) {
            System.exit(1);
        }
    }

    private static void removeDefaultUserCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        String resource = args[1];
        DefaultCredentialStorePluginImpl defaultCredentialStorePluginImpl = (DefaultCredentialStorePluginImpl)ExecContextHolder.get().getExecContextPlugin(CredentialStorePlugin.class);
        defaultCredentialStorePluginImpl.getCredentialStore().deleteDefaultUser(resource);
    }

    private static void help() {
        try {
            IOUtils.copy((InputStream)CliUtil.getLocalizedResourceAsStream(CredentialManagerTool.class, "CredentialManagerToolHelp.txt"), (OutputStream)System.out);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

