/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.kwt.task;

import com.google.common.collect.Lists;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITask<T>
implements InvocationHandler,
Callable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UITask.class);
    private static final int DIALOG_MIN_WIDTH = 350;
    private static final String FLUSH_EVENT_METHOD = "flushPendingEvents";
    private static final String SUN_TOOLKIT_CLASS = "sun.awt.SunToolkit";
    private static final String PUMP_EVENTS_METHOD = "pumpEvents";
    private static final String AWT_EDT_CLASS = "java.awt.EventDispatchThread";
    private static final String AWT_CONDITIONAL_CLASS = "java.awt.Conditional";
    private static final int SHOW_PROGRESS_DELAY = 2000;
    private static Class<?> conditionalClass;
    private static Method pumpEventsMethod;
    private static Class<?> sunToolkitClass;
    private static Method flushEventMethod;
    private static String defaultMessage;
    private String cancelText = "Cancel";
    private static ImageIcon cartoonIcon;
    private SwingWorker<T, Void> worker;
    private final List<Component> glassList = Lists.newArrayList();
    private Timer timer;
    private JDialog dialog;
    private JLabel message;
    private JProgressBar progress;
    private final Callable<T> callable;
    private String title;
    private String messageText = defaultMessage;
    private int progressValue = -1;
    private Window ownerWindow = null;
    private final Action cancelAction = new AbstractAction(this.cancelText){
        private static final long serialVersionUID = 8989611247581396162L;

        @Override
        public void actionPerformed(ActionEvent event) {
            UITask.this.cancel();
        }
    };
    private boolean cancelable;
    private static final String PUSH_POP_LOCK_FIELD = "pushPopLock";
    private static final String PUSH_POP_COND_FIELD = "pushPopCond";
    private static Field pushPopLockField;
    private static Field pushPopCondField;
    private static boolean isJre7Plus;

    public static void setDefaultMessage(String message) {
        defaultMessage = message;
    }

    public void setCancelText(String text) {
        this.cancelText = text;
        this.cancelAction.putValue("Name", this.cancelText);
    }

    public UITask() {
        this.callable = this;
        this.cancelAction.setEnabled(false);
    }

    public UITask(Window window) {
        this.callable = this;
        this.cancelAction.setEnabled(false);
        this.ownerWindow = window;
    }

    public UITask(Callable<T> callable) {
        this.callable = callable;
        this.cancelAction.setEnabled(false);
    }

    public UITask(Callable<T> callable, Window window) {
        this.callable = callable;
        this.cancelAction.setEnabled(false);
        this.ownerWindow = window;
    }

    public void setCancelable(final boolean cancelable) {
        this.cancelable = cancelable;
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.cancelAction.setEnabled(cancelable);
            }
        });
    }

    public void setTitle(final String title) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.title = title;
                if (UITask.this.dialog != null) {
                    UITask.this.dialog.setTitle(title);
                }
            }
        });
    }

    public void setMessage(final String text) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.messageText = text;
                if (UITask.this.message != null) {
                    UITask.this.message.setText(text);
                }
            }
        });
    }

    public void setProgress(final int value) {
        this.invokeUI(new Runnable(){

            @Override
            public void run() {
                UITask.this.progressValue = value;
                if (UITask.this.progress != null) {
                    if (UITask.this.progressValue < 0) {
                        UITask.this.progress.setIndeterminate(true);
                    } else {
                        UITask.this.progress.setIndeterminate(false);
                        UITask.this.progress.setValue(UITask.this.progressValue);
                    }
                }
            }
        });
    }

    protected void invokeUI(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public T call() throws Exception {
        return null;
    }

    public T execute() throws Exception {
        if (!SwingUtilities.isEventDispatchThread()) {
            return this.callable.call();
        }
        try {
            this.worker = new SwingWorker<T, Void>(){

                @Override
                protected T doInBackground() throws Exception {
                    return UITask.this.callable.call();
                }

                @Override
                protected void done() {
                    UITask.this.stopWaitCursor();
                    UITask.this.closeProgress();
                }
            };
            this.worker.execute();
            this.resetFocus();
            this.startWaitCursor();
            this.timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UITask.this.showProgress();
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
            this.pumpEvents();
            T t = this.worker.get();
            return t;
        }
        catch (ExecutionException e) {
            T t = null;
            return t;
        }
        finally {
            this.stopWaitCursor();
            this.closeProgress();
        }
    }

    public void closeProgress() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public T executeSilently() {
        try {
            return this.execute();
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    public boolean isCancelled() {
        if (this.worker != null) {
            return this.worker.isCancelled();
        }
        return false;
    }

    private void showProgress() {
        Window owner = this.getCurrentOwner();
        this.dialog = owner instanceof Dialog ? new JDialog((Dialog)owner) : (owner instanceof Frame ? new JDialog((Frame)owner) : new JDialog());
        this.dialog.setTitle(this.title);
        this.dialog.setModal(false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UITask.this.cancel();
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JLabel cartoon = new JLabel(cartoonIcon);
        JPanel msg = new JPanel(new FlowLayout(0, 10, 5));
        msg.add(cartoon);
        this.message = new JLabel(this.messageText);
        msg.add(this.message);
        this.dialog.getContentPane().add((Component)msg, "North");
        JPanel center = new JPanel(new FlowLayout(0, 10, 5));
        center.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.progress = new JProgressBar(0, 100);
        this.setProgress(this.progressValue);
        this.progress.setPreferredSize(new Dimension(330, 21));
        center.add(this.progress);
        if (this.cancelAction.isEnabled()) {
            this.progress.setPreferredSize(new Dimension(240, 21));
            JButton cancellBtn = new JButton(this.cancelAction);
            cancellBtn.setPreferredSize(new Dimension(80, 21));
            center.add(cancellBtn);
            cancellBtn.setVisible(cancellBtn.isEnabled());
            cancellBtn.setCursor(Cursor.getDefaultCursor());
        }
        this.dialog.getContentPane().add((Component)center, "Center");
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        this.dialog.setCursor(Cursor.getDefaultCursor());
        this.dialog.setResizable(false);
        this.dialog.pack();
        Dimension size = this.dialog.getPreferredSize();
        if (size.width < 350) {
            size.width = 350;
            this.dialog.setSize(size);
        }
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.setVisible(true);
    }

    private Window getCurrentOwner() {
        Window[] wins;
        if (this.ownerWindow != null) {
            return this.ownerWindow;
        }
        for (Window w : wins = UITask.getWindows()) {
            if (!w.isActive()) continue;
            return w;
        }
        return Frame.getFrames()[0];
    }

    private void cancel() {
        if (this.cancelable) {
            this.worker.cancel(true);
            this.closeProgress();
        }
    }

    private void startWaitCursor() {
        Window[] windows;
        for (Window window : windows = UITask.getWindows()) {
            if (!(window instanceof RootPaneContainer)) continue;
            Component glass = ((RootPaneContainer)((Object)window)).getGlassPane();
            glass.setCursor(Cursor.getPredefinedCursor(3));
            glass.setVisible(true);
            this.glassList.add(glass);
        }
    }

    private void stopWaitCursor() {
        for (Component glass : this.glassList) {
            glass.setCursor(Cursor.getDefaultCursor());
            glass.setVisible(false);
        }
        this.glassList.clear();
    }

    private void pumpEvents() {
        try {
            Object conditional = Proxy.newProxyInstance(conditionalClass.getClassLoader(), new Class[]{conditionalClass}, (InvocationHandler)this);
            pumpEventsMethod.invoke((Object)Thread.currentThread(), conditional);
        }
        catch (Exception e) {
            LOG.warn("", (Throwable)e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        while (!this.worker.isDone()) {
            AWTEvent event = this.waitForEvent();
            if (event == null) {
                return false;
            }
            if (this.acceptEvent(event)) {
                return true;
            }
            if (this.getNextEvent() != null) continue;
            return false;
        }
        return false;
    }

    private boolean acceptEvent(AWTEvent event) {
        KeyEvent keyEvent;
        if (event.getID() == 401 && event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getKeyCode() == 3 && keyEvent.isControlDown()) {
            this.cancel();
            return true;
        }
        if (this.dialog != null && !this.dialog.isActive()) {
            this.dialog.requestFocus();
        }
        if (this.dialog != null && event.getSource() == this.dialog) {
            return true;
        }
        if (event instanceof InputEvent) {
            return false;
        }
        return event.getID() != 201;
    }

    private void resetFocus() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focus = focusManager.getPermanentFocusOwner();
        if (focus != null) {
            focus.requestFocus();
        }
    }

    private EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    private AWTEvent getNextEvent() {
        try {
            return this.getEventQueue().getNextEvent();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AWTEvent waitForEvent() {
        EventQueue queue = this.getEventQueue();
        AWTEvent nextEvent = null;
        while ((nextEvent = this.peekEvent(queue)) == null) {
            try {
                if (isJre7Plus) {
                    boolean again = true;
                    while (again) {
                        Lock pushPopLock = null;
                        Condition pushPopCond = null;
                        try {
                            pushPopLock = (Lock)Lock.class.cast(pushPopLockField.get(queue));
                            pushPopCond = (Condition)Condition.class.cast(pushPopCondField.get(queue));
                            again = false;
                        }
                        catch (Exception e) {
                            again = true;
                        }
                        if (again || null == pushPopLock || null == pushPopCond) continue;
                        pushPopLock.lock();
                        try {
                            pushPopCond.await();
                        }
                        finally {
                            pushPopLock.unlock();
                        }
                    }
                    continue;
                }
                EventQueue again = queue;
                synchronized (again) {
                    queue.wait();
                }
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return nextEvent;
    }

    private AWTEvent peekEvent(EventQueue queue) {
        this.flushPendingEvents();
        return queue.peekEvent();
    }

    private void flushPendingEvents() {
        try {
            flushEventMethod.invoke(sunToolkitClass, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    private static Window[] getWindows() {
        Frame[] frames;
        ArrayList windows = Lists.newArrayList();
        for (Frame frame : frames = Frame.getFrames()) {
            UITask.addWindow(frame, windows);
        }
        Window[] windowArray = new Window[windows.size()];
        windows.toArray(windowArray);
        return windowArray;
    }

    private static void addWindow(Window owner, List<Window> windows) {
        Window[] owned;
        windows.add(owner);
        for (Window w : owned = owner.getOwnedWindows()) {
            UITask.addWindow(w, windows);
        }
    }

    static {
        defaultMessage = "Please wait...";
        cartoonIcon = new ImageIcon(UITask.class.getResource("loadingprogress.gif"));
        isJre7Plus = true;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            conditionalClass = loader.loadClass(AWT_CONDITIONAL_CLASS);
            Class<?> edtClass = loader.loadClass(AWT_EDT_CLASS);
            pumpEventsMethod = edtClass.getDeclaredMethod(PUMP_EVENTS_METHOD, conditionalClass);
            pumpEventsMethod.setAccessible(true);
            sunToolkitClass = loader.loadClass(SUN_TOOLKIT_CLASS);
            flushEventMethod = sunToolkitClass.getMethod(FLUSH_EVENT_METHOD, new Class[0]);
            try {
                pushPopLockField = EventQueue.class.getDeclaredField(PUSH_POP_LOCK_FIELD);
                pushPopCondField = EventQueue.class.getDeclaredField(PUSH_POP_COND_FIELD);
                pushPopLockField.setAccessible(true);
                pushPopCondField.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                isJre7Plus = false;
            }
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(-1);
        }
    }
}

