/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.kwt.plaf.basic;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.azolla.l.kwt.table.Tables;

public class DragAndDropRowTableUI
extends BasicTableUI {
    private boolean draging = false;
    private Point point;
    private int offset;
    private boolean direction = true;

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!this.draging) {
            return;
        }
        g.setColor(this.table.getParent().getBackground());
        Rectangle rect = this.table.getCellRect(this.table.getSelectedRow(), 0, false);
        int width = this.table.getWidth();
        int height = this.table.getRowHeight();
        if (this.direction) {
            g.copyArea(rect.x, rect.y, width, height, rect.x, this.offset * -1);
            g.fillRect(rect.x, rect.y + height - this.offset, width, this.offset);
        } else {
            g.copyArea(rect.x, rect.y, width, height, rect.x, this.offset);
            g.fillRect(rect.x, rect.y, width, this.offset * -1);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new BasicTableUI.MouseInputHandler(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                DragAndDropRowTableUI.this.point = e.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                TableCellEditor cellEditor = DragAndDropRowTableUI.this.table.getCellEditor();
                if (null != cellEditor) {
                    cellEditor.stopCellEditing();
                }
                int fromRow = DragAndDropRowTableUI.this.table.getSelectedRow();
                if (!Tables.rowInBound(DragAndDropRowTableUI.this.table, fromRow)) {
                    return;
                }
                DragAndDropRowTableUI.this.draging = true;
                int toRow = this.getDestRow(e.getPoint().y, fromRow);
                if (Tables.rowInBound(DragAndDropRowTableUI.this.table, toRow)) {
                    this.changeValue(fromRow, toRow);
                    DragAndDropRowTableUI.this.point = e.getPoint();
                }
                DragAndDropRowTableUI.this.offset = Math.abs(((DragAndDropRowTableUI)DragAndDropRowTableUI.this).point.y - e.getPoint().y);
                DragAndDropRowTableUI.this.direction = ((DragAndDropRowTableUI)DragAndDropRowTableUI.this).point.y - e.getPoint().y > 0;
                DragAndDropRowTableUI.this.table.repaint();
            }

            private int getDestRow(int y, int row) {
                int height = DragAndDropRowTableUI.this.table.getRowHeight();
                int middle = height * row + height / 2;
                if (y > middle + height) {
                    return ++row;
                }
                if (y < middle - height) {
                    return --row;
                }
                return -1;
            }

            private void changeValue(int fromRow, int toRow) {
                TableModel model = DragAndDropRowTableUI.this.table.getModel();
                int count = model.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    Object sourceValue = model.getValueAt(fromRow, i);
                    Object destValue = model.getValueAt(toRow, i);
                    model.setValueAt(destValue, fromRow, i);
                    model.setValueAt(sourceValue, toRow, i);
                }
                DragAndDropRowTableUI.this.table.setRowSelectionInterval(toRow, toRow);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                DragAndDropRowTableUI.this.draging = false;
                DragAndDropRowTableUI.this.table.repaint();
            }
        };
    }
}

