package org.javacs.lsp;

import java.util.List;

public class ServerCapabilities {
  public boolean definitionProvider;
  public boolean referencesProvider;
  public boolean hoverProvider;
  public RenameOptions renameProvider;
  public boolean documentHighlightProvider;
  public CodeLensOptions codeLensProvider;
  public boolean inlayHintProvider;
  public boolean documentSymbolProvider;
  public boolean workspaceSymbolProvider;
  public boolean foldingRangeProvider;
  public WorkspaceServerCapabilities workspace;
  // 2 = incremental, 0 = none, 1 = full
  public int textDocumentSync;
  public CompletionOptions completionProvider;

  public record RenameOptions(boolean prepareProvider) {}

  public record CodeLensOptions(boolean resolveProvider) {}

  public record CompletionOptions(boolean resolveProvider, List<String> triggerCharacters) {}

  public record WorkspaceFoldersOptions(boolean supported, boolean changeNotifications) {}

  public record WorkspaceServerCapabilities(WorkspaceFoldersOptions workspaceFolders) {}
}
