package org.javacs.lsp;

/**
 * This exception acts an error response returns from server
 */
public class ResponseErrorException extends Exception {
  /**
   * @see ErrorCodes
   */
  private final int errorCode;
  private final Object data;

  public ResponseErrorException(int errorCode, String message, Throwable cause, Object data) {
    super(message, cause);
    this.errorCode = errorCode;
    this.data = data;
  }

  public int errorCode() {
    return this.errorCode;
  }

  public Object data() {
    return data;
  }
}
