package org.javacs.lsp;

import java.util.List;
import java.util.Optional;

public interface LanguageServer {
  @LspRequest("initialize")
  default InitializeResult initialize(InitializeParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspNotification("initialized")
  default void initialized() {}

  @LspRequest("shutdown")
  default Object shutdown() {
    return null;
  }

  @LspNotification("exit")
  default void exit() {}

  @LspNotification("workspace/didChangeConfiguration")
  default void didChangeConfiguration(DidChangeConfigurationParams params) {}

  @LspNotification("textDocument/didOpen")
  default void didOpenTextDocument(DidOpenTextDocumentParams params) {}

  @LspNotification("textDocument/didChange")
  default void didChangeTextDocument(DidChangeTextDocumentParams params) {}

  @LspNotification("textDocument/willSave")
  default void willSaveTextDocument(WillSaveTextDocumentParams params) {}

  @LspRequest("textDocument/willSaveWaitUntil")
  default List<TextEdit> willSaveWaitUntilTextDocument(WillSaveTextDocumentParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspNotification("textDocument/didSave")
  default void didSaveTextDocument(DidSaveTextDocumentParams params) {}

  @LspNotification("textDocument/didClose")
  default void didCloseTextDocument(DidCloseTextDocumentParams params) {}

  @LspNotification("workspace/didChangeWatchedFiles")
  default void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {}

  @LspRequest("textDocument/completion")
  default Optional<CompletionList> completion(TextDocumentPositionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("completionItem/resolve")
  default CompletionItem resolveCompletionItem(CompletionItem params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/hover")
  default Optional<Hover> hover(TextDocumentPositionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/signatureHelp")
  default Optional<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/definition")
  default Optional<List<? extends GenericLocation>> gotoDefinition(TextDocumentPositionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/references")
  default Optional<List<Location>> findReferences(ReferenceParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/documentSymbol")
  default List<? extends GenericDocumentSymbol> documentSymbol(DocumentSymbolParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("workspace/symbol")
  default List<? extends GenericWorkspaceSymbol> workspaceSymbols(WorkspaceSymbolParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/codeAction")
  default List<CodeAction> codeAction(CodeActionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/codeLens")
  default List<CodeLens> codeLens(CodeLensParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("codeLens/resolve")
  default CodeLens resolveCodeLens(CodeLens params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/prepareRename")
  default Optional<RenameResponse> prepareRename(TextDocumentPositionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/rename")
  default WorkspaceEdit rename(RenameParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspNotification("workspace/didChangeWorkspaceFolders")
  default void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {}

  @LspRequest("textDocument/formatting")
  default List<TextEdit> formatting(DocumentFormattingParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/foldingRange")
  default List<FoldingRange> foldingRange(FoldingRangeParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/documentLink")
  default List<DocumentLink> documentLink(DocumentLinkParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/documentHighlight")
  default List<DocumentHighlight> documentHighlight(TextDocumentPositionParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  @LspRequest("textDocument/inlayHint")
  default List<InlayHint> inlayHint(InlayHintParams params) {
    throw new UnsupportedOperationException("Unimplemented");
  }

  default void doAsyncWork() {}
}
