/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.lsp.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class JsonElementTypeAdapter
extends TypeAdapter<Object> {
    private final Gson gson;
    private final TypeAdapter<JsonElement> adapter;

    public JsonElementTypeAdapter(Gson gson) {
        this.gson = gson;
        this.adapter = gson.getAdapter(JsonElement.class);
    }

    public JsonElement read(JsonReader in) throws IOException {
        return (JsonElement)this.adapter.read(in);
    }

    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof JsonElement) {
            this.adapter.write(out, (Object)((JsonElement)value));
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new JsonElementTypeAdapter(gson);
        }
    }
}

