/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.lsp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javacs.lsp.CancelParams;
import org.javacs.lsp.LanguageClient;
import org.javacs.lsp.LanguageServer;
import org.javacs.lsp.LspNotification;
import org.javacs.lsp.LspRequest;
import org.javacs.lsp.Message;
import org.javacs.lsp.ResponseError;
import org.javacs.lsp.ResponseErrorException;
import org.javacs.lsp.adapters.EnumTypeAdapter;
import org.jetbrains.annotations.Nullable;

public class LSP {
    private static final String CONTENT_LENGTH = "Content-Length:";
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Logger LOG = Logger.getLogger("main");

    static String nextRequest(BufferedReader client) throws IOException {
        int contentLength = -1;
        while (true) {
            String line;
            if ((line = client.readLine()) == null) {
                throw new IOException("client closed");
            }
            if (line.isEmpty()) {
                return LSP.nextMessage(client, contentLength);
            }
            if (!line.toLowerCase().startsWith(CONTENT_LENGTH.toLowerCase())) continue;
            try {
                contentLength = Integer.parseInt(line.substring(CONTENT_LENGTH.length()).trim());
                continue;
            }
            catch (NumberFormatException ignored) {
                LOG.log(Level.SEVERE, "Unable to parse content-length header: " + line);
                continue;
            }
            break;
        }
    }

    static String nextMessage(BufferedReader client, int length) throws IOException {
        char ch;
        int skipped;
        int read;
        if (length < 0) {
            throw new IOException("Unexpected length: " + length);
        }
        char[] buffer = new char[4096];
        StringBuilder builder = new StringBuilder();
        for (int remaining = length; remaining > 0; remaining -= read) {
            int needs = Math.min(remaining, buffer.length);
            read = client.read(buffer, 0, needs);
            builder.append(buffer, 0, read);
        }
        for (skipped = 0; skipped < length && Character.isWhitespace(ch = builder.charAt(0)); ++skipped) {
            builder.deleteCharAt(0);
        }
        read = client.read(buffer, 0, skipped);
        builder.append(buffer, 0, read);
        if (read != skipped) {
            throw new IOException("Cannot re-read chars for skipped whitespaces, expected " + skipped + ", but read " + read);
        }
        return builder.toString();
    }

    static Message parseMessage(String token) {
        return (Message)gson.fromJson(token, Message.class);
    }

    private static void writeClient(OutputStream client, String messageText) {
        byte[] messageBytes = messageText.getBytes(UTF_8);
        String headerText = String.format("%s %d\r\n\r\n", CONTENT_LENGTH, messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            client.write(headerBytes);
            client.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String toJson(Object message) {
        return gson.toJson(message);
    }

    static void respond(OutputStream client, int requestId, Object params) {
        if (params instanceof ResponseError) {
            ResponseError error = (ResponseError)params;
            throw new RuntimeException("Errors should be sent using LSP.error(...), " + error.message);
        }
        if (params instanceof Optional) {
            Optional option = (Optional)params;
            params = option.orElse(null);
        }
        String jsonText = LSP.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"result\":%s}", requestId, jsonText);
        LSP.writeClient(client, messageText);
    }

    static void error(OutputStream client, int requestId, ResponseError error) {
        String jsonText = LSP.toJson(error);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"error\":%s}", requestId, jsonText);
        LSP.writeClient(client, messageText);
    }

    private static <T extends LanguageClient> T createClientProxy(Class<T> clientClass, OutputStream client) {
        return (T)((LanguageClient)Proxy.newProxyInstance(clientClass.getClassLoader(), new Class[]{clientClass}, (InvocationHandler)new ClientHandler(client)));
    }

    public static <T extends LanguageClient> void connect(Class<T> clientClass, Function<T, LanguageServer> serverFactory, InputStream receive, OutputStream send) {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(receive));
        T client = LSP.createClientProxy(clientClass, send);
        LanguageServer server = serverFactory.apply(client);
        final ArrayBlockingQueue pending = new ArrayBlockingQueue(10);
        HashMap<String, Handler> handlerCache = new HashMap<String, Handler>();
        Thread readerThread = new Thread(new Runnable(){

            void peek(Message message) {
                if (message.method.equals("$/cancelRequest")) {
                    CancelParams params = (CancelParams)gson.fromJson(message.params, CancelParams.class);
                    boolean removed = pending.removeIf(r -> r.id != null && r.id.equals(params.id));
                    if (removed) {
                        LOG.info(String.format("Cancelled request %d, which had not yet started", params.id));
                    } else {
                        LOG.info(String.format("Cannot cancel request %d because it has already started", params.id));
                    }
                }
            }

            private boolean kill() {
                LOG.info("Read stream has been closed, putting kill message onto queue...");
                try {
                    pending.put(Message.EOF);
                    return true;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                    return false;
                }
            }

            @Override
            public void run() {
                LOG.info("Placing incoming messages on queue...");
                while (true) {
                    try {
                        while (true) {
                            String token = LSP.nextRequest(reader);
                            Message message = LSP.parseMessage(token);
                            this.peek(message);
                            pending.put(message);
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        if (!this.kill()) continue;
                        return;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        continue;
                    }
                    break;
                }
            }
        });
        readerThread.setName("LSP Reader Thread");
        readerThread.setDaemon(true);
        readerThread.start();
        LOG.info("Reading messages from queue...");
        boolean hasAsyncWork = false;
        while (true) {
            Message r;
            try {
                r = (Message)pending.poll(200L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (r == Message.EOF) break;
            if (r == null) {
                if (!hasAsyncWork) continue;
                server.doAsyncWork();
                hasAsyncWork = false;
                continue;
            }
            hasAsyncWork = true;
            try {
                Object result;
                if (r.method.equals("$/cancelRequest")) continue;
                Handler hdl = (Handler)handlerCache.get(r.method);
                if (hdl == null && (hdl = LSP.findHandler(server.getClass(), r.method)) != null) {
                    handlerCache.put(r.method, hdl);
                }
                if (hdl == null) {
                    LOG.warning(String.format("Don't know what to do with method `%s`", r.method));
                    continue;
                }
                Object param = hdl.paramType == null ? null : gson.fromJson(r.params, hdl.paramType);
                Object object = result = param == null ? hdl.method.invoke((Object)server, new Object[0]) : hdl.method.invoke((Object)server, param);
                if (!hdl.isRequest) continue;
                LSP.respond(send, r.id, result);
            }
            catch (Exception e) {
                InvocationTargetException ex;
                Throwable cause;
                LOG.log(Level.SEVERE, e.getMessage(), e);
                if (r.id == null) continue;
                boolean handled = false;
                if (e instanceof InvocationTargetException && (cause = (ex = (InvocationTargetException)e).getTargetException()) instanceof ResponseErrorException) {
                    ResponseErrorException respErr = (ResponseErrorException)cause;
                    LSP.error(send, r.id, new ResponseError(respErr.errorCode, respErr.getMessage(), respErr.data));
                    handled = true;
                }
                if (handled) continue;
                LSP.error(send, r.id, new ResponseError(-32603, e.getMessage(), null));
            }
        }
        LOG.warning("Stream from client has been closed, exiting...");
    }

    private static Handler findHandler(Class<?> server, String rpcMethod) {
        if (server == null) {
            return null;
        }
        Handler handler = LSP.findHandler(server.getSuperclass(), rpcMethod);
        if (handler != null) {
            return handler;
        }
        for (Class<?> clazz : server.getInterfaces()) {
            handler = LSP.findHandler(clazz, rpcMethod);
            if (handler == null) continue;
            return handler;
        }
        for (GenericDeclaration genericDeclaration : server.getDeclaredMethods()) {
            handler = LSP.checkMethod(rpcMethod, (Method)genericDeclaration);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    private static Handler checkMethod(String rpcMethod, Method method) {
        Class<?> param;
        LspRequest req = method.getAnnotation(LspRequest.class);
        LspNotification not = method.getAnnotation(LspNotification.class);
        if (req == null && not == null) {
            return null;
        }
        if (req != null && not != null) {
            LOG.log(Level.WARNING, "Method " + method.getName() + " tries to handle both notification and request");
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> clazz = param = paramTypes.length > 0 ? paramTypes[0] : null;
        if (req != null && req.value().equals(rpcMethod)) {
            return new Handler(method, param, true);
        }
        if (not != null && not.value().equals(rpcMethod)) {
            return new Handler(method, param, false);
        }
        return null;
    }

    private record ClientHandler(OutputStream client) implements InvocationHandler
    {
        private void notifyClient(String method, Object params) {
            if (params instanceof Optional) {
                Optional option = (Optional)params;
                params = option.orElse(null);
            }
            String jsonText = LSP.toJson(params);
            String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s}", method, jsonText);
            LSP.writeClient(this.client, messageText);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LspNotification notification = method.getAnnotation(LspNotification.class);
            if (notification == null) {
                if (method.isDefault()) {
                    return InvocationHandler.invokeDefault(proxy, method, args);
                }
                LOG.log(Level.WARNING, "Language client method " + method.getName() + " is neither a JsonRPC method nor a default method");
                return null;
            }
            String rpcMethod = notification.value();
            Object params = method.getParameterCount() > 0 ? args[0] : null;
            this.notifyClient(rpcMethod, params);
            return null;
        }
    }

    private record Handler(Method method, Class<?> paramType, boolean isRequest) {
    }
}

