package org.javacs.lsp;

import org.intellij.lang.annotations.MagicConstant;

import java.util.List;

public class ServerCapabilities {
  public boolean definitionProvider;
  public boolean referencesProvider;
  public boolean hoverProvider;
  public RenameOptions renameProvider;
  public boolean documentHighlightProvider;
  public CodeLensOptions codeLensProvider;
  public boolean inlayHintProvider;
  public boolean documentSymbolProvider;
  public boolean workspaceSymbolProvider;
  public boolean foldingRangeProvider;
  public WorkspaceServerCapabilities workspace;
  @MagicConstant(valuesFromClass = DocumentSyncKind.class)
  public int textDocumentSync;
  public CompletionOptions completionProvider;

  public record RenameOptions(boolean prepareProvider) {}

  public record CodeLensOptions(boolean resolveProvider) {}

  public record CompletionOptions(
    boolean resolveProvider,
    List<String> triggerCharacters,
    List<String> allCommitCharacters
  ) {}

  public record WorkspaceFoldersOptions(boolean supported, boolean changeNotifications) {}

  public record WorkspaceServerCapabilities(WorkspaceFoldersOptions workspaceFolders) {}
}
