package org.javacs.lsp;

public interface CompletionTriggerKind {
  /**
   * Completion was triggered by typing an identifier (24x7 code complete), manual invocation (e.g Ctrl+Space) or via
   * API.
   */
  int Invoked = 1;

  /**
   * Completion was triggered by a trigger character specified by the `triggerCharacters` properties of the
   * `CompletionRegistrationOptions`.
   */
  int TriggerCharacter = 2;

  /** Completion was re-triggered as the current completion list is incomplete. */
  int TriggerForIncompleteCompletions = 3;
}
