package org.javacs.lsp;

import org.intellij.lang.annotations.MagicConstant;

/**
 * This exception acts an error response returns from server
 */
public class ResponseErrorException extends Exception {
  @MagicConstant(valuesFromClass = ErrorCodes.class)
  public final int errorCode;
  public final Object data;

  public ResponseErrorException(
    @MagicConstant(valuesFromClass = ErrorCodes.class) int errorCode,
    String message, Throwable cause, Object data
  ) {
    super(message, cause);
    this.errorCode = errorCode;
    this.data = data;
  }
}
