package org.javacs.lsp;

import org.intellij.lang.annotations.MagicConstant;

import java.util.List;

public final class DocumentSymbol implements GenericDocumentSymbol {
  public String name, detail;
  @MagicConstant(valuesFromClass = SymbolKind.class)
  public int kind;
  public boolean deprecated;
  public Range range, selectionRange;
  public List<DocumentSymbol> children;

  public DocumentSymbol(String name, String detail, int kind, boolean deprecated, Range range, Range selectionRange, List<DocumentSymbol> children) {
    this.name = name;
    this.detail = detail;
    this.kind = kind;
    this.deprecated = deprecated;
    this.range = range;
    this.selectionRange = selectionRange;
    this.children = children;
  }
}
