package org.javacs.lsp;

import java.util.List;
import java.util.Optional;

public interface LanguageServer {
  @LspRequest("initialize")
  InitializeResult initialize(InitializeParams params);

  @LspNotification("initialized")
  default void initialized() {}

  @LspRequest("shutdown")
  default Object shutdown() {
    return null;
  }

  @LspNotification("exit")
  default void exit() {}

  @LspNotification("workspace/didChangeConfiguration")
  default void didChangeConfiguration(DidChangeConfigurationParams params) {}

  @LspNotification("textDocument/didOpen")
  default void didOpenTextDocument(DidOpenTextDocumentParams params) {}

  @LspNotification("textDocument/didChange")
  default void didChangeTextDocument(DidChangeTextDocumentParams params) {}

  @LspNotification("textDocument/willSave")
  default void willSaveTextDocument(WillSaveTextDocumentParams params) {}

  @LspRequest("textDocument/willSaveWaitUntil")
  List<TextEdit> willSaveWaitUntilTextDocument(WillSaveTextDocumentParams params);

  @LspNotification("textDocument/didSave")
  default void didSaveTextDocument(DidSaveTextDocumentParams params) {}

  @LspNotification("textDocument/didClose")
  default void didCloseTextDocument(DidCloseTextDocumentParams params) {}

  @LspNotification("workspace/didChangeWatchedFiles")
  default void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {}

  @LspRequest("textDocument/completion")
  Optional<CompletionList> completion(TextDocumentPositionParams params);

  @LspRequest("completionItem/resolve")
  CompletionItem resolveCompletionItem(CompletionItem params);

  @LspRequest("textDocument/hover")
  Optional<Hover> hover(TextDocumentPositionParams params);

  @LspRequest("textDocument/signatureHelp")
  Optional<SignatureHelp> signatureHelp(TextDocumentPositionParams params);

  @LspRequest("textDocument/definition")
  Optional<List<? extends GenericLocation>> gotoDefinition(TextDocumentPositionParams params);

  @LspRequest("textDocument/references")
  Optional<List<Location>> findReferences(ReferenceParams params);

  @LspRequest("textDocument/documentSymbol")
  List<? extends GenericDocumentSymbol> documentSymbol(DocumentSymbolParams params);

  @LspRequest("workspace/symbol")
  List<? extends GenericWorkspaceSymbol> workspaceSymbols(WorkspaceSymbolParams params);

  @LspRequest("textDocument/codeAction")
  List<CodeAction> codeAction(CodeActionParams params);

  @LspRequest("textDocument/codeLens")
  List<CodeLens> codeLens(CodeLensParams params);

  @LspRequest("codeLens/resolve")
  CodeLens resolveCodeLens(CodeLens params);

  @LspRequest("textDocument/prepareRename")
  Optional<RenameResponse> prepareRename(TextDocumentPositionParams params);

  @LspRequest("textDocument/rename")
  WorkspaceEdit rename(RenameParams params);

  @LspNotification("workspace/didChangeWorkspaceFolders")
  default void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {}

  @LspRequest("textDocument/formatting")
  List<TextEdit> formatting(DocumentFormattingParams params);

  @LspRequest("textDocument/foldingRange")
  List<FoldingRange> foldingRange(FoldingRangeParams params);

  @LspRequest("textDocument/documentLink")
  List<DocumentLink> documentLink(DocumentLinkParams params);

  @LspRequest("textDocument/documentHighlight")
  List<DocumentHighlight> documentHighlight(TextDocumentPositionParams params);

  @LspRequest("textDocument/inlayHint")
  List<InlayHint> inlayHint(InlayHintParams params);

  default void doAsyncWork() {}
}
