package org.javacs.lsp;

import com.google.gson.annotations.JsonAdapter;
import org.javacs.lsp.adapters.JsonElementTypeAdapter;

/** Copied from lsp4j. */
public class InlayHint {
  /**
   * The position of this hint.
   */
  public Position position;

  public String label;
  
  /**
   * The kind of this hint. Can be omitted in which case the client
   * should fall back to a reasonable default.
   */
  public InlayHintKind kind;
  
  // /**
  //  * The tooltip text when you hover over this item.
  //  * <p>
  //  * Depending on the client capability {@link InlayHintCapabilities#resolveSupport} clients
  //  * might resolve this property late using the resolve request.
  //  */
  // private Either<String, MarkupContent> tooltip;
  
  /**
   * Render padding before the hint.
   * <p>
   * Note: Padding should use the editor's background color, not the
   * background color of the hint itself. That means padding can be used
   * to visually align/separate an inlay hint.
   */
  public Boolean paddingLeft;
  
  /**
   * Render padding after the hint.
   * <p>
   * Note: Padding should use the editor's background color, not the
   * background color of the hint itself. That means padding can be used
   * to visually align/separate an inlay hint.
   */
  public Boolean paddingRight;
  
  /**
   * A data entry field that is preserved on a inlay hint between
   * a {@code textDocument/inlayHint} and a {@code inlayHint/resolve} request.
   */
  @JsonAdapter(JsonElementTypeAdapter.Factory.class)
  public Object data;

  public InlayHint(Position position, String label) {
    this.position = position;
    this.label = label;
  }
}
