/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.lsp.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private static String VALUE_FIELD_NAME = "value";
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<Integer, T> valueToConstant = new HashMap<Integer, T>();
    private final Map<T, Integer> constantToValue = new HashMap<T, Integer>();

    EnumTypeAdapter(Class<T> classOfT) throws IllegalAccessException {
        try {
            Field valueField = classOfT.getDeclaredField(VALUE_FIELD_NAME);
            if (valueField.getType() != Integer.TYPE && valueField.getType() != Integer.class) {
                throw new IllegalArgumentException("The field 'value' must contain an integer value.");
            }
            valueField.setAccessible(true);
            for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                this.nameToConstant.put(constant.name(), constant);
                Integer constValue = (Integer)valueField.get(constant);
                this.valueToConstant.put(constValue, constant);
                this.constantToValue.put(constant, constValue);
            }
        }
        catch (NoSuchFieldException e) {
            for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                this.nameToConstant.put(constant.name(), constant);
                int constValue = constant.ordinal();
                this.valueToConstant.put(constValue, constant);
                this.constantToValue.put(constant, constValue);
            }
        }
    }

    public T read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (peek == JsonToken.NUMBER) {
            return (T)((Enum)this.valueToConstant.get(in.nextInt()));
        }
        String string = in.nextString();
        try {
            return (T)((Enum)this.valueToConstant.get(Integer.parseInt(string)));
        }
        catch (NumberFormatException e) {
            return (T)((Enum)this.nameToConstant.get(string));
        }
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value != null) {
            out.value((Number)this.constantToValue.get(value));
        } else {
            out.value((String)null);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            try {
                return new EnumTypeAdapter(rawType);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

