package org.javacs.lsp;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("unused")
public interface LanguageClient {
  @LspNotification("textDocument/publishDiagnostics")
  default void publishDiagnostics(@NotNull PublishDiagnosticsParams params) {
  }

  @LspNotification("window/showMessage")
  default void showMessage(@NotNull ShowMessageParams params) {
  }

  @LspNotification("window/logMessage")
  default void logMessage(ShowMessageParams message) {
  }

  @LspNotification("client/registerCapability")
  default void registerCapability(@NotNull RegistrationParams params) {
  }
}
