package org.javacs.lsp;

import org.intellij.lang.annotations.MagicConstant;

import java.util.List;

public class CodeAction {
  public String title;
  @MagicConstant(valuesFromClass = CodeActionKind.class)
  public String kind;
  public List<Diagnostic> diagnostics;
  public WorkspaceEdit edit;
  public Command command;

  private CodeAction() {
  }

  public CodeAction(String title, String kind, List<Diagnostic> diagnostics, WorkspaceEdit edit, Command command) {
    this.title = title;
    this.kind = kind;
    this.diagnostics = diagnostics;
    this.edit = edit;
    this.command = command;
  }

  public static CodeAction NONE = new CodeAction();
}
