package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

public class UserDataHolderBase implements UserDataHolder {
  private final Map<Key<?>, Object> myMap = new HashMap<>(0);

  @Override
  public <T> @Nullable T getUserData(@NotNull Key<T> key) {
    //noinspection unchecked
    T value = (T) myMap.get(key);
    if (value == null && key instanceof KeyWithDefaultValue<T> kwdv) {
      value = kwdv.getDefaultValue();
      putUserData(key, value);
    }
    return value;
  }

  @Override
  public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
    myMap.put(key, value);
  }
}
