package org.aya.intellij;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.parsing.AstMarkersSyntaxNode;
import com.jetbrains.lang.parsing.builder.AstMarkerVisitorKt;
import com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.text.StringSlice;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

public record MarkerNodeWrapper(
  @NotNull AstMarkersSyntaxNode node,
  @Override @NotNull StringSlice tokenText
) implements GenericNode<MarkerNodeWrapper> {
  public MarkerNodeWrapper(@NotNull String code, @NotNull AstMarkersSyntaxNode node) {
    this(node, StringSlice.of(code, (int) node.getStartOffset(), (int) node.getEndOffset()));
  }

  @Override public @NotNull IElementType elementType() {
    return node.getElementType();
  }

  @SuppressWarnings("UnstableApiUsage") @Override
  public @NotNull SeqView<MarkerNodeWrapper> childrenView() {
    var java = SequencesKt.toList(SyntaxNodeExtKt.children(node));
    return Seq.wrapJava(java).view().map(c -> new MarkerNodeWrapper(tokenText.source(), (AstMarkersSyntaxNode) c));
  }

  @Override public @NotNull TextRange range() {
    return new TextRange((int) node.getStartOffset(), (int) node.getEndOffset());
  }

  @Override public @NotNull String toDebugString() {
    return AstMarkerVisitorKt.toDebugString(node);
  }
}
