/*
 * Decompiled with CFR 0.152.
 */
package org.aya.intellij;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Objects;
import kala.collection.SeqView;
import kala.text.StringSlice;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericNode<N extends GenericNode<N>> {
    @NotNull
    public IElementType elementType();

    @NotNull
    public StringSlice tokenText();

    @NotNull
    public TextRange range();

    @NotNull
    public SeqView<N> childrenView();

    @NotNull
    @NonNls
    default public String toDebugString() {
        return this.toString();
    }

    default public boolean is(@NotNull IElementType type) {
        return this.elementType() == type;
    }

    default public boolean is(@NotNull TokenSet tokenSet) {
        return tokenSet.contains(this.elementType());
    }

    @NotNull
    default public SeqView<N> childrenOfType(@NotNull IElementType type) {
        return this.childrenView().filter(c -> c.is(type));
    }

    @NotNull
    default public SeqView<N> childrenOfType(@NotNull TokenSet tokenSet) {
        return this.childrenView().filter(c -> c.is(tokenSet));
    }

    default public N firstChild() {
        return (N)((GenericNode)this.childrenView().getFirst());
    }

    default public N lastChild() {
        return (N)((GenericNode)this.childrenView().getLast());
    }

    default public N firstChildOrNull() {
        return (N)((GenericNode)this.childrenView().getFirstOrNull());
    }

    @Nullable
    default public N peekChild(@NotNull IElementType type) {
        return (N)((GenericNode)this.childrenOfType(type).getFirstOrNull());
    }

    @Nullable
    default public N peekChild(@NotNull TokenSet tokenSet) {
        return (N)((GenericNode)this.childrenOfType(tokenSet).getFirstOrNull());
    }

    @NotNull
    default public N child(@NotNull IElementType type) {
        return (N)((GenericNode)Objects.requireNonNull(this.peekChild(type)));
    }

    @NotNull
    default public N child(@NotNull TokenSet tokenSet) {
        return (N)((GenericNode)Objects.requireNonNull(this.peekChild(tokenSet)));
    }
}

