package org.aya.intellij;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.tree.IElementType;
import kala.collection.SeqView;
import kala.text.StringSlice;
import org.jetbrains.annotations.NotNull;

public record MarkerNodeWrapper(
  @NotNull MarkerNode node,
  @Override @NotNull StringSlice tokenText
) implements GenericNode<MarkerNodeWrapper> {
  public MarkerNodeWrapper(@NotNull String code, @NotNull MarkerNode node) {
    this(node, StringSlice.of(code, node.range().getStartOffset(), node.range().getEndOffset()));
  }

  @Override public @NotNull IElementType elementType() {
    return node.elementType();
  }

  @SuppressWarnings("UnstableApiUsage") @Override
  public @NotNull SeqView<MarkerNodeWrapper> childrenView() {
    return node.children().view().map(c -> new MarkerNodeWrapper(tokenText.source(), c));
  }

  @Override public @NotNull TextRange range() {
    return node.range();
  }

  @Override public @NotNull String toDebugString() {
    return node.toDebugString("  ");
  }
}
