package com.intellij.psi;

import com.intellij.AyaModified;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.builder.ASTMarkerVisitor;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerPsiBuilder;
import com.intellij.psi.builder.MarkerNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

/** rewrite of FleetPsiParser.kt */
@AyaModified
public interface FleetPsiParser {
  void parse(@NotNull IElementType elementType, @NotNull FleetPsiBuilder<?> builder);

  /** rewrite of `FleetPsiParser.parse(text: String): Node` in AstMarkerVisitor.kt, modified */
  @AyaModified
  default @NotNull MarkerNode parse(@NotNull IElementType elementType, @NotNull String text) {
    var tokens = new ArrayTokenSequence.Builder(text, getLexer()).performLexing();
    var markerPsiBuilder = new MarkerPsiBuilder<>(
      text, tokens, getWhitespaces(), getComments(),
      0, tokens.getLexemeCount());
    parse(elementType, wrap(markerPsiBuilder));
    var root = new MarkerNode(elementType, 0, text.length(), text, null);
    new ASTMarkerVisitor(this, markerPsiBuilder.getRoot(), getWhitespaces(), getComments(), tokens, text)
      .visitTree(markerPsiBuilder.getRoot(), 0, 0, 0, root);
    return root;
  }

  default <T> @NotNull FleetPsiBuilder<T> wrap(@NotNull FleetPsiBuilder<T> builder) {
    return builder;
  }

  /* override val */
  @NotNull Lexer getLexer();
  /* override val */
  @NotNull TokenSet getWhitespaces();
  /* override val */
  @NotNull TokenSet getComments();

  @AyaModified
  abstract class DefaultPsiParser implements FleetPsiParser {
    private final @NotNull ParserDefinition parserDefinition;
    private final @NotNull LightPsiParser parser;
    private final /* override val */ @NotNull Lexer lexer;
    private final /* override val */ @NotNull TokenSet whitespaces;
    private final /* override val */ @NotNull TokenSet comments;

    protected DefaultPsiParser(@NotNull ParserDefinition parserDefinition) {
      this.parserDefinition = parserDefinition;
      this.parser = (LightPsiParser) parserDefinition.createParser(null);
      this.lexer = parserDefinition.createLexer(null);
      this.whitespaces = parserDefinition.getWhitespaceTokens();
      this.comments = parserDefinition.getCommentTokens();
    }

    @Override public void parse(@NotNull IElementType elementType, @NotNull FleetPsiBuilder<?> builder) {
      parser.parseLight(elementType, builder);
    }

    public @NotNull MarkerNode parse(@NotNull String text) {
      return parse(parserDefinition.getFileNodeType(), text);
    }

    @Override public @NotNull Lexer getLexer() {
      return lexer;
    }

    @Override public @NotNull TokenSet getWhitespaces() {
      return whitespaces;
    }

    @Override public @NotNull TokenSet getComments() {
      return comments;
    }
  }
}
