/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.builder;

import com.intellij.lexer.Lexer;
import com.intellij.psi.ArrayTokenSequence;
import com.intellij.psi.FleetPsiParser;
import com.intellij.psi.builder.ASTMarkers;
import com.intellij.psi.builder.FleetPsiBuilder;
import com.intellij.psi.builder.MarkerPsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import kala.collection.SeqView;
import kala.collection.mutable.MutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ASTMarkerVisitor(@NotNull FleetPsiParser psiParser, @NotNull ASTMarkers<?> root, @NotNull TokenSet whitespaces, @NotNull TokenSet comments, @NotNull ArrayTokenSequence tokens, @NotNull String text) {
    public void visitTree(@NotNull ASTMarkers<?> astMarkers, int startLexemeOffset, int currentMarker, int currentOffset, @NotNull Node parent) {
        IElementType iElementType = astMarkers.elementType(currentMarker);
        if (iElementType instanceof ILazyParseableElementType) {
            ILazyParseableElementType elementType = (ILazyParseableElementType)iElementType;
            if (astMarkers.collapsed(currentMarker)) {
                this.parseChameleon(startLexemeOffset, astMarkers.lexemeCount(currentMarker), elementType, parent, currentOffset);
                return;
            }
        }
        ASTMarkers.check(astMarkers.kind(currentMarker) == 1 || astMarkers.kind(currentMarker) == 3, "");
        if (astMarkers.kind(currentMarker) == 3) {
            return;
        }
        int endLexemeOffset = this.getEndLexemeIndex(astMarkers, startLexemeOffset, currentMarker);
        int child = astMarkers.firstChild(currentMarker);
        int prevOffset = startLexemeOffset;
        int i = startLexemeOffset;
        while (i < endLexemeOffset) {
            if (child != -1 && prevOffset + astMarkers.lexemeRelOffset(child) == i) {
                int childStartLexemeOffset = prevOffset + astMarkers.lexemeRelOffset(child);
                prevOffset = i = this.getEndLexemeIndex(astMarkers, childStartLexemeOffset, child);
                Node node = new Node(astMarkers.elementType(child), this.offsetByLexemeIndex(childStartLexemeOffset) + currentOffset, this.offsetByLexemeIndex(i) + currentOffset, null, parent);
                this.visitTree(astMarkers, childStartLexemeOffset, child, currentOffset, node);
                child = astMarkers.nextSibling(child);
                continue;
            }
            Node node = new Node(this.tokens.lexType(i), this.offsetByLexemeIndex(i) + currentOffset, this.offsetByLexemeIndex(i + 1) + currentOffset, this.tokens.lexText(i), parent);
            IElementType iElementType2 = this.tokens.lexType(i);
            if (iElementType2 instanceof ILazyParseableElementType) {
                ILazyParseableElementType lexType = (ILazyParseableElementType)iElementType2;
                if (parent.elementType != node.elementType || parent.startOffset != node.startOffset || parent.endOffset != node.endOffset) {
                    this.parseChameleon(i, 1, lexType, node, currentOffset);
                    ++i;
                    continue;
                }
            }
            ++i;
        }
        while (child != -1) {
            new Node(astMarkers.elementType(child), this.offsetByLexemeIndex(i) + currentOffset, this.offsetByLexemeIndex(i + astMarkers.lexemeRelOffset(child)) + currentOffset, null, parent);
            i += astMarkers.lexemeRelOffset(child);
            child = astMarkers.nextSibling(child);
        }
    }

    private void parseChameleon(int startLexemeOffset, int lexCount, @NotNull ILazyParseableElementType elementType, @NotNull Node parent, int currentOffset) {
        FleetPsiBuilder chameleonPsiBuilder;
        int lexemeChameleonStart;
        ArrayTokenSequence chameleonTokens;
        String chameleonText;
        int newCurrentOffset;
        Lexer lexer = elementType.createInnerLexer();
        if (lexer != null) {
            int beginIndex = this.offsetByLexemeIndex(startLexemeOffset);
            int endIndex = this.offsetByLexemeIndex(startLexemeOffset + lexCount);
            newCurrentOffset = beginIndex + currentOffset;
            chameleonText = this.text.substring(beginIndex, endIndex);
            chameleonTokens = new ArrayTokenSequence.Builder(chameleonText, lexer).performLexing();
            lexemeChameleonStart = 0;
            chameleonPsiBuilder = this.psiParser.wrap(new MarkerPsiBuilder(chameleonText, chameleonTokens, this.whitespaces, this.comments, 0, chameleonTokens.getLexemeCount()));
        } else {
            chameleonTokens = this.tokens;
            newCurrentOffset = currentOffset;
            lexemeChameleonStart = startLexemeOffset;
            chameleonText = this.text;
            chameleonPsiBuilder = this.psiParser.wrap(new MarkerPsiBuilder(this.text, this.tokens, this.whitespaces, this.comments, startLexemeOffset, lexCount));
        }
        elementType.parse(chameleonPsiBuilder);
        ASTMarkerVisitor treePrinter = new ASTMarkerVisitor(this.psiParser, (ASTMarkers)chameleonPsiBuilder.getRoot(), this.whitespaces, this.comments, chameleonTokens, chameleonText);
        treePrinter.visitTree((ASTMarkers)chameleonPsiBuilder.getRoot(), lexemeChameleonStart, 0, newCurrentOffset, parent);
    }

    private int offsetByLexemeIndex(int i) {
        return i > this.tokens.getLexemeCount() ? this.text.length() : this.tokens.lexStart(i);
    }

    private int getEndLexemeIndex(@NotNull ASTMarkers<?> astMarkers, int startLexemeIndex, int index) {
        switch (astMarkers.kind(index)) {
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("No default");
            }
        }
        return startLexemeIndex + astMarkers.lexemeCount(index);
    }

    public record Node(@NotNull IElementType elementType, int startOffset, int endOffset, @Nullable String text, @Nullable Node parent, @NotNull MutableList<Node> children) {
        public Node(@NotNull IElementType elementType, int startOffset, int endOffset, @Nullable String text, @Nullable Node parent, @NotNull MutableList<Node> children) {
            this.elementType = elementType;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.parent = parent;
            this.text = text;
            this.children = children;
            if (parent != null) {
                parent.children.append((Object)this);
            }
        }

        public Node(@NotNull IElementType elementType, int startOffset, int endOffset, @Nullable String text, @Nullable Node parent) {
            this(elementType, startOffset, endOffset, text, parent, (MutableList<Node>)MutableList.create());
        }

        @NotNull
        public String tokenText() {
            if (this.text != null) {
                return this.text;
            }
            StringBuilder sb = new StringBuilder();
            this.buildText(sb);
            return sb.toString();
        }

        private void buildText(@NotNull StringBuilder builder) {
            if (this.text != null) {
                builder.append(this.text);
            } else {
                this.children.forEach(c -> c.buildText(builder));
            }
        }

        @Override
        @NotNull
        public String toString() {
            return "%s(%d, %d)".formatted(this.elementType, this.startOffset, this.endOffset);
        }

        @NotNull
        public SeqView<Node> childrenOfType(IElementType type) {
            return this.children.view().filter(c -> c.elementType == type);
        }

        @NotNull
        public String toDebugString() {
            StringBuilder builder = new StringBuilder();
            this.toDebugString(0, builder);
            return builder.toString();
        }

        private void toDebugString(int indent, @NotNull StringBuilder builder) {
            ASTMarkers.repeat(indent, i -> builder.append("\t"));
            builder.append("%s(%d..%d)%n".formatted(this.elementType, this.startOffset, this.endOffset));
            this.children.forEach(it -> it.toDebugString(indent + 1, builder));
        }
    }
}

