/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.parsing.builder;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.parsing.builder.ASTMarkers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kala.collection.base.Traversable;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.mutable.primitive.MutableIntList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.aya.kala.Int2IntOpenHashMap;
import org.aya.kala.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 N*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0004KLMNB\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0017\b\u0012\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J'\u0010#\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u00102\u0006\u0010$\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010%J,\u0010&\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0013\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u00100(0'H\u0016J&\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0002J\u001e\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J&\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u0002012\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001e\u00102\u001a\u00020\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00100\u001a\u000201H\u0002J \u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013H\u0002J$\u00107\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00132\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002J\u0018\u00109\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0013H\u0002J\u0018\u0010:\u001a\u00020*2\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013H\u0002J-\u0010;\u001a\u00020*2\u0006\u0010$\u001a\u00020\u00132\u0018\u0010<\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u0010\u00a2\u0006\u0002\u0010=J\u0016\u0010>\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u0013J\u001e\u0010@\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\u0013J\u0006\u0010B\u001a\u00020\u0013J:\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000bJ\b\u0010E\u001a\u00020\u000eH\u0016J-\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001d\u0010G\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000I\u0012\u0004\u0012\u00020*0H\u00a2\u0006\u0002\bJH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006O"}, d2={"Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl;", "T", "Lcom/jetbrains/lang/parsing/builder/ASTMarkers;", "<init>", "()V", "origin", "(Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl;)V", "packer", "Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer;", "elementTypes", "Lkala/collection/mutable/MutableList;", "Lcom/intellij/psi/tree/IElementType;", "errorMessages", "Lorg/aya/kala/Int2ObjectOpenHashMap;", "", "chameleonsMap", "Lcom/jetbrains/lang/parsing/builder/ChameleonRef;", "Ljava/util/concurrent/atomic/AtomicReference;", "nextId", "", "size", "getSize", "()I", "kind", "", "i", "errorMessage", "hasError", "", "id", "lexemeCount", "lexemeRelOffset", "collapsed", "markersCount", "elementType", "chameleonAt", "lexemeIndex", "(I)Ljava/util/concurrent/atomic/AtomicReference;", "chameleons", "", "Lkotlin/Pair;", "substituteImpl", "", "astMarkers", "copyNewChameleons", "startLexeme", "renumberNewMarkers", "start", "oldId2newId", "Lorg/aya/kala/Int2IntOpenHashMap;", "computeIdsForNewMarkers", "renumberIfNeeded", "nextNewId", "insertedStart", "insertedEnd", "copyNewAstMarkers", "end", "removeMarkersFromMaps", "renumber", "setChameleon", "reference", "(ILjava/util/concurrent/atomic/AtomicReference;)V", "setMarkersCount", "descCount", "setLexemeInfo", "relOffset", "pushBack", "setMarker", "index", "toString", "mutate", "mutator", "Lkotlin/Function1;", "Lcom/jetbrains/lang/parsing/builder/ASTMarkers$MutableContext;", "Lkotlin/ExtensionFunctionType;", "LexemeInfo", "Packer", "MutableContextImpl", "Companion", "ij-parsing-core"})
@SourceDebugExtension(value={"SMAP\nASTMarkersImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTMarkersImpl.kt\ncom/jetbrains/lang/parsing/builder/ASTMarkersImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,429:1\n1#2:430\n774#3:431\n865#3,2:432\n1863#3,2:434\n1863#3,2:438\n1863#3,2:440\n1863#3,2:442\n1863#3,2:444\n216#4,2:436\n*S KotlinDebug\n*F\n+ 1 ASTMarkersImpl.kt\ncom/jetbrains/lang/parsing/builder/ASTMarkersImpl\n*L\n116#1:431\n116#1:432,2\n117#1:434,2\n127#1:438,2\n142#1:440,2\n166#1:442,2\n176#1:444,2\n118#1:436,2\n*E\n"})
public final class ASTMarkersImpl<T>
implements ASTMarkers<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Packer packer;
    @NotNull
    private final MutableList<IElementType> elementTypes;
    @NotNull
    private final Int2ObjectOpenHashMap<String> errorMessages;
    @NotNull
    private final Int2ObjectOpenHashMap<AtomicReference<T>> chameleonsMap;
    private int nextId;
    private static final int DEFAULT_CAPACITY = 256;

    public ASTMarkersImpl() {
        this.packer = new Packer();
        this.elementTypes = (MutableList)MutableArrayList.create((int)256);
        this.errorMessages = new Int2ObjectOpenHashMap();
        this.chameleonsMap = new Int2ObjectOpenHashMap();
        this.nextId = 0;
    }

    private ASTMarkersImpl(ASTMarkersImpl<T> origin) {
        this.packer = origin.packer.copy();
        this.elementTypes = (MutableList)MutableArrayList.from((Iterable)((Iterable)origin.elementTypes));
        this.errorMessages = origin.errorMessages.clone();
        this.chameleonsMap = origin.chameleonsMap.clone();
        this.nextId = origin.nextId;
    }

    @Override
    public int getSize() {
        return this.packer.getSize();
    }

    @Override
    public byte kind(int i) {
        return this.packer.kind(i);
    }

    @Override
    @Nullable
    public String errorMessage(int i) {
        return this.hasError(i) ? this.errorMessages.get(this.id(i)) : null;
    }

    public final boolean hasError(int i) {
        return this.packer.hasErrors(i);
    }

    public final int id(int i) {
        return this.packer.id(i);
    }

    @Override
    public int lexemeCount(int i) {
        return this.packer.lexemeInfo(i).getCount();
    }

    @Override
    public int lexemeRelOffset(int i) {
        return this.packer.lexemeInfo(i).getRelOffset();
    }

    @Override
    public boolean collapsed(int i) {
        return this.packer.collapsed(i);
    }

    @Override
    public int markersCount(int i) {
        return this.packer.markersCount(i);
    }

    @Override
    @NotNull
    public IElementType elementType(int i) {
        Object object = this.elementTypes.get(i);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (IElementType)object;
    }

    @Override
    @NotNull
    public AtomicReference<T> chameleonAt(int lexemeIndex) {
        AtomicReference<T> atomicReference = this.chameleonsMap.get(lexemeIndex);
        Intrinsics.checkNotNullExpressionValue(atomicReference, (String)"get(...)");
        return atomicReference;
    }

    @Override
    @NotNull
    public List<Pair<Integer, AtomicReference<T>>> chameleons() {
        List<Pair<Integer, AtomicReference<T>>> list = this.chameleonsMap.toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    private final void substituteImpl(ASTMarkers<T> astMarkers, int i, int lexemeIndex) {
        if (!(astMarkers instanceof ASTMarkersImpl)) {
            boolean $i$a$-check-ASTMarkersImpl$substituteImpl$22 = false;
            String $i$a$-check-ASTMarkersImpl$substituteImpl$22 = "unexpected class: " + astMarkers.getClass();
            throw new IllegalStateException($i$a$-check-ASTMarkersImpl$substituteImpl$22.toString());
        }
        if (!(this.kind(i) == 1)) {
            String $i$a$-check-ASTMarkersImpl$substituteImpl$22 = "Check failed.";
            throw new IllegalStateException($i$a$-check-ASTMarkersImpl$substituteImpl$22.toString());
        }
        int start = i;
        int end = i + this.markersCount(i);
        int relOffset = this.lexemeRelOffset(i);
        Int2IntOpenHashMap oldId2newId = new Int2IntOpenHashMap();
        this.copyNewChameleons(lexemeIndex, (ASTMarkersImpl)astMarkers);
        this.removeMarkersFromMaps(start, end);
        int newNextId = this.computeIdsForNewMarkers((ASTMarkersImpl)astMarkers, oldId2newId);
        this.copyNewAstMarkers(start, end, (ASTMarkersImpl)astMarkers);
        this.renumberIfNeeded(newNextId, start, start + ((ASTMarkersImpl)astMarkers).getSize());
        this.renumberNewMarkers(start, oldId2newId, (ASTMarkersImpl)astMarkers);
        int count = this.lexemeCount(i);
        this.setLexemeInfo(i, count, relOffset);
        this.setLexemeInfo(i + ((ASTMarkersImpl)astMarkers).getSize() - 1, count, relOffset);
        this.nextId += newNextId;
    }

    /*
     * WARNING - void declaration
     */
    private final void copyNewChameleons(int startLexeme, ASTMarkersImpl<T> astMarkers) {
        Object element$iv;
        void $this$filterTo$iv$iv;
        Set set = this.chameleonsMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Integer it = (Integer)element$iv$iv;
            boolean bl = false;
            if (!(startLexeme <= it && it < startLexeme + astMarkers.lexemeCount(0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            Integer it = (Integer)element$iv;
            boolean bl = false;
            this.chameleonsMap.remove(it);
        }
        $this$forEach$iv = astMarkers.chameleonsMap;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv = iterator2.next();
            boolean bl = false;
            Integer k = (Integer)object.getKey();
            AtomicReference v = (AtomicReference)object.getValue();
            ((Map)this.chameleonsMap).put(k + startLexeme, v);
        }
    }

    private final void renumberNewMarkers(int start, Int2IntOpenHashMap oldId2newId, ASTMarkersImpl<T> astMarkers) {
        int offset = this.nextId;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)start, (int)(start + astMarkers.getSize()));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int oldId = this.id(index);
            int newId = ((Number)oldId2newId.get(oldId)).intValue() + offset;
            if (this.hasError(index)) {
                Integer n = newId;
                ((Map)this.errorMessages).put(n, astMarkers.errorMessages.get(oldId));
            }
            this.packer.setId(index, newId);
        }
    }

    private final int computeIdsForNewMarkers(ASTMarkersImpl<T> astMarkers, Int2IntOpenHashMap oldId2newId) {
        Ref.IntRef nextNewId = new Ref.IntRef();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)astMarkers.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            oldId2newId.computeIfAbsent(astMarkers.id(index), arg_0 -> ASTMarkersImpl.computeIdsForNewMarkers$lambda$7$lambda$6(arg_0 -> ASTMarkersImpl.computeIdsForNewMarkers$lambda$7$lambda$5(nextNewId, arg_0), arg_0));
        }
        return nextNewId.element;
    }

    private final void renumberIfNeeded(int nextNewId, int insertedStart, int insertedEnd) {
        if (this.packer.getShortMode() && this.nextId + nextNewId > 65535) {
            this.nextId = 0;
            this.renumber(insertedStart, insertedEnd);
        }
    }

    private final void copyNewAstMarkers(int start, int end, ASTMarkersImpl<?> astMarkers) {
        this.elementTypes.removeInRange(start, end + 1);
        this.elementTypes.insertAll(start, (Traversable)astMarkers.elementTypes);
        this.packer.replace(start, end + 1, astMarkers.packer);
    }

    private final void removeMarkersFromMaps(int start, int end) {
        Iterable $this$forEach$iv = (Iterable)new IntRange(start, end);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int currentId = this.id(index);
            if (!this.hasError(index)) continue;
            this.errorMessages.remove(currentId);
        }
    }

    private final void renumber(int insertedStart, int insertedEnd) {
        Int2IntOpenHashMap renumberMap = new Int2IntOpenHashMap();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (insertedStart <= index ? index < insertedEnd : false) continue;
            Integer newId = renumberMap.computeIfAbsent(this.id(index), arg_0 -> ASTMarkersImpl.renumber$lambda$11$lambda$10(arg_0 -> ASTMarkersImpl.renumber$lambda$11$lambda$9(this, index, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)newId);
            this.packer.setId(index, newId);
        }
    }

    public final void setChameleon(int lexemeIndex, @NotNull AtomicReference<T> reference) {
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        Integer n = lexemeIndex;
        ((Map)this.chameleonsMap).put(n, reference);
    }

    public final void setMarkersCount(int i, int descCount) {
        this.packer.setMarkersCount(i, descCount);
    }

    public final void setLexemeInfo(int i, int lexemeCount, int relOffset) {
        this.packer.setLexemeInfo(i, lexemeCount, relOffset);
    }

    public final int pushBack() {
        int i = this.getSize();
        this.packer.pushBack();
        this.elementTypes.insert(i, (Object)TokenType.ERROR_ELEMENT);
        return i;
    }

    public final void setMarker(int index, int id, byte kind, boolean collapsed, @Nullable String errorMessage, @Nullable IElementType elementType) {
        if (this.kind(index) != 0) {
            throw new AssertionError();
        }
        if (id + 1 > this.nextId) {
            this.nextId = id + 1;
        }
        this.packer.setInitialInfo(index, id, kind, collapsed, errorMessage != null);
        if (errorMessage != null) {
            this.errorMessages.put(id, errorMessage);
        }
        if (elementType != null) {
            this.elementTypes.set(index, (Object)elementType);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Ref.IntRef depth = new Ref.IntRef();
        this.elementTypes.forEachIndexed((arg_0, arg_1) -> ASTMarkersImpl.toString$lambda$14$lambda$13((arg_0, arg_1) -> ASTMarkersImpl.toString$lambda$14$lambda$12(this, depth, $this$toString_u24lambda_u2414, arg_0, arg_1), arg_0, arg_1));
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u2414.append("{");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        for (Map.Entry entry : ((Map)this.chameleonsMap).entrySet()) {
            Integer t = (Integer)entry.getKey();
            AtomicReference u = (AtomicReference)entry.getValue();
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u2414.append(t + " -> " + u.get());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder4 = $this$toString_u24lambda_u2414.append("}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public ASTMarkersImpl<T> mutate(@NotNull Function1<? super ASTMarkers.MutableContext<T>, Unit> mutator) {
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        MutableContextImpl mutableContextImpl = new MutableContextImpl();
        mutator.invoke((Object)mutableContextImpl);
        return mutableContextImpl.getAst();
    }

    private static final Integer computeIdsForNewMarkers$lambda$7$lambda$5(Ref.IntRef $nextNewId, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$nextNewId, (String)"$nextNewId");
        int n = $nextNewId.element;
        $nextNewId.element = n + 1;
        return n;
    }

    private static final Integer computeIdsForNewMarkers$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer renumber$lambda$11$lambda$9(ASTMarkersImpl this$0, int $index, Integer oldId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = this$0.nextId;
        this$0.nextId = n + 1;
        int currentId = n;
        if (this$0.hasError($index)) {
            Integer n2 = currentId;
            ((Map)this$0.errorMessages).put(n2, this$0.errorMessages.remove(oldId));
        }
        return currentId;
    }

    private static final Integer renumber$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Unit toString$lambda$14$lambda$12(ASTMarkersImpl this$0, Ref.IntRef $depth, StringBuilder $this_buildString, int index, IElementType type) {
        int n;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$depth, (String)"$depth");
        Intrinsics.checkNotNullParameter((Object)$this_buildString, (String)"$this_buildString");
        if (this$0.kind(index) == 2) {
            n = $depth.element;
            $depth.element = n + -1;
        }
        $this_buildString.append(StringsKt.repeat((CharSequence)"  ", (int)$depth.element) + type + " " + this$0.kind(index) + " ");
        $this_buildString.append("e=" + this$0.hasError(index) + " ");
        $this_buildString.append("c=" + this$0.collapsed(index) + " ");
        $this_buildString.append("lo=" + this$0.lexemeRelOffset(index) + " ");
        $this_buildString.append("lc" + this$0.lexemeCount(index) + " ");
        StringBuilder stringBuilder = $this_buildString.append("mc=" + this$0.markersCount(index));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        if (this$0.kind(index) == 1) {
            n = $depth.element;
            $depth.element = n + 1;
        }
        return Unit.INSTANCE;
    }

    private static final void toString$lambda$14$lambda$13(Function2 $tmp0, int p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1);
    }

    public /* synthetic */ ASTMarkersImpl(ASTMarkersImpl origin, DefaultConstructorMarker $constructor_marker) {
        this(origin);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Companion;", "", "<init>", "()V", "DEFAULT_CAPACITY", "", "ij-parsing-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$LexemeInfo;", "", "relOffset", "", "count", "<init>", "(II)V", "getRelOffset", "()I", "getCount", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "ij-parsing-core"})
    public static final class LexemeInfo {
        private final int relOffset;
        private final int count;

        public LexemeInfo(int relOffset, int count) {
            this.relOffset = relOffset;
            this.count = count;
        }

        public final int getRelOffset() {
            return this.relOffset;
        }

        public final int getCount() {
            return this.count;
        }

        public final int component1() {
            return this.relOffset;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final LexemeInfo copy(int relOffset, int count) {
            return new LexemeInfo(relOffset, count);
        }

        public static /* synthetic */ LexemeInfo copy$default(LexemeInfo lexemeInfo, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = lexemeInfo.relOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = lexemeInfo.count;
            }
            return lexemeInfo.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "LexemeInfo(relOffset=" + this.relOffset + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.relOffset);
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LexemeInfo)) {
                return false;
            }
            LexemeInfo lexemeInfo = (LexemeInfo)other;
            if (this.relOffset != lexemeInfo.relOffset) {
                return false;
            }
            return this.count == lexemeInfo.count;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016J4\u0010\u000f\u001a\u00020\t2*\u0010\u0010\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u000b\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0014j\b\u0012\u0004\u0012\u00028\u0000`\u00130\u00120\u0011H\u0016J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J \u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$MutableContextImpl;", "Lcom/jetbrains/lang/parsing/builder/ASTMarkers$MutableContext;", "<init>", "(Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl;)V", "ast", "Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl;", "getAst", "()Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl;", "substitute", "", "i", "", "lexemeIndex", "astMarkers", "Lcom/jetbrains/lang/parsing/builder/ASTMarkers;", "changeChameleons", "pairs", "", "Lkotlin/Pair;", "Lcom/jetbrains/lang/parsing/builder/ChameleonRef;", "Ljava/util/concurrent/atomic/AtomicReference;", "changeLexCount", "startMarker", "endMarker", "lexCount", "changeMarkerCount", "markerCount", "ij-parsing-core"})
    private final class MutableContextImpl
    implements ASTMarkers.MutableContext<T> {
        @NotNull
        private final ASTMarkersImpl<T> ast;

        public MutableContextImpl() {
            this.ast = new ASTMarkersImpl(ASTMarkersImpl.this, null);
        }

        @NotNull
        public final ASTMarkersImpl<T> getAst() {
            return this.ast;
        }

        @Override
        public void substitute(int i, int lexemeIndex, @NotNull ASTMarkers<T> astMarkers) {
            Intrinsics.checkNotNullParameter(astMarkers, (String)"astMarkers");
            this.ast.substituteImpl(astMarkers, i, lexemeIndex);
        }

        @Override
        public void changeChameleons(@NotNull List<? extends Pair<Integer, ? extends AtomicReference<T>>> pairs) {
            Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
            this.ast.chameleonsMap.clear();
            for (Pair pair : pairs) {
                int key = ((Number)pair.component1()).intValue();
                AtomicReference value = (AtomicReference)pair.component2();
                Integer n = key;
                ((Map)this.ast.chameleonsMap).put(n, value);
            }
        }

        @Override
        public void changeLexCount(int startMarker, int endMarker, int lexCount) {
            int relOffset = this.ast.lexemeRelOffset(startMarker);
            this.ast.setLexemeInfo(startMarker, lexCount, relOffset);
            this.ast.setLexemeInfo(endMarker, lexCount, relOffset);
        }

        @Override
        public void changeMarkerCount(int startMarker, int endMarker, int markerCount) {
            this.ast.setMarkersCount(startMarker, markerCount);
            this.ast.setMarkersCount(endMarker, markerCount);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010J.\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J\u001e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0000J\b\u0010(\u001a\u00020\u001eH\u0002J\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u001a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer;", "", "<init>", "()V", "origin", "(Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer;)V", "ints", "Lkala/collection/mutable/primitive/MutableIntList;", "value", "", "longMode", "getLongMode", "()Z", "shortMode", "getShortMode", "index", "", "i", "kind", "", "lexemeInfo", "Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$LexemeInfo;", "collapsed", "hasErrors", "id", "markersCount", "size", "getSize", "()I", "setLexemeInfo", "", "count", "relOffset", "setMarkersCount", "setInitialInfo", "setId", "replace", "start", "end", "packer", "grow", "pushBack", "copy", "Companion", "ij-parsing-core"})
    @SourceDebugExtension(value={"SMAP\nASTMarkersImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTMarkersImpl.kt\ncom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n1#2:430\n1863#3,2:431\n*S KotlinDebug\n*F\n+ 1 ASTMarkersImpl.kt\ncom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer\n*L\n369#1:431,2\n*E\n"})
    private static final class Packer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MutableIntList ints;
        private boolean longMode;
        private static final int KIND_MASK = 3;
        private static final int MAX_SHORT_ID_VALUE = 65535;
        private static final int MAX_SHORT_LEXEME_VALUE = 65535;
        private static final int MAX_SHORT_MARKERS_COUNT = 4095;
        private static final int MAX_LONG_MARKERS_COUNT = 0xFFFFFFF;

        public Packer() {
            this.ints = (MutableIntList)MutableIntArrayList.create((int)256);
        }

        private Packer(Packer origin) {
            this.longMode = origin.longMode;
            this.ints = (MutableIntList)MutableIntArrayList.from((IntTraversable)((IntTraversable)origin.ints));
        }

        public final boolean getLongMode() {
            return this.longMode;
        }

        public final boolean getShortMode() {
            return !this.longMode;
        }

        private final int index(int i) {
            return this.longMode ? i * 4 : i * 2;
        }

        public final byte kind(int i) {
            return (byte)(this.ints.get(this.index(i)) & 3);
        }

        @NotNull
        public final LexemeInfo lexemeInfo(int i) {
            LexemeInfo lexemeInfo;
            int index = this.index(i);
            if (this.longMode) {
                lexemeInfo = new LexemeInfo(this.ints.get(index + 2), this.ints.get(index + 3));
            } else {
                int packed = this.ints.get(index + 1);
                lexemeInfo = new LexemeInfo(packed & 0xFFFF, packed >>> 16);
            }
            return lexemeInfo;
        }

        public final boolean collapsed(int i) {
            return (this.ints.get(this.index(i)) & 4) == 4;
        }

        public final boolean hasErrors(int i) {
            return (this.ints.get(this.index(i)) & 8) == 8;
        }

        public final int id(int i) {
            int index = this.index(i);
            return this.longMode ? this.ints.get(index + 1) : this.ints.get(index) >>> 16;
        }

        public final int markersCount(int i) {
            return this.ints.get(this.index(i)) >>> 4 & (this.longMode ? 0xFFFFFFF : 4095);
        }

        public final int getSize() {
            return this.ints.size() / (this.longMode ? 4 : 2);
        }

        public final void setLexemeInfo(int i, int count, int relOffset) {
            if (this.getShortMode() && (relOffset > 65535 || count > 65535)) {
                this.grow();
            }
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 2, relOffset);
                this.ints.set(index + 3, count);
            } else {
                this.ints.set(index + 1, relOffset | count << 16);
            }
        }

        public final void setMarkersCount(int i, int count) {
            if (this.getShortMode() && count > 4095) {
                this.grow();
            }
            if (!(count <= 0xFFFFFFF)) {
                boolean bl = false;
                String string = "markers count " + count + " is bigger than 268435455";
                throw new IllegalStateException(string.toString());
            }
            int index = this.index(i);
            this.ints.set(index, this.ints.get(index) & 0xFFFF000F | count << 4);
        }

        public final void setInitialInfo(int i, int id, byte kind, boolean collapsed, boolean hasErrors) {
            int hasErrorInt;
            int collapsedInt = collapsed ? 4 : 0;
            int n = hasErrorInt = hasErrors ? 8 : 0;
            if (this.getShortMode() && id > 65535) {
                this.grow();
            }
            int index = this.index(i);
            this.ints.set(index, kind + collapsedInt + hasErrorInt);
            this.setId(i, id);
        }

        public final void setId(int i, int id) {
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 1, id);
            } else {
                this.ints.set(index, this.ints.get(index) & 0xFFFF | id << 16);
            }
        }

        public final void replace(int start, int end, @NotNull Packer packer) {
            Intrinsics.checkNotNullParameter((Object)packer, (String)"packer");
            if (this.longMode && !packer.longMode) {
                packer.grow();
            }
            if (!this.longMode && packer.longMode) {
                this.grow();
            }
            this.ints.removeInRange(this.index(start), this.index(end));
            this.ints.insertAll(this.index(start), (IntTraversable)packer.ints);
        }

        private final void grow() {
            if (!this.getShortMode()) {
                boolean $i$a$-check-ASTMarkersImpl$Packer$grow$22 = false;
                String $i$a$-check-ASTMarkersImpl$Packer$grow$22 = "Already in long mode";
                throw new IllegalStateException($i$a$-check-ASTMarkersImpl$Packer$grow$22.toString());
            }
            int end = this.getSize() - 1;
            int $i$a$-check-ASTMarkersImpl$Packer$grow$22 = this.ints.size();
            int n = 0;
            while (n < $i$a$-check-ASTMarkersImpl$Packer$grow$22) {
                int it = n++;
                boolean bl = false;
                this.ints.append(0);
            }
            this.longMode = true;
            Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)end, (int)0);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                int firstInt = this.ints.get(i * 2);
                int secondInt = this.ints.get(i * 2 + 1);
                this.setInitialInfo(i, firstInt >>> 16, (byte)(firstInt & 3), (firstInt & 4) == 4, (firstInt & 8) == 8);
                this.setMarkersCount(i, firstInt >>> 4 & 0xFFF);
                this.setLexemeInfo(i, secondInt >>> 16, secondInt & 0xFFFF);
            }
        }

        public final void pushBack() {
            int n = this.longMode ? 4 : 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.ints.append(0);
            }
        }

        @NotNull
        public final Packer copy() {
            return new Packer(this);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/lang/parsing/builder/ASTMarkersImpl$Packer$Companion;", "", "<init>", "()V", "KIND_MASK", "", "MAX_SHORT_ID_VALUE", "MAX_SHORT_LEXEME_VALUE", "MAX_SHORT_MARKERS_COUNT", "MAX_LONG_MARKERS_COUNT", "ij-parsing-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

