/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.parsing;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.psi.ITokenSequence;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.jetbrains.lang.parsing.AstMarkersChameleon;
import com.jetbrains.lang.parsing.AstMarkersSyntaxNodeKt;
import com.jetbrains.lang.parsing.TokenizationPolicy;
import com.jetbrains.lang.parsing.WalkerContext;
import com.jetbrains.lang.parsing.builder.ASTMarkers;
import com.jetbrains.lang.parsing.builder.ASTMarkersKt;
import com.jetbrains.lang.parsing.builder.MarkerPsiBuilder;
import com.jetbrains.lang.syntax.SyntaxNode;
import com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 r2\u00020\u0001:\u0001rBE\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJH\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u0002J\u0013\u0010,\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010.\u001a\u00020\tH\u0016J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010>\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010?\u001a\u00020\u001bH\u0002J\r\u0010@\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\bAJ\n\u0010B\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010C\u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0016J\"\u0010D\u001a\u0004\u0018\u00010\u00002\u0006\u0010E\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u001b\u0010F\u001a\u0004\u0018\u00010\u00012\n\u0010G\u001a\u000605j\u0002`4H\u0016\u00a2\u0006\u0002\u0010HJ\b\u0010L\u001a\u00020MH\u0002J\u00e8\u0001\u0010N\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020M0Qj\u0002`P0O2\u0006\u0010/\u001a\u0002002\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00072\u0086\u0001\u0010U\u001a\u0081\u0001\u0012\u0015\u0012\u0013\u0018\u00010)\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(Z\u0012\u0013\u0012\u001100\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(/\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b([\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(\\\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020M0^j\u0002`]0Wj\u0002`V2\u0006\u0010[\u001a\u00020\t2\u0006\u0010\\\u001a\u00020\t2\u0010\u0010_\u001a\f\u0012\u0004\u0012\u00020b0aj\u0002``H\u0002\u00a2\u0006\u0002\u0010cJ\u0006\u0010d\u001a\u00020;J\b\u0010e\u001a\u00020;H\u0016J[\u0010f\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001b0g2\u0006\u0010h\u001a\u00020S2\u0006\u0010i\u001a\u00020\u00072\u0006\u0010j\u001a\u0002002\u0006\u00103\u001a\u0002052\u0006\u00108\u001a\u0002052\u0010\u0010_\u001a\f\u0012\u0004\u0012\u00020b0aj\u0002``H\u0002\u00a2\u0006\u0002\u0010kJ\u00e6\u0001\u0010l\u001a\u001a\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020M0Qj\u0002`P\u0012\u0004\u0012\u00020\u0007\u0018\u00010O2\u0086\u0001\u0010m\u001a\u0081\u0001\u0012\u0015\u0012\u0013\u0018\u00010)\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(Z\u0012\u0013\u0012\u001100\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(/\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b([\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(\\\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020M0^j\u0002`]0Wj\u0002`V2\u0006\u0010n\u001a\u00020S2\u0006\u0010i\u001a\u00020\u00072\u0006\u0010/\u001a\u0002002\u0006\u0010o\u001a\u0002052\u0006\u0010p\u001a\u0002052\u0010\u0010_\u001a\f\u0012\u0004\u0012\u00020b0aj\u0002``\u00a2\u0006\u0002\u0010qR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0018\u00103\u001a\u000605j\u0002`48VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0018\u00108\u001a\u000605j\u0002`48VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00107R\u0016\u0010:\u001a\u0004\u0018\u00010;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0016\u0010I\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u00a8\u0006s"}, d2={"Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode;", "Lcom/jetbrains/lang/syntax/SyntaxNode;", "parent", "prevSibling", "context", "Lcom/jetbrains/lang/parsing/WalkerContext;", "tokens", "Lcom/intellij/psi/ITokenSequence;", "startLexemeIndex", "", "nextMarkerStartLexemeIndex", "markerIndex", "<init>", "(Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode;Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode;Lcom/jetbrains/lang/parsing/WalkerContext;Lcom/intellij/psi/ITokenSequence;III)V", "getParent$ij_parsing_core", "()Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode;", "getPrevSibling$ij_parsing_core", "getContext$ij_parsing_core", "()Lcom/jetbrains/lang/parsing/WalkerContext;", "getTokens", "()Lcom/intellij/psi/ITokenSequence;", "getStartLexemeIndex$ij_parsing_core", "()I", "getNextMarkerStartLexemeIndex$ij_parsing_core", "getMarkerIndex$ij_parsing_core", "copy", "isMarker", "", "isMarker$ij_parsing_core", "()Z", "endLexemeIndex", "getEndLexemeIndex$ij_parsing_core", "type", "", "getType", "()Ljava/lang/Object;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getElementType", "()Lcom/intellij/psi/tree/IElementType;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "equals", "other", "hashCode", "text", "", "getText", "()Ljava/lang/CharSequence;", "startOffset", "Lcom/jetbrains/lang/syntax/CharOffset;", "", "getStartOffset", "()J", "endOffset", "getEndOffset", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "firstChild", "isCopyOfParent", "isChameleon", "isChameleon$ij_parsing_core", "lastChild", "nextSibling", "goForthToNextSibling", "siblingLexemeIndex", "childByOffset", "offset", "(J)Lcom/jetbrains/lang/syntax/SyntaxNode;", "chameleonSyntaxNode", "getChameleonSyntaxNode", "()Lcom/jetbrains/lang/syntax/SyntaxNode;", "getOrParseChameleon", "Lcom/jetbrains/lang/parsing/AstMarkersChameleon;", "parseChameleon", "Lkotlin/Pair;", "Lcom/jetbrains/lang/parsing/AstMarkers;", "Lcom/jetbrains/lang/parsing/builder/ASTMarkers;", "contextLexer", "Lcom/intellij/lexer/Lexer;", "lexemeStore", "factory", "Lcom/jetbrains/lang/parsing/AstMarkersBuilderFactory;", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "ijLanguage", "startLexeme", "lexemeCount", "Lcom/jetbrains/lang/parsing/AstMarkersPsiBuilder;", "Lcom/jetbrains/lang/parsing/builder/MarkerPsiBuilder;", "cancellationToken", "Lcom/jetbrains/lang/parsing/CancellationToken;", "Lkotlin/Function0;", "", "(Ljava/lang/CharSequence;Lcom/intellij/lexer/Lexer;Lcom/intellij/psi/ITokenSequence;Lkotlin/jvm/functions/Function5;IILkotlin/jvm/functions/Function0;)Lkotlin/Pair;", "reportState", "toString", "findDeepestReparseableNode", "Lkotlin/Triple;", "rootLexer", "newTokens", "newText", "(Lcom/intellij/lexer/Lexer;Lcom/intellij/psi/ITokenSequence;Ljava/lang/CharSequence;JJLkotlin/jvm/functions/Function0;)Lkotlin/Triple;", "tryReparse", "builderFactory", "lexer", "start", "end", "(Lkotlin/jvm/functions/Function5;Lcom/intellij/lexer/Lexer;Lcom/intellij/psi/ITokenSequence;Ljava/lang/CharSequence;JJLkotlin/jvm/functions/Function0;)Lkotlin/Pair;", "Companion", "ij-parsing-core"})
@SourceDebugExtension(value={"SMAP\nAstMarkersSyntaxNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AstMarkersSyntaxNode.kt\ncom/jetbrains/lang/parsing/AstMarkersSyntaxNode\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,651:1\n183#2,2:652\n183#2,2:655\n1#3:654\n*S KotlinDebug\n*F\n+ 1 AstMarkersSyntaxNode.kt\ncom/jetbrains/lang/parsing/AstMarkersSyntaxNode\n*L\n281#1:652,2\n457#1:655,2\n*E\n"})
public final class AstMarkersSyntaxNode
implements SyntaxNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AstMarkersSyntaxNode parent;
    @Nullable
    private final AstMarkersSyntaxNode prevSibling;
    @NotNull
    private final WalkerContext context;
    @NotNull
    private final ITokenSequence tokens;
    private final int startLexemeIndex;
    private final int nextMarkerStartLexemeIndex;
    private final int markerIndex;
    private final boolean isMarker;
    private final int endLexemeIndex;
    @NotNull
    private final IElementType elementType;

    public AstMarkersSyntaxNode(@Nullable AstMarkersSyntaxNode parent, @Nullable AstMarkersSyntaxNode prevSibling, @NotNull WalkerContext context, @NotNull ITokenSequence tokens, int startLexemeIndex, int nextMarkerStartLexemeIndex, int markerIndex) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.parent = parent;
        this.prevSibling = prevSibling;
        this.context = context;
        this.tokens = tokens;
        this.startLexemeIndex = startLexemeIndex;
        this.nextMarkerStartLexemeIndex = nextMarkerStartLexemeIndex;
        this.markerIndex = markerIndex;
        this.isMarker = this.markerIndex != -1 && this.startLexemeIndex == this.nextMarkerStartLexemeIndex;
        this.endLexemeIndex = this.startLexemeIndex + (this.isMarker ? this.context.getAst().lexemeCount(this.markerIndex) : 1);
        this.elementType = this.isMarker ? this.context.getAst().elementType(this.markerIndex) : this.tokens.lexType(this.startLexemeIndex);
    }

    @Nullable
    public final AstMarkersSyntaxNode getParent$ij_parsing_core() {
        return this.parent;
    }

    @Nullable
    public final AstMarkersSyntaxNode getPrevSibling$ij_parsing_core() {
        return this.prevSibling;
    }

    @NotNull
    public final WalkerContext getContext$ij_parsing_core() {
        return this.context;
    }

    @NotNull
    public final ITokenSequence getTokens() {
        return this.tokens;
    }

    public final int getStartLexemeIndex$ij_parsing_core() {
        return this.startLexemeIndex;
    }

    public final int getNextMarkerStartLexemeIndex$ij_parsing_core() {
        return this.nextMarkerStartLexemeIndex;
    }

    public final int getMarkerIndex$ij_parsing_core() {
        return this.markerIndex;
    }

    private final AstMarkersSyntaxNode copy(AstMarkersSyntaxNode parent, AstMarkersSyntaxNode prevSibling, WalkerContext context, int startLexemeIndex, int nextMarkerStartLexemeIndex, int markerIndex) {
        ITokenSequence iTokenSequence = this.tokens.fork();
        return new AstMarkersSyntaxNode(parent, prevSibling, context, iTokenSequence, startLexemeIndex, nextMarkerStartLexemeIndex, markerIndex);
    }

    static /* synthetic */ AstMarkersSyntaxNode copy$default(AstMarkersSyntaxNode astMarkersSyntaxNode, AstMarkersSyntaxNode astMarkersSyntaxNode2, AstMarkersSyntaxNode astMarkersSyntaxNode3, WalkerContext walkerContext, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            astMarkersSyntaxNode2 = astMarkersSyntaxNode.parent;
        }
        if ((n4 & 2) != 0) {
            astMarkersSyntaxNode3 = astMarkersSyntaxNode.prevSibling;
        }
        if ((n4 & 4) != 0) {
            walkerContext = astMarkersSyntaxNode.context;
        }
        if ((n4 & 8) != 0) {
            n = astMarkersSyntaxNode.startLexemeIndex;
        }
        if ((n4 & 0x10) != 0) {
            n2 = astMarkersSyntaxNode.nextMarkerStartLexemeIndex;
        }
        if ((n4 & 0x20) != 0) {
            n3 = astMarkersSyntaxNode.markerIndex;
        }
        return astMarkersSyntaxNode.copy(astMarkersSyntaxNode2, astMarkersSyntaxNode3, walkerContext, n, n2, n3);
    }

    public final boolean isMarker$ij_parsing_core() {
        return this.isMarker;
    }

    public final int getEndLexemeIndex$ij_parsing_core() {
        return this.endLexemeIndex;
    }

    @NotNull
    public Object getType() {
        return this.elementType;
    }

    @NotNull
    public final IElementType getElementType() {
        return this.elementType;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.elementType.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language currentLang = language;
        Language specificLang = (Language)SequencesKt.lastOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)this, AstMarkersSyntaxNode::_get_language_$lambda$0), arg_0 -> AstMarkersSyntaxNode._get_language_$lambda$1(currentLang, arg_0)));
        Language language2 = specificLang;
        if (language2 == null) {
            language2 = currentLang;
        }
        return language2;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof AstMarkersSyntaxNode && Intrinsics.areEqual((Object)((AstMarkersSyntaxNode)other).tokens, (Object)this.tokens) && ((AstMarkersSyntaxNode)other).markerIndex == this.markerIndex && ((AstMarkersSyntaxNode)other).startLexemeIndex == this.startLexemeIndex;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.context, this.markerIndex, this.startLexemeIndex};
        return Objects.hash(objectArray);
    }

    @NotNull
    public CharSequence getText() {
        return this.context.getText().subSequence((int)(this.getStartOffset() - this.context.getOffset()), (int)(this.getEndOffset() - this.context.getOffset()));
    }

    public long getStartOffset() {
        return this.context.getOffset() + (this.startLexemeIndex == this.tokens.getLexemeCount() ? (long)this.context.getText().length() : (long)this.tokens.lexStart(this.startLexemeIndex));
    }

    /*
     * Enabled aggressive block sorting
     */
    public long getEndOffset() {
        int n;
        long l = this.context.getOffset();
        if (!this.isMarker) {
            n = AstMarkersSyntaxNodeKt.endCharAt(this.tokens, this.startLexemeIndex);
            return l + (long)n;
        }
        byte by = this.context.getAst().kind(this.markerIndex);
        if (by != 1 && by != 3) {
            if (by != 2) throw new IllegalStateException("no else".toString());
            throw new IllegalStateException("should not be at the end".toString());
        }
        n = AstMarkersSyntaxNodeKt.endCharAt(this.tokens, this.endLexemeIndex - 1);
        return l + (long)n;
    }

    @Nullable
    public String getErrorMessage() {
        String string = this.isMarker ? this.context.getAst().errorMessage(this.markerIndex) : null;
        if (string == null) {
            string = Intrinsics.areEqual((Object)this.getType(), (Object)TokenType.ERROR_ELEMENT) ? "Bad token" : null;
        }
        return string;
    }

    @Nullable
    public SyntaxNode parent() {
        return this.parent;
    }

    @Nullable
    public SyntaxNode firstChild() {
        SyntaxNode syntaxNode;
        if (this.isMarker) {
            AstMarkersSyntaxNode astMarkersSyntaxNode;
            ASTMarkers<AstMarkersChameleon> ast = this.context.getAst();
            if (ast.kind(this.markerIndex) == 3) {
                astMarkersSyntaxNode = null;
            } else if (this.isChameleon$ij_parsing_core()) {
                SyntaxNode syntaxNode2 = this.getChameleonSyntaxNode();
                AstMarkersSyntaxNode astMarkersSyntaxNode2 = (AstMarkersSyntaxNode)(syntaxNode2 != null ? syntaxNode2.firstChild() : null);
                astMarkersSyntaxNode = astMarkersSyntaxNode2 != null ? AstMarkersSyntaxNode.copy$default(astMarkersSyntaxNode2, this, null, null, 0, 0, 0, 62, null) : null;
            } else {
                int childMarkerIndex = ASTMarkersKt.firstChild(ast, this.markerIndex);
                if (childMarkerIndex == -1 && this.startLexemeIndex != this.endLexemeIndex) {
                    int n = this.startLexemeIndex;
                    astMarkersSyntaxNode = AstMarkersSyntaxNode.copy$default(this, this, null, null, 0, n, -1, 12, null);
                } else if (childMarkerIndex == -1) {
                    astMarkersSyntaxNode = null;
                } else if (ast.kind(childMarkerIndex) == 1 || ast.kind(childMarkerIndex) == 3) {
                    int n = this.startLexemeIndex + ast.lexemeRelOffset(childMarkerIndex);
                    astMarkersSyntaxNode = AstMarkersSyntaxNode.copy$default(this, this, null, null, 0, n, childMarkerIndex, 12, null);
                } else {
                    if (ast.kind(childMarkerIndex) == 2) {
                        throw new IllegalStateException("should not be at the end".toString());
                    }
                    throw new IllegalStateException("no else".toString());
                }
            }
            syntaxNode = astMarkersSyntaxNode;
        } else if (this.isChameleon$ij_parsing_core() && !this.isCopyOfParent()) {
            SyntaxNode syntaxNode3 = this.getChameleonSyntaxNode();
            AstMarkersSyntaxNode astMarkersSyntaxNode = (AstMarkersSyntaxNode)(syntaxNode3 != null ? syntaxNode3.firstChild() : null);
            syntaxNode = astMarkersSyntaxNode != null ? AstMarkersSyntaxNode.copy$default(astMarkersSyntaxNode, this, null, null, 0, 0, 0, 62, null) : null;
        } else {
            syntaxNode = null;
        }
        return syntaxNode;
    }

    private final boolean isCopyOfParent() {
        return this.parent != null && Intrinsics.areEqual((Object)this.parent.getType(), (Object)this.getType()) && this.parent.startLexemeIndex == this.startLexemeIndex && this.parent.endLexemeIndex == this.endLexemeIndex && this.parent.markerIndex == this.markerIndex;
    }

    public final boolean isChameleon$ij_parsing_core() {
        return this.isMarker && this.context.getAst().kind(this.markerIndex) == 1 && this.context.getAst().elementType(this.markerIndex) instanceof ILazyParseableElementType && this.context.getAst().collapsed(this.markerIndex) || !this.isMarker && this.getType() instanceof ILazyParseableElementType;
    }

    @Nullable
    public SyntaxNode lastChild() {
        return AstMarkersSyntaxNode.lastChild$lastSibling(this.firstChild());
    }

    @Nullable
    public AstMarkersSyntaxNode nextSibling() {
        AstMarkersSyntaxNode astMarkersSyntaxNode;
        if (this.parent == null) {
            astMarkersSyntaxNode = null;
        } else if (this.isMarker) {
            int siblingMarkerIndex = ASTMarkersKt.nextSibling(this.context.getAst(), this.markerIndex);
            int startLexemeIndex = siblingMarkerIndex == -1 ? this.endLexemeIndex : this.endLexemeIndex + this.context.getAst().lexemeRelOffset(siblingMarkerIndex);
            astMarkersSyntaxNode = this.goForthToNextSibling(this.endLexemeIndex, startLexemeIndex, siblingMarkerIndex);
        } else {
            astMarkersSyntaxNode = this.goForthToNextSibling(this.startLexemeIndex + 1, this.markerIndex != -1 ? this.nextMarkerStartLexemeIndex : this.startLexemeIndex + 1, this.markerIndex);
        }
        return astMarkersSyntaxNode;
    }

    @Nullable
    public SyntaxNode prevSibling() {
        return this.prevSibling;
    }

    private final AstMarkersSyntaxNode goForthToNextSibling(int siblingLexemeIndex, int startLexemeIndex, int markerIndex) {
        AstMarkersSyntaxNode astMarkersSyntaxNode = this.parent;
        int parentEndLexeme = !Intrinsics.areEqual((Object)(astMarkersSyntaxNode != null ? astMarkersSyntaxNode.tokens : null), (Object)this.tokens) ? this.tokens.getLexemeCount() : this.parent.endLexemeIndex;
        return markerIndex != -1 || siblingLexemeIndex < parentEndLexeme ? AstMarkersSyntaxNode.copy$default(this, null, this, null, siblingLexemeIndex, startLexemeIndex, markerIndex, 5, null) : null;
    }

    @Nullable
    public SyntaxNode childByOffset(long offset) {
        Object v1;
        block1: {
            Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.children((SyntaxNode)this);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SyntaxNode it = (SyntaxNode)element$iv;
                boolean bl = false;
                long l = it.getStartOffset();
                boolean bl2 = offset < it.getEndOffset() ? l <= offset : false;
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final SyntaxNode getChameleonSyntaxNode() {
        SyntaxNode syntaxNode;
        AstMarkersChameleon astMarkersChameleon = this.getOrParseChameleon();
        ITokenSequence chameleonTokens = astMarkersChameleon.component1();
        ASTMarkers<AstMarkersChameleon> tree = astMarkersChameleon.component2();
        if (tree.getSize() == 0) {
            syntaxNode = null;
        } else if (chameleonTokens == null) {
            syntaxNode = AstMarkersSyntaxNode.Companion.rootWithContext(WalkerContext.copy$default(this.context, null, tree, null, null, null, this.startLexemeIndex, 0L, 93, null), this.tokens.fork());
        } else {
            int startOffsetInContext = this.tokens.lexStart(this.startLexemeIndex);
            int endOffsetInContext = AstMarkersSyntaxNodeKt.endCharAt(this.tokens, this.endLexemeIndex - 1);
            CharSequence chamaleonText = this.context.getText().subSequence(startOffsetInContext, endOffsetInContext);
            Object object = this.getType();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.tree.ILazyParseableElementType");
            Lexer lexer = ((ILazyParseableElementType)object).createInnerLexer();
            if (lexer == null) {
                lexer = this.context.getLexer();
            }
            Lexer newContextLexer = lexer;
            WalkerContext walkerContext = this.context;
            long l = this.getStartOffset();
            syntaxNode = AstMarkersSyntaxNode.Companion.rootWithContext(WalkerContext.copy$default(walkerContext, chamaleonText, tree, newContextLexer, null, null, 0, l, 24, null), chameleonTokens.fork());
        }
        return syntaxNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AstMarkersChameleon getOrParseChameleon() {
        AtomicReference<AstMarkersChameleon> atomicReference;
        try {
            atomicReference = this.context.getAst().chameleonAt(this.startLexemeIndex - this.context.getStartLexemeIndex());
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Chameleon not found");
        }
        AtomicReference<AstMarkersChameleon> c = atomicReference;
        AstMarkersChameleon astMarkersChameleon = c.get();
        if (astMarkersChameleon == null) {
            AtomicReference<AstMarkersChameleon> atomicReference2 = c;
            synchronized (atomicReference2) {
                boolean bl = false;
                AstMarkersChameleon astMarkersChameleon2 = c.get();
                if (astMarkersChameleon2 == null) {
                    AstMarkersChameleon astMarkersChameleon3;
                    AstMarkersSyntaxNode $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245 = this;
                    boolean bl2 = false;
                    Pair<ITokenSequence, ASTMarkers<AstMarkersChameleon>> pair = $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.parseChameleon($this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.context.getText(), $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.context.getLexer(), $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.tokens, $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.context.getBuilderFactory(), $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.startLexemeIndex, $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.endLexemeIndex - $this$getOrParseChameleon_u24lambda_u246_u24lambda_u245.startLexemeIndex, (Function0<Unit>)((Function0)AstMarkersSyntaxNode::getOrParseChameleon$lambda$6$lambda$5$lambda$3));
                    ITokenSequence tokens = (ITokenSequence)pair.component1();
                    ASTMarkers node = (ASTMarkers)pair.component2();
                    AstMarkersChameleon it = astMarkersChameleon3 = new AstMarkersChameleon(tokens, node);
                    boolean bl3 = false;
                    c.set(it);
                    astMarkersChameleon2 = astMarkersChameleon3;
                }
                AstMarkersChameleon astMarkersChameleon4 = astMarkersChameleon2;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 6] lbl30 : MonitorExitStatement: MONITOREXIT : var3_3
                astMarkersChameleon = astMarkersChameleon4;
            }
        }
        return astMarkersChameleon;
    }

    private final Pair<ITokenSequence, ASTMarkers<AstMarkersChameleon>> parseChameleon(CharSequence text, Lexer contextLexer, ITokenSequence lexemeStore, Function5<? super Language, ? super CharSequence, ? super ITokenSequence, ? super Integer, ? super Integer, ? extends MarkerPsiBuilder<AstMarkersChameleon>> factory, int startLexeme, int lexemeCount, Function0<Unit> cancellationToken) {
        ITokenSequence iTokenSequence;
        IElementType iElementType = this.elementType;
        Intrinsics.checkNotNull((Object)iElementType, (String)"null cannot be cast to non-null type com.intellij.psi.tree.ILazyParseableElementType");
        Lexer lexer = ((ILazyParseableElementType)iElementType).createInnerLexer();
        CharSequence chameleonText = null;
        ITokenSequence chameleonTokens = null;
        int chameleonStartLexeme = 0;
        int chameleonLexemeCount = 0;
        boolean lexerChanged = lexer != null && !AstMarkersSyntaxNodeKt.access$isEquivalent(lexer, contextLexer);
        if (lexerChanged) {
            int startOffsetInContext = lexemeStore.lexStart(startLexeme);
            int endOffsetInContext = AstMarkersSyntaxNodeKt.endCharAt(lexemeStore, startLexeme + lexemeCount - 1);
            chameleonText = text.subSequence(startOffsetInContext, endOffsetInContext);
            TokenizationPolicy tokenizationPolicy = this.context.getTokenization();
            IElementType iElementType2 = TokenType.WHITE_SPACE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"WHITE_SPACE");
            Lexer lexer2 = lexer;
            Intrinsics.checkNotNull((Object)lexer2);
            chameleonTokens = tokenizationPolicy.tokenize(chameleonText, iElementType2, lexer2, cancellationToken);
            chameleonStartLexeme = 0;
            chameleonLexemeCount = chameleonTokens.getLexemeCount();
        } else {
            chameleonText = text;
            chameleonTokens = lexemeStore;
            chameleonStartLexeme = startLexeme;
            chameleonLexemeCount = lexemeCount;
        }
        MarkerPsiBuilder builder = (MarkerPsiBuilder)factory.invoke((Object)this.getLanguage(), (Object)chameleonText, (Object)chameleonTokens, (Object)chameleonStartLexeme, (Object)chameleonLexemeCount);
        ((ILazyParseableElementType)this.elementType).parse(builder);
        ITokenSequence it = iTokenSequence = chameleonTokens;
        boolean bl = false;
        return TuplesKt.to((Object)(lexerChanged ? iTokenSequence : null), builder.getRoot());
    }

    @NotNull
    public final String reportState() {
        StringBuilder stringBuilder;
        StringBuilder $this$reportState_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$reportState_u24lambda_u248.append("context offset : " + this.context.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$reportState_u24lambda_u248.append("context startLexemeIndex : " + this.context.getStartLexemeIndex());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$reportState_u24lambda_u248.append("file text");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$reportState_u24lambda_u248.append(StringsKt.trimIndent((String)("```\n      " + this.context.getText() + "\n      ```")));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$reportState_u24lambda_u248.append("ast tree :");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$reportState_u24lambda_u248.append(StringsKt.trimIndent((String)("```\n      " + this.context.getAst() + "\n      ```")));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        AstMarkersSyntaxNode node = this;
        while (node != null) {
            StringBuilder stringBuilder8 = $this$reportState_u24lambda_u248.append(node);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            node = node.parent;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getType() + " [m=" + this.markerIndex + ", l=" + this.startLexemeIndex + "], (sl=" + this.nextMarkerStartLexemeIndex + ", el=" + this.endLexemeIndex + ") " + (String)(this.isMarker ? "mc=" + this.context.getAst().markersCount(this.markerIndex) : "");
    }

    private final Triple<AstMarkersSyntaxNode, ITokenSequence, Boolean> findDeepestReparseableNode(Lexer rootLexer, ITokenSequence newTokens, CharSequence newText, long startOffset, long endOffset, Function0<Unit> cancellationToken) {
        ITokenSequence currentTokens;
        AstMarkersSyntaxNode node = this;
        ITokenSequence nodeTokens = currentTokens = newTokens;
        AstMarkersSyntaxNode deepestReparseableNode = null;
        Lexer currentLexer = rootLexer;
        while (node != null && Intrinsics.compare((long)node.getStartOffset(), (long)startOffset) <= 0 && Intrinsics.compare((long)node.getEndOffset(), (long)endOffset) > 0) {
            Object v5;
            block6: {
                Object type = node.getType();
                AstMarkersSyntaxNode astMarkersSyntaxNode = node.parent;
                IElementType parentType = astMarkersSyntaxNode != null ? astMarkersSyntaxNode.elementType : null;
                ILazyParseableElementType iLazyParseableElementType = type instanceof ILazyParseableElementType ? (ILazyParseableElementType)type : null;
                Lexer lexer = iLazyParseableElementType != null ? iLazyParseableElementType.createInnerLexer() : null;
                CharSequence nodeText = newText.subSequence((int)node.getStartOffset(), (int)node.getEndOffset());
                if (type instanceof IReparseableElementType) {
                    int endLexemeIndex;
                    int startLexemeIndex = currentTokens.lexemeIndexByChar((int)(node.getStartOffset() - node.context.getOffset()));
                    if (((IReparseableElementType)type).isParsable(parentType, nodeText, currentTokens, startLexemeIndex, (endLexemeIndex = currentTokens.lexemeIndexByChar((int)(node.getEndOffset() - node.context.getOffset()))) - startLexemeIndex)) {
                        deepestReparseableNode = node;
                        nodeTokens = currentTokens;
                    } else {
                        ITokenSequence remapped = nodeTokens;
                        AstMarkersSyntaxNode astMarkersSyntaxNode2 = deepestReparseableNode;
                        return new Triple((Object)(astMarkersSyntaxNode2 != null ? AstMarkersSyntaxNode.findDeepestReparseableNode$asReparseableNode(astMarkersSyntaxNode2, startOffset, remapped) : null), (Object)remapped, (Object)(!Intrinsics.areEqual((Object)currentLexer, (Object)rootLexer) ? 1 : 0));
                    }
                }
                if (lexer != null && !AstMarkersSyntaxNodeKt.access$isEquivalent(lexer, currentLexer)) {
                    currentLexer = lexer;
                    TokenizationPolicy tokenizationPolicy = this.context.getTokenization();
                    IElementType iElementType = TokenType.WHITE_SPACE;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"WHITE_SPACE");
                    currentTokens = tokenizationPolicy.tokenize(nodeText, iElementType, lexer, cancellationToken);
                }
                Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.children((SyntaxNode)node);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SyntaxNode it = (SyntaxNode)element$iv;
                    boolean bl = false;
                    if (!(it.getStartOffset() <= startOffset && it.getEndOffset() >= endOffset)) continue;
                    v5 = element$iv;
                    break block6;
                }
                v5 = null;
            }
            node = v5;
        }
        AstMarkersSyntaxNode astMarkersSyntaxNode = deepestReparseableNode;
        return new Triple((Object)(astMarkersSyntaxNode != null ? AstMarkersSyntaxNode.findDeepestReparseableNode$asReparseableNode(astMarkersSyntaxNode, startOffset, nodeTokens) : null), (Object)nodeTokens, (Object)(!Intrinsics.areEqual((Object)currentLexer, (Object)rootLexer) ? 1 : 0));
    }

    @Nullable
    public final Pair<ASTMarkers<AstMarkersChameleon>, ITokenSequence> tryReparse(@NotNull Function5<? super Language, ? super CharSequence, ? super ITokenSequence, ? super Integer, ? super Integer, ? extends MarkerPsiBuilder<AstMarkersChameleon>> builderFactory, @NotNull Lexer lexer, @NotNull ITokenSequence newTokens, @NotNull CharSequence text, long start, long end, @NotNull Function0<Unit> cancellationToken) {
        Pair pair;
        Intrinsics.checkNotNullParameter(builderFactory, (String)"builderFactory");
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Intrinsics.checkNotNullParameter((Object)newTokens, (String)"newTokens");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(cancellationToken, (String)"cancellationToken");
        Triple<AstMarkersSyntaxNode, ITokenSequence, Boolean> triple = this.findDeepestReparseableNode(lexer, newTokens, text, start, (long)text.length() - end, cancellationToken);
        AstMarkersSyntaxNode reparseableNode = (AstMarkersSyntaxNode)triple.component1();
        ITokenSequence nodeTokens = (ITokenSequence)triple.component2();
        boolean lexerChanged = (Boolean)triple.component3();
        if (reparseableNode != null) {
            ITokenSequence iTokenSequence;
            int i;
            ITokenSequence oldTokens = reparseableNode.tokens;
            int startLexemeIndex = nodeTokens.lexemeIndexByChar((int)(reparseableNode.getStartOffset() - reparseableNode.context.getOffset()));
            int endLexemeIndex = nodeTokens.lexemeIndexByChar((int)(reparseableNode.getEndOffset() - reparseableNode.context.getOffset()));
            int oldLexemeCount = endLexemeIndex - startLexemeIndex;
            int diff = nodeTokens.getLexemeCount() - oldTokens.getLexemeCount();
            for (i = 0; i < startLexemeIndex; ++i) {
                nodeTokens.remap(i, oldTokens.lexType(i));
            }
            int n = nodeTokens.getLexemeCount();
            for (i = endLexemeIndex; i < n; ++i) {
                nodeTokens.remap(i, oldTokens.lexType(i - diff));
            }
            Pair<ITokenSequence, ASTMarkers<AstMarkersChameleon>> pair2 = reparseableNode.parseChameleon(text, lexer, nodeTokens, builderFactory, startLexemeIndex, oldLexemeCount, cancellationToken);
            ITokenSequence lexemeStore = (ITokenSequence)pair2.component1();
            ASTMarkers node = (ASTMarkers)pair2.component2();
            ITokenSequence it = iTokenSequence = nodeTokens;
            boolean bl = false;
            ITokenSequence iTokenSequence2 = !lexerChanged ? iTokenSequence : null;
            if (iTokenSequence2 == null) {
                iTokenSequence2 = newTokens;
            }
            ITokenSequence newLexemeStorage = iTokenSequence2;
            pair = TuplesKt.to((Object)AstMarkersSyntaxNodeKt.access$substitute(reparseableNode, nodeTokens, new AstMarkersChameleon(lexemeStore, node)), (Object)newLexemeStorage);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final AstMarkersSyntaxNode _get_language_$lambda$0(AstMarkersSyntaxNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.parent;
    }

    private static final Language _get_language_$lambda$1(Language $currentLang, AstMarkersSyntaxNode it) {
        Intrinsics.checkNotNullParameter((Object)$currentLang, (String)"$currentLang");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.elementType.getLanguage().isKindOf($currentLang) ? it.elementType.getLanguage() : null;
    }

    private static final SyntaxNode lastChild$lastSibling(SyntaxNode c) {
        while (true) {
            SyntaxNode s;
            SyntaxNode syntaxNode = c;
            Object object = s = syntaxNode != null ? syntaxNode.nextSibling() : null;
            if (s == null) break;
            c = s;
        }
        return c;
    }

    private static final Unit getOrParseChameleon$lambda$6$lambda$5$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final AstMarkersSyntaxNode findDeepestReparseableNode$asReparseableNode(AstMarkersSyntaxNode $this$findDeepestReparseableNode_u24asReparseableNode, long $startOffset, ITokenSequence newTokens) {
        IElementType newType = $startOffset >= 0L && $startOffset < (long)newTokens.getTextLength() ? newTokens.lexType(newTokens.lexemeIndexByChar((int)$startOffset)) : null;
        return Intrinsics.areEqual(newType, (Object)$this$findDeepestReparseableNode_u24asReparseableNode.getType()) ? $this$findDeepestReparseableNode_u24asReparseableNode : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u00c6\u0001\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0086\u0001\u0010\u0015\u001a\u0081\u0001\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001e\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00100 j\u0002`\u001f0\u0017j\u0002`\u00162\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode$Companion;", "", "<init>", "()V", "rootWithContext", "Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode;", "context", "Lcom/jetbrains/lang/parsing/WalkerContext;", "tokens", "Lcom/intellij/psi/ITokenSequence;", "root", "text", "", "markers", "Lcom/jetbrains/lang/parsing/AstMarkers;", "Lcom/jetbrains/lang/parsing/builder/ASTMarkers;", "Lcom/jetbrains/lang/parsing/AstMarkersChameleon;", "lexer", "Lcom/intellij/lexer/Lexer;", "tokenizationPolicy", "Lcom/jetbrains/lang/parsing/TokenizationPolicy;", "builderFactory", "Lcom/jetbrains/lang/parsing/AstMarkersBuilderFactory;", "Lkotlin/Function5;", "Lcom/intellij/lang/Language;", "Lkotlin/ParameterName;", "name", "ijLanguage", "", "startLexeme", "lexemeCount", "Lcom/jetbrains/lang/parsing/AstMarkersPsiBuilder;", "Lcom/jetbrains/lang/parsing/builder/MarkerPsiBuilder;", "(Ljava/lang/CharSequence;Lcom/jetbrains/lang/parsing/builder/ASTMarkers;Lcom/intellij/lexer/Lexer;Lcom/jetbrains/lang/parsing/TokenizationPolicy;Lkotlin/jvm/functions/Function5;Lcom/intellij/psi/ITokenSequence;)Lcom/jetbrains/lang/parsing/AstMarkersSyntaxNode;", "ij-parsing-core"})
    public static final class Companion {
        private Companion() {
        }

        private final AstMarkersSyntaxNode rootWithContext(WalkerContext context, ITokenSequence tokens) {
            int n = context.getStartLexemeIndex();
            int n2 = context.getStartLexemeIndex();
            return new AstMarkersSyntaxNode(null, null, context, tokens, n, n2, 0);
        }

        @NotNull
        public final AstMarkersSyntaxNode root(@NotNull CharSequence text, @NotNull ASTMarkers<AstMarkersChameleon> markers, @NotNull Lexer lexer, @NotNull TokenizationPolicy tokenizationPolicy, @NotNull Function5<? super Language, ? super CharSequence, ? super ITokenSequence, ? super Integer, ? super Integer, ? extends MarkerPsiBuilder<AstMarkersChameleon>> builderFactory, @NotNull ITokenSequence tokens) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(markers, (String)"markers");
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            Intrinsics.checkNotNullParameter((Object)tokenizationPolicy, (String)"tokenizationPolicy");
            Intrinsics.checkNotNullParameter(builderFactory, (String)"builderFactory");
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            return this.rootWithContext(new WalkerContext(text, markers, lexer, tokenizationPolicy, builderFactory, 0, 0L, 96, null), tokens.fork());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

