/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> T[] ar(T ... elements) {
        return elements;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        ArrayList<E> result = new ArrayList<E>();
        for (E elem : iterable) {
            result.add(elem);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        return Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        V[] result = ArrayUtil.newArray(aClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Collection<? extends T> list, @NotNull Comparator<? super T> comparator) {
        return ContainerUtil.sorted(list, comparator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Iterable<? extends T> list, @NotNull Comparator<? super T> comparator) {
        ArrayList<? extends T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        return sorted;
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<? extends T> list) {
        return ContainerUtil.sorted(list, Comparator.naturalOrder());
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            list.sort(comparator);
        }
    }

    public static <T> void sort(@NotNull T[] a, @NotNull Comparator<? super T> comparator) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return new ArrayList();
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (element != null) {
            result.add(element);
        }
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        return switch (elements.length) {
            case 0 -> Collections.emptySet();
            case 1 -> Collections.singleton(elements[0]);
            default -> Set.of(elements);
        };
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Predicate<? super T> condition) {
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Predicate<? super T> condition) {
        for (T t : iterable) {
            if (!condition.test(t)) continue;
            return true;
        }
        return false;
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new HashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        @Contract(pure=true)
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

