/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ArrayTokenSequence;
import com.intellij.psi.templateLanguages.RangeCollectorImpl;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType {
    private static final int CHECK_PROGRESS_AFTER_TOKENS = 1000;
    @NotNull
    private final ParserDefinition myTemplateParserDefinition;
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    final IElementType myOuterElementType;

    public TemplateDataElementType(@NotNull ParserDefinition templateParserDefinition, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        this.myTemplateParserDefinition = templateParserDefinition;
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer() {
        return this.myTemplateParserDefinition.createLexer(null);
    }

    public ArrayTokenSequence buildTemplateDataLexemes(@NotNull CharSequence sourceCode, @NotNull Lexer lexer) {
        RangeCollectorImpl collector = new RangeCollectorImpl(this);
        CharSequence modifiedTemplateDataSource = this.createTemplateFile(sourceCode, collector);
        ArrayTokenSequence dataTokens = new ArrayTokenSequence.Builder(modifiedTemplateDataSource, lexer).performLexing();
        return collector.insertOuterElementsAndRemoveRanges(dataTokens);
    }

    protected CharSequence createTemplateFile(CharSequence sourceCode, @NotNull RangeCollector rangeCollector) {
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, this.createBaseLexer(), rangeCollector);
        if (rangeCollector instanceof RangeCollectorImpl) {
            Language templateLanguage = this.myTemplateParserDefinition.getFileNodeType().getLanguage();
            ((RangeCollectorImpl)rangeCollector).prepareFileForParsing(templateLanguage, sourceCode, templateSourceCode);
        }
        return templateSourceCode;
    }

    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        TemplateDataModifications modifications = this.collectTemplateModifications(sourceCode, baseLexer);
        return ((RangeCollectorImpl)rangeCollector).applyTemplateDataModifications(sourceCode, modifications);
    }

    @NotNull
    protected TemplateDataModifications collectTemplateModifications(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer) {
        TemplateDataModifications modifications = new TemplateDataModifications();
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        int tokenCounter = 0;
        while (baseLexer.getTokenType() != null) {
            if (++tokenCounter % 1000 == 0) {
                ProgressManager.checkCanceled();
            }
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + String.valueOf(baseLexer) + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                TemplateDataModifications tokenModifications = this.appendCurrentTemplateToken(baseLexer.getTokenEnd(), baseLexer.getTokenSequence());
                modifications.addAll(tokenModifications);
            } else {
                modifications.addOuterRange(currentRange, this.isInsertionToken(baseLexer.getTokenType(), baseLexer.getTokenSequence()));
            }
            baseLexer.advance();
        }
        return modifications;
    }

    @NotNull
    private static String getRangeDump(@NotNull TextRange range, @NotNull CharSequence sequence) {
        return "'" + StringUtil.escapeStringCharacters((String)range.subSequence(sequence).toString()) + "' " + String.valueOf(range);
    }

    @Deprecated
    protected void appendCurrentTemplateToken(@NotNull StringBuilder result, @NotNull CharSequence buf, @NotNull Lexer lexer, @NotNull RangeCollector collector) {
        result.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    @NotNull
    protected TemplateDataModifications appendCurrentTemplateToken(int tokenEndOffset, @NotNull CharSequence tokenText) {
        return TemplateDataModifications.EMPTY;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected TokenSet getTemplateDataInsertionTokens() {
        return TokenSet.EMPTY;
    }

    protected boolean isInsertionToken(@Nullable IElementType tokenType, @NotNull CharSequence tokenSequence) {
        return false;
    }

    @NotNull
    public static ASTNode parseWithOuterAndRemoveRangesApplied(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<? super @NotNull CharSequence, ? extends @NotNull ASTNode> parser) {
        RangeCollectorImpl collector = (RangeCollectorImpl)chameleon.getUserData(RangeCollectorImpl.OUTER_ELEMENT_RANGES);
        return collector != null ? collector.applyRangeCollectorAndExpandChameleon(chameleon, language, parser) : parser.apply(chameleon.getChars());
    }

    public static abstract class RangeCollector {
        public void addOuterRange(@NotNull TextRange newRange) {
        }

        public abstract void addOuterRange(@NotNull TextRange var1, boolean var2);

        public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
        }
    }

    private static class DummyCharTable
    implements CharTable {
        private static final DummyCharTable INSTANCE = new DummyCharTable();

        private DummyCharTable() {
        }

        @Override
        @NotNull
        public CharSequence intern(@NotNull CharSequence text) {
            return text;
        }

        @Override
        @NotNull
        public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
            return baseText.subSequence(startOffset, endOffset);
        }
    }

    public static interface OuterLanguageRangePatcher {
        @Nullable
        public String getTextForOuterLanguageInsertionRange(@NotNull TemplateDataElementType var1, @NotNull CharSequence var2);
    }
}

