/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ArrayTokenSequence;
import com.intellij.psi.TokenType;
import com.intellij.psi.templateLanguages.DefaultOuterLanguagePatcher;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeCollectorImpl
extends TemplateDataElementType.RangeCollector {
    private static final DefaultOuterLanguagePatcher DEFAULT_OUTER_LANGUAGE_PATCHER = new DefaultOuterLanguagePatcher();
    private final TemplateDataElementType myTemplateDataElementType;
    private final List<TextRange> myOuterAndRemoveRanges;
    static final Key<RangeCollectorImpl> OUTER_ELEMENT_RANGES = Key.create((String)"template.parser.outer.element.handler");

    RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType) {
        this(templateDataElementType, new ArrayList<TextRange>());
    }

    private RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType, @NotNull List<TextRange> outerAndRemoveRanges) {
        this.myTemplateDataElementType = templateDataElementType;
        this.myOuterAndRemoveRanges = outerAndRemoveRanges;
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange) {
        this.addOuterRange(newRange, false);
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange, boolean isInsertion) {
        int lastItemIndex;
        TextRange lastRange;
        if (newRange.isEmpty()) {
            return;
        }
        this.assertRangeOrder(newRange);
        if (!this.myOuterAndRemoveRanges.isEmpty() && (lastRange = this.myOuterAndRemoveRanges.get(lastItemIndex = this.myOuterAndRemoveRanges.size() - 1)).getEndOffset() == newRange.getStartOffset() && !(lastRange instanceof RangeToRemove)) {
            InsertionRange joinedRange = lastRange instanceof InsertionRange || isInsertion ? new InsertionRange(lastRange.getStartOffset(), newRange.getEndOffset()) : TextRange.create((int)lastRange.getStartOffset(), (int)newRange.getEndOffset());
            this.myOuterAndRemoveRanges.set(lastItemIndex, joinedRange);
            return;
        }
        this.myOuterAndRemoveRanges.add(isInsertion ? new InsertionRange(newRange.getStartOffset(), newRange.getEndOffset()) : newRange);
    }

    @Override
    public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
        if (rangeToRemove.isEmpty()) {
            return;
        }
        this.assertRangeOrder(rangeToRemove);
        this.myOuterAndRemoveRanges.add(new RangeToRemove(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset()));
    }

    private void assertRangeOrder(@NotNull TextRange newRange) {
        TextRange range = ContainerUtil.getLastItem(this.myOuterAndRemoveRanges);
        assert (range == null || newRange.getStartOffset() >= range.getStartOffset());
    }

    void prepareFileForParsing(@NotNull Language templateLanguage, @NotNull CharSequence originalSourceCode, @NotNull CharSequence templateSourceCode) {
        this.addDummyStringsToRangesToRemove(templateSourceCode);
        DefaultOuterLanguagePatcher patcher = DEFAULT_OUTER_LANGUAGE_PATCHER;
        StringBuilder builder = templateSourceCode instanceof StringBuilder ? (StringBuilder)templateSourceCode : new StringBuilder(templateSourceCode);
        this.insertDummyStringIntoInsertionRanges(patcher, originalSourceCode, builder);
    }

    private void addDummyStringsToRangesToRemove(@NotNull CharSequence generatedText) {
        int shift = 0;
        ListIterator<TextRange> iterator2 = this.myOuterAndRemoveRanges.listIterator();
        while (iterator2.hasNext()) {
            TextRange range = iterator2.next();
            if (range instanceof RangeToRemove) {
                CharSequence insertedString = generatedText.subSequence(range.getStartOffset() - shift, range.getEndOffset() - shift);
                iterator2.set(new RangeToRemove(range.getStartOffset(), insertedString));
                shift -= range.getLength();
                continue;
            }
            shift += range.getLength();
        }
    }

    private void insertDummyStringIntoInsertionRanges(@NotNull TemplateDataElementType.OuterLanguageRangePatcher patcher, @NotNull CharSequence originalSourceCode, @NotNull StringBuilder modifiedText) {
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            return;
        }
        int shift = 0;
        ListIterator<TextRange> iterator2 = this.myOuterAndRemoveRanges.listIterator();
        while (iterator2.hasNext()) {
            String dummyString;
            TextRange outerElementRange = iterator2.next();
            if (outerElementRange instanceof RangeToRemove) {
                shift += outerElementRange.getLength();
                continue;
            }
            if (outerElementRange instanceof InsertionRange && (dummyString = patcher.getTextForOuterLanguageInsertionRange(this.myTemplateDataElementType, outerElementRange.subSequence(originalSourceCode))) != null) {
                iterator2.add(new RangeToRemove(outerElementRange.getEndOffset(), outerElementRange.getEndOffset() + dummyString.length()));
                modifiedText.insert(outerElementRange.getStartOffset() + shift, dummyString);
                shift += dummyString.length();
            }
            shift -= outerElementRange.getLength();
        }
    }

    ArrayTokenSequence insertOuterElementsAndRemoveRanges(@NotNull ArrayTokenSequence modifiedDataTokens) {
        int lexemeCount = modifiedDataTokens.getLexemeCount();
        int[] lexStarts = new int[lexemeCount + 2];
        IElementType[] lexTypes = new IElementType[lexemeCount + 2];
        int shift = 0;
        Iterator<TextRange> rangeToProcessIterator = this.myOuterAndRemoveRanges.iterator();
        TextRange rangeToProcess = rangeToProcessIterator.hasNext() ? rangeToProcessIterator.next() : null;
        for (int i = 0; i < lexemeCount + 1; ++i) {
            while (rangeToProcess != null && rangeToProcess.getStartOffset() - shift < modifiedDataTokens.lexStart(i)) {
                shift = rangeToProcess instanceof RangeToRemove ? (shift -= rangeToProcess.getLength()) : (shift += rangeToProcess.getLength());
                rangeToProcess = rangeToProcessIterator.hasNext() ? rangeToProcessIterator.next() : null;
            }
            lexStarts[i] = modifiedDataTokens.lexStart(i) + shift;
            lexTypes[i] = modifiedDataTokens.lexType(i);
        }
        if (rangeToProcess != null) {
            lexStarts[lexemeCount + 1] = rangeToProcess.getEndOffset();
            lexTypes[lexemeCount] = TokenType.WHITE_SPACE;
            ++lexemeCount;
        }
        return new ArrayTokenSequence(lexStarts, lexTypes, lexemeCount, modifiedDataTokens.getTextLength());
    }

    @NotNull
    ASTNode applyRangeCollectorAndExpandChameleon(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<? super @NotNull CharSequence, ? extends @NotNull ASTNode> parser) {
        CharSequence chars = chameleon.getChars();
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            return parser.apply(chars);
        }
        StringBuilder stringBuilder = this.applyOuterAndRemoveRanges(chars);
        ASTNode root = parser.apply(stringBuilder.toString());
        return root;
    }

    @NotNull
    private StringBuilder applyOuterAndRemoveRanges(CharSequence chars) {
        StringBuilder stringBuilder = new StringBuilder(chars);
        int shift = 0;
        for (TextRange outerElementRange : this.myOuterAndRemoveRanges) {
            if (outerElementRange instanceof RangeToRemove) {
                CharSequence textToRemove = ((RangeToRemove)outerElementRange).myTextToRemove;
                if (textToRemove == null) continue;
                stringBuilder.insert(outerElementRange.getStartOffset() + shift, textToRemove);
                shift += textToRemove.length();
                continue;
            }
            stringBuilder.delete(outerElementRange.getStartOffset() + shift, outerElementRange.getEndOffset() + shift);
            shift -= outerElementRange.getLength();
        }
        return stringBuilder;
    }

    @NotNull
    CharSequence applyTemplateDataModifications(@NotNull CharSequence sourceCode, @NotNull TemplateDataModifications modifications) {
        assert (this.myOuterAndRemoveRanges.isEmpty());
        List<TextRange> ranges = modifications.myOuterAndRemoveRanges;
        if (ranges.isEmpty()) {
            return sourceCode;
        }
        for (TextRange range : ranges) {
            if (range instanceof RangeToRemove) {
                if (range.isEmpty()) continue;
                this.assertRangeOrder(range);
                CharSequence textToRemove = ((RangeToRemove)range).myTextToRemove;
                assert (textToRemove != null);
                this.myOuterAndRemoveRanges.add(new RangeToRemove(range.getStartOffset(), textToRemove));
                continue;
            }
            this.addOuterRange(range, range instanceof InsertionRange);
        }
        return this.applyOuterAndRemoveRanges(sourceCode);
    }

    static final class RangeToRemove
    extends TextRange {
        @Nullable
        public final CharSequence myTextToRemove;

        RangeToRemove(int startOffset, @NotNull CharSequence text) {
            super(startOffset, startOffset + text.length());
            this.myTextToRemove = text;
        }

        RangeToRemove(int startOffset, int endOffset) {
            super(startOffset, endOffset);
            this.myTextToRemove = null;
        }

        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                return this;
            }
            return this.myTextToRemove != null ? new RangeToRemove(this.getStartOffset() - delta, this.myTextToRemove) : new RangeToRemove(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        @NotNull
        public TextRange intersection(@NotNull TextRange range) {
            int newStart = Math.max(this.getStartOffset(), range.getStartOffset());
            int newEnd = Math.min(this.getEndOffset(), range.getEndOffset());
            RangeToRemove.assertProperRange((int)newStart, (int)newEnd, (Object)"Invalid range");
            return this.myTextToRemove != null ? new RangeToRemove(newStart, this.myTextToRemove.subSequence(newStart - this.getStartOffset(), newEnd - this.getStartOffset())) : new RangeToRemove(newStart, newEnd);
        }

        public String toString() {
            return "RangeToRemove" + super.toString();
        }
    }

    static final class InsertionRange
    extends TextRange {
        InsertionRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                return this;
            }
            return new InsertionRange(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        @NotNull
        public TextRange intersection(@NotNull TextRange range) {
            int newStart = Math.max(this.getStartOffset(), range.getStartOffset());
            int newEnd = Math.min(this.getEndOffset(), range.getEndOffset());
            InsertionRange.assertProperRange((int)newStart, (int)newEnd, (Object)"Invalid range");
            return new InsertionRange(newStart, newEnd);
        }

        public String toString() {
            return "InsertionRange" + super.toString();
        }
    }
}

