/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.psi.ITokenSequence;
import com.intellij.psi.codeStyle.IndentOptions;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.LexemeIterator;
import com.intellij.psi.impl.source.codeStyle.LexemeIteratorImpl;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaLikeLangLineIndentProvider
implements LineIndentProvider {
    @NotNull
    private final CharSequence myChars;
    @NotNull
    private final ITokenSequence myTokens;
    @NotNull
    private final IndentOptions myIndentOptions;
    private static final int END_OF_LINE = 1;
    private static final int NEXT_LINE = 2;
    private static final int NEXT_LINE_SHIFTED = 3;

    public JavaLikeLangLineIndentProvider(@NotNull CharSequence charSequence, @NotNull ITokenSequence tokenSequence, @NotNull IndentOptions indentOptions) {
        this.myChars = charSequence;
        this.myTokens = tokenSequence;
        this.myIndentOptions = indentOptions;
    }

    @Override
    @Nullable
    public String getLineIndent(int offset) {
        if (offset > 0) {
            IndentCalculator indentCalculator = this.getIndent(offset - 1);
            if (indentCalculator != null) {
                return indentCalculator.getIndentString(this.getPosition(offset - 1));
            }
        } else {
            return "";
        }
        return null;
    }

    @Nullable
    protected IndentCalculator getIndent(int offset) {
        IndentCalculatorFactory myFactory = new IndentCalculatorFactory();
        if (this.getPosition(offset).matchesRule(position -> position.isAt(JavaLikeElement.Whitespace) && position.isAtMultiline())) {
            if (this.getPosition(offset).before().isAt(JavaLikeElement.Comma)) {
                SemanticEditorPosition position2 = this.getPosition(offset);
                if (position2.hasEmptyLineAfter(offset) && !position2.after().matchesRule(p -> p.isAtAnyOf(JavaLikeElement.ArrayClosingBracket, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace, JavaLikeElement.RightParenthesis) || p.isAtEnd()) && position2.findLeftParenthesisBackwardsSkippingNestedWithPredicate(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis, self -> self.isAtAnyOf(JavaLikeElement.BlockClosingBrace, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.Semicolon)).isAt(JavaLikeElement.LeftParenthesis)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_AFTER);
                }
            } else {
                if (this.afterOptionalWhitespaceOnSameLine(offset).matchesRule(position -> position.isAt(JavaLikeElement.BlockClosingBrace) && !position.after().afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.Comma))) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, position -> {
                        position.moveToLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                        if (!position.isAtEnd()) {
                            return this.getBlockStatementStartOffset(position);
                        }
                        return -1;
                    });
                }
                if (this.getPosition(offset).beforeOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockClosingBrace)) {
                    SemanticEditorPosition position3 = this.getPosition(offset).beforeOptional(JavaLikeElement.Whitespace).before();
                    boolean isOnNewLine = position3.isAtMultiline(JavaLikeElement.Whitespace);
                    position3.moveToLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    position3.moveBefore();
                    int statementStart = this.getStatementStartOffset(position3, true);
                    position3 = this.getPosition(statementStart);
                    if (!this.isStartOfStatementWithOptionalBlock(position3)) {
                        if (!isOnNewLine) {
                            return null;
                        }
                        return myFactory.createIndentCalculator(this.getBlockIndentType(), IndentCalculator.LINE_BEFORE);
                    }
                    return myFactory.createIndentCalculator(this.getBlockIndentType(), this::getFirstUppermostControlStructureKeywordOffset);
                }
                if (this.getPosition(offset).before().isAt(JavaLikeElement.Semicolon)) {
                    int statementStart;
                    SemanticEditorPosition atStatementStart;
                    SemanticEditorPosition beforeSemicolon = this.getPosition(offset).before().beforeOptional(JavaLikeElement.Semicolon);
                    if (beforeSemicolon.isAt(JavaLikeElement.BlockClosingBrace)) {
                        beforeSemicolon.moveBeforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    }
                    if (JavaLikeLangLineIndentProvider.isAtBlockOpeningOnSameLine(atStatementStart = this.getPosition(statementStart = this.getStatementStartOffset(beforeSemicolon, this.dropIndentAfterReturnLike(beforeSemicolon), true)))) {
                        return myFactory.createIndentCalculator(this.getIndentInBlock(atStatementStart), this::getDeepBlockStatementStartOffset);
                    }
                    if (!this.isInsideForLikeConstruction(atStatementStart)) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> statementStart);
                    }
                } else {
                    if (this.isInArray(offset)) {
                        return myFactory.createIndentCalculator(this.getIndentInBrackets(), IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(offset).before().isAt(JavaLikeElement.LeftParenthesis)) {
                        return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(offset).matchesRule(position -> {
                        JavaLikeLangLineIndentProvider.moveBeforeEndLineComments(position);
                        if (position.isAt(JavaLikeElement.BlockOpeningBrace)) {
                            return !position.before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace).isAt(JavaLikeElement.LeftParenthesis);
                        }
                        return false;
                    })) {
                        SemanticEditorPosition position4 = this.getPosition(offset).before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace);
                        return myFactory.createIndentCalculator(this.getIndentInBlock(position4), this::getBlockStatementStartOffset);
                    }
                    if (this.getPosition(offset).before().matchesRule(position -> this.isColonAfterLabelOrCase(position) || position.isAtAnyOf(JavaLikeElement.ElseKeyword, JavaLikeElement.DoKeyword))) {
                        Indent.Type indentType = this.getPosition(offset).afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockOpeningBrace) ? Indent.Type.NONE : Indent.Type.NORMAL;
                        return myFactory.createIndentCalculator(indentType, IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(offset).matchesRule(position -> {
                        position.moveBefore();
                        if (position.isAt(JavaLikeElement.BlockComment)) {
                            return position.before().isAt(JavaLikeElement.Whitespace) && position.isAtMultiline();
                        }
                        return false;
                    })) {
                        int offsetBeforeComment = this.getPosition(offset).findStartOf(JavaLikeElement.BlockComment);
                        return this.getIndent(offsetBeforeComment);
                    }
                    if (this.getPosition(offset).before().isAt(JavaLikeElement.DocBlockEnd)) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf(JavaLikeElement.DocBlockStart));
                    }
                    SemanticEditorPosition position5 = this.getPosition(offset);
                    if ((position5 = position5.before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace)).isAt(JavaLikeElement.RightParenthesis)) {
                        int offsetAfterParen = position5.getStartOffset() + 1;
                        position5.moveBeforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                        if (!position5.isAtEnd()) {
                            position5.moveBeforeOptional(JavaLikeElement.Whitespace);
                            if (position5.isAt(JavaLikeElement.IfKeyword) || position5.isAt(JavaLikeElement.ForKeyword)) {
                                SemanticEditorPosition.SyntaxElement element = position5.getCurrElement();
                                assert (element != null);
                                int controlKeywordOffset = position5.getStartOffset();
                                Indent.Type indentType = this.getPosition(offsetAfterParen).afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockOpeningBrace) ? Indent.Type.NONE : Indent.Type.NORMAL;
                                return myFactory.createIndentCalculator(indentType, baseLineOffset -> controlKeywordOffset);
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isAtBlockOpeningOnSameLine(@NotNull SemanticEditorPosition position) {
        SemanticEditorPosition pos = position.copy();
        while (!pos.isAt(JavaLikeElement.BlockOpeningBrace)) {
            pos.moveBefore();
            if (!pos.isAtEnd() && !pos.isAtMultiline()) continue;
            return false;
        }
        return true;
    }

    private SemanticEditorPosition afterOptionalWhitespaceOnSameLine(int offset) {
        SemanticEditorPosition position = this.getPosition(offset);
        if (position.isAt(JavaLikeElement.Whitespace)) {
            if (position.hasLineBreaksAfter(offset)) {
                return position;
            }
            position.moveAfter();
        }
        return position;
    }

    protected boolean isInArray(int offset) {
        return this.getPosition(offset).before().isAt(JavaLikeElement.ArrayOpeningBracket);
    }

    protected boolean dropIndentAfterReturnLike(@NotNull SemanticEditorPosition statementBeforeSemicolon) {
        return false;
    }

    protected boolean isColonAfterLabelOrCase(@NotNull SemanticEditorPosition position) {
        return position.isAt(JavaLikeElement.Colon) && this.getPosition(position.getStartOffset()).isAfterOnSameLine(JavaLikeElement.SwitchCase, JavaLikeElement.SwitchDefault);
    }

    protected boolean isInsideForLikeConstruction(SemanticEditorPosition position) {
        return position.isAfterOnSameLine(JavaLikeElement.ForKeyword);
    }

    protected int getBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        JavaLikeLangLineIndentProvider.moveBeforeEndLineComments(position);
        position.moveBeforeOptional(JavaLikeElement.BlockOpeningBrace);
        if (position.isAt(JavaLikeElement.Whitespace)) {
            if (position.isAtMultiline()) {
                return position.after().getStartOffset();
            }
            position.moveBefore();
        }
        return this.getStatementStartOffset(position, false);
    }

    private static void moveBeforeEndLineComments(@NotNull SemanticEditorPosition position) {
        position.moveBefore();
        while (!position.isAtMultiline() && position.isAtAnyOf(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace)) {
            position.moveBefore();
        }
    }

    protected int getDeepBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        position.moveToLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
        return this.getBlockStatementStartOffset(position);
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        return this.getStatementStartOffset(position, ignoreLabels, false);
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position, boolean ignoreLabels, boolean useParentControlStructures) {
        Language currLanguage = position.getLanguage();
        while (!position.isAtEnd()) {
            if (currLanguage == Language.ANY || currLanguage == null) {
                currLanguage = position.getLanguage();
            }
            if (!ignoreLabels && this.isColonAfterLabelOrCase(position)) {
                SemanticEditorPosition afterColon = this.getPosition(position.getStartOffset()).afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.BlockComment).after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment);
                return afterColon.getStartOffset();
            }
            if (position.isAt(JavaLikeElement.RightParenthesis)) {
                position.moveBeforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                continue;
            }
            if (position.isAt(JavaLikeElement.BlockClosingBrace)) {
                position.moveBeforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                continue;
            }
            if (position.isAt(JavaLikeElement.ArrayClosingBracket)) {
                position.moveBeforeParentheses(JavaLikeElement.ArrayOpeningBracket, JavaLikeElement.ArrayClosingBracket);
                continue;
            }
            if (this.isStartOfStatementWithOptionalBlock(position)) {
                return useParentControlStructures ? this.getFirstUppermostControlStructureKeywordOffset(position) : position.getStartOffset();
            }
            if (position.isAtAnyOf(JavaLikeElement.Semicolon, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockComment, JavaLikeElement.DocBlockEnd, JavaLikeElement.LeftParenthesis, JavaLikeElement.LanguageStartDelimiter)) {
                SemanticEditorPosition statementStart = position.copy();
                if (!this.isIndentProvider(statementStart = statementStart.after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment), ignoreLabels)) {
                    SemanticEditorPosition afterColonStatement;
                    SemanticEditorPosition maybeColon = statementStart.afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.BlockComment).after();
                    if (JavaLikeLangLineIndentProvider.atColonWithNewLineAfterColonStatement(maybeColon, afterColonStatement = maybeColon.after().after())) {
                        return afterColonStatement.getStartOffset();
                    }
                    if (JavaLikeLangLineIndentProvider.atBlockStartAndNeedBlockIndent(position)) {
                        return position.getStartOffset();
                    }
                } else if (!statementStart.isAtEnd()) {
                    return statementStart.getStartOffset();
                }
            }
            position.moveBefore();
        }
        return 0;
    }

    protected boolean isStartOfStatementWithOptionalBlock(@NotNull SemanticEditorPosition position) {
        return position.matchesRule(self -> {
            SemanticEditorPosition before = self.before();
            return before.isAt(JavaLikeElement.Whitespace) && before.isAtMultiline() && self.isAtAnyOf(JavaLikeElement.ElseKeyword, JavaLikeElement.IfKeyword, JavaLikeElement.ForKeyword, JavaLikeElement.TryKeyword, JavaLikeElement.DoKeyword);
        });
    }

    private static boolean atBlockStartAndNeedBlockIndent(@NotNull SemanticEditorPosition position) {
        return position.isAt(JavaLikeElement.BlockOpeningBrace);
    }

    private static boolean atColonWithNewLineAfterColonStatement(@NotNull SemanticEditorPosition maybeColon, @NotNull SemanticEditorPosition afterColonStatement) {
        return maybeColon.isAt(JavaLikeElement.Colon) && maybeColon.after().isAtMultiline(JavaLikeElement.Whitespace) && !afterColonStatement.isAtEnd();
    }

    private int getFirstUppermostControlStructureKeywordOffset(@NotNull SemanticEditorPosition position) {
        SemanticEditorPosition curr = position.copy();
        while (!curr.isAtEnd()) {
            if (this.isStartOfStatementWithOptionalBlock(curr)) {
                SemanticEditorPosition candidate = curr.copy();
                curr.moveBefore();
                curr.moveBeforeOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment, JavaLikeElement.BlockComment);
                if (curr.isAt(JavaLikeElement.RightParenthesis)) {
                    curr.moveBeforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                    SemanticEditorPosition controlStructureCheck = curr.copy();
                    controlStructureCheck.moveBeforeOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment, JavaLikeElement.BlockComment);
                    if (this.isStartOfStatementWithOptionalBlock(controlStructureCheck)) continue;
                }
                return candidate.getStartOffset();
            }
            if (curr.isAt(JavaLikeElement.BlockClosingBrace)) {
                curr.moveBeforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                continue;
            }
            curr.moveBefore();
        }
        return position.before().getStartOffset();
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition statementStartPosition, boolean ignoreLabels) {
        return true;
    }

    public SemanticEditorPosition getPosition(int offset) {
        return SemanticEditorPosition.createEditorPosition(offset, this.myChars, this::getIteratorAtPosition, this::mapType);
    }

    @NotNull
    protected LexemeIterator getIteratorAtPosition(int offset) {
        return new LexemeIteratorImpl(this.myTokens, offset);
    }

    @Nullable
    protected abstract SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType var1);

    @Nullable
    protected Indent getIndentInBlock(@NotNull SemanticEditorPosition blockStartPosition) {
        if (this.myIndentOptions.BRACE_STYLE == 3) {
            return JavaLikeLangLineIndentProvider.getDefaultIndentFromType(this.myIndentOptions.METHOD_BRACE_STYLE == 3 ? Indent.Type.NONE : null);
        }
        return JavaLikeLangLineIndentProvider.getDefaultIndentFromType(Indent.Type.NORMAL);
    }

    private Indent.Type getBlockIndentType() {
        if (this.myIndentOptions.BRACE_STYLE == 2 || this.myIndentOptions.BRACE_STYLE == 1) {
            return Indent.Type.NONE;
        }
        return null;
    }

    @Contract(value="null -> null")
    protected static Indent getDefaultIndentFromType(@Nullable Indent.Type type) {
        return type == null ? null : Indent.getIndent(type, 0, false, false);
    }

    @Override
    @Contract(value="null -> false")
    public final boolean isSuitableFor(@Nullable Language language) {
        return language != null && this.isSuitableForLanguage(language);
    }

    public abstract boolean isSuitableForLanguage(@NotNull Language var1);

    protected Indent.Type getIndentTypeInBrackets() {
        return Indent.Type.CONTINUATION;
    }

    protected Indent getIndentInBrackets() {
        return JavaLikeLangLineIndentProvider.getDefaultIndentFromType(this.getIndentTypeInBrackets());
    }

    public class IndentCalculatorFactory {
        @Nullable
        public IndentCalculator createIndentCalculator(@Nullable Indent.Type indentType, @Nullable IndentCalculator.BaseLineOffsetCalculator baseLineOffsetCalculator) {
            return this.createIndentCalculator(JavaLikeLangLineIndentProvider.getDefaultIndentFromType(indentType), baseLineOffsetCalculator);
        }

        @Nullable
        public IndentCalculator createIndentCalculator(@Nullable Indent indent, @Nullable IndentCalculator.BaseLineOffsetCalculator baseLineOffsetCalculator) {
            return indent != null ? new IndentCalculator(baseLineOffsetCalculator != null ? baseLineOffsetCalculator : IndentCalculator.LINE_BEFORE, JavaLikeLangLineIndentProvider.this.myChars, JavaLikeLangLineIndentProvider.this.myIndentOptions, indent) : null;
        }

        @Nullable
        public IndentCalculator createIndentCalculatorWithCustomBaseIndent(@Nullable Indent indent, final @NotNull String baseIndent) {
            if (indent == null) {
                return null;
            }
            return new IndentCalculator(this, IndentCalculator.LINE_BEFORE, JavaLikeLangLineIndentProvider.this.myChars, JavaLikeLangLineIndentProvider.this.myIndentOptions, indent){

                @Override
                @NotNull
                protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
                    return baseIndent;
                }
            };
        }
    }

    public static enum JavaLikeElement implements SemanticEditorPosition.SyntaxElement
    {
        Whitespace,
        Semicolon,
        BlockOpeningBrace,
        BlockClosingBrace,
        ArrayOpeningBracket,
        ArrayClosingBracket,
        RightParenthesis,
        LeftParenthesis,
        Colon,
        SwitchCase,
        SwitchDefault,
        ElseKeyword,
        IfKeyword,
        ForKeyword,
        TryKeyword,
        DoKeyword,
        BlockComment,
        DocBlockStart,
        DocBlockEnd,
        LineComment,
        Comma,
        LanguageStartDelimiter;

    }
}

