/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language {
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = new ConcurrentHashMap<Class<? extends Language>, Language>();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = new ConcurrentHashMap<String, List<Language>>();
    private static final Map<String, Language> ourRegisteredIDs = new ConcurrentHashMap<String, Language>();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects = new ArrayList<Language>();
    private final Set<@NotNull Language> myTransitiveDialects = ContainerUtil.newConcurrentSet();
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }
    };

    protected Language(@NonNls @NotNull String ID) {
        this(ID, new String[0]);
    }

    protected Language(@NonNls @NotNull String ID, String ... mimeTypes) {
        this((Language)null, ID, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NonNls @NotNull String ID, String ... mimeTypes) {
        this.myBaseLanguage = baseLanguage;
        this.myID = ID;
        this.myMimeTypes = mimeTypes.length == 0 ? new String[]{} : mimeTypes;
        Class<?> langClass = this.getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            throw new IllegalStateException("Language of '" + String.valueOf(langClass) + "' is already registered: " + String.valueOf(prev));
        }
        prev = ourRegisteredIDs.put(ID, this);
        if (prev != null) {
            throw new IllegalStateException("Language with ID '" + ID + "' is already registered: " + String.valueOf(prev.getClass()));
        }
        for (String mimeType : mimeTypes) {
            if (mimeType == null || mimeType.isEmpty()) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = ourRegisteredMimeTypes.computeIfAbsent(mimeType, mime -> new ArrayList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    @NotNull
    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        return Collections.unmodifiableCollection(new ArrayList<Language>(languages));
    }

    public static void unregisterLanguages(ClassLoader classLoader) {
        ArrayList<Class<? extends Language>> classes = new ArrayList<Class<? extends Language>>(ourRegisteredLanguages.keySet());
        for (Class clazz : classes) {
            if (clazz.getClassLoader() != classLoader) continue;
            Language.unregisterLanguage(ourRegisteredLanguages.get(clazz));
        }
        IElementType.unregisterElementTypes(classLoader);
    }

    public static void unregisterLanguage(@NotNull Language language) {
        IElementType.unregisterElementTypes(language);
        ourRegisteredLanguages.remove(language.getClass());
        ourRegisteredIDs.remove(language.getID());
        for (String mimeType : language.getMimeTypes()) {
            ourRegisteredMimeTypes.remove(mimeType);
        }
        Language baseLanguage = language.getBaseLanguage();
        if (baseLanguage != null) {
            baseLanguage.unregisterDialect(language);
        }
    }

    public void unregisterDialect(Language language) {
        this.myDialects.remove(language);
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass) {
        Language t = ourRegisteredLanguages.get(klass);
        return (T)t;
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        return result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    public String @NotNull [] getMimeTypes() {
        return this.myMimeTypes;
    }

    @NotNull
    public String getID() {
        return this.myID;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    public String getDisplayName() {
        return this.getID();
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull String anotherLanguageId) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Language> getDialects() {
        return this.myDialects;
    }

    @Nullable
    public static Language findLanguageByID(String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    @ApiStatus.Internal
    protected void registerDialect(@NotNull Language dialect) {
        this.myDialects.add(dialect);
        for (Language baseLanguage = this; baseLanguage != null; baseLanguage = baseLanguage.getBaseLanguage()) {
            baseLanguage.myTransitiveDialects.add(dialect);
        }
    }

    protected Language(@NotNull String ID, boolean register) {
        Language language = Language.findLanguageByID(ID);
        if (language != null) {
            throw new IllegalArgumentException("Language with ID=" + ID + " already registered: " + String.valueOf(language) + "; " + String.valueOf(language.getClass()));
        }
        this.myID = ID;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }
}

