package com.intellij.psi.templateLanguages

import com.intellij.lexer.Lexer
import com.intellij.lexer.LexerBase
import com.intellij.psi.ArrayTokenSequence
import com.intellij.psi.tree.IElementType

class TemplateLexerAdapter(
  private val elementType: TemplateDataElementType,
  private val dataLexer: Lexer,
) : LexerBase {
  private lateinit var lexemes: ArrayTokenSequence
  private var state: Int = -1
  private lateinit var text: CharSequence

  override fun start(buffer: CharSequence, startOffset: Int, endOffset: Int, initialState: Int) {
    require(startOffset == 0)
    require(endOffset == buffer.length)
    lexemes = elementType.buildTemplateDataLexemes(buffer, dataLexer)
    state = initialState
    text = buffer
  }

  override fun getState(): Int = state
  override fun getTokenType(): IElementType? = if (state < lexemes.lexemeCount) lexemes.lexType(state) else null
  override fun getTokenStart(): Int = lexemes.lexStart(state)
  override fun getTokenEnd(): Int = lexemes.lexStart(state + 1)
  override fun advance() {
    state++
  }

  override fun getBufferSequence(): CharSequence = text
  override fun getBufferEnd(): Int = text.length - 1
}
