package com.intellij.psi.impl.source.codeStyle;

import com.intellij.psi.tree.IElementType;

public interface LexemeIterator {
  int getStart();
  int getEnd();

  /**
   * @return type if the current token
   */
  IElementType getTokenType();

  /**
   * Move iterator to the next segment
   */
  void advance();

  /**
   * Move iterator to the previous segment
   */
  void retreat();
  boolean atEnd();
}
