package com.intellij.psi

import com.intellij.lang.LightPsiParser
import com.intellij.lang.ParserDefinition
import com.intellij.lang.PsiBuilder
import com.intellij.lexer.Lexer
import com.intellij.psi.tree.TokenSet
import com.jetbrains.lang.parsing.builder.parse2

interface FleetPsiParser {
  fun parse(builder: PsiBuilder)
  fun wrap(builder: PsiBuilder): PsiBuilder = builder
  val lexer: Lexer
  val whitespaces: TokenSet
  val comments: TokenSet
}

abstract class DefaultPsiParser(private val parserDefinition: ParserDefinition) : FleetPsiParser {
  private val parser = parserDefinition.createParser(null) as LightPsiParser

  override fun parse(builder: PsiBuilder) {
    parser.parseLight(parserDefinition.fileNodeType, builder)
  }

  fun parse(text: String) = parse2(text)

  override val lexer = parserDefinition.createLexer(null)
  override val whitespaces: TokenSet = parserDefinition.whitespaceTokens
  override val comments: TokenSet = parserDefinition.commentTokens
}
