package org.aya.kala;

import kala.annotations.ReplaceWith;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@ReplaceWith("kala-collection-primitive")
public class Int2ObjectOpenHashMap<V> extends HashMap<Integer, V> {
  public void trim() {
  }

  public @NotNull List<Pair<Integer, V>> toList() {
    return this.entrySet().stream()
      .map(e -> new Pair<>(e.getKey(), e.getValue()))
      .collect(Collectors.toList());
  }

  @Override public Int2ObjectOpenHashMap<V> clone() {
    var clone = new Int2ObjectOpenHashMap<V>();
    clone.putAll(this);
    return clone;
  }

  @Override public @NotNull V get(Object key) {
    return super.get(key);
  }
}
