package com.jetbrains.lang.parsing.builder

import com.intellij.lang.Language
import com.intellij.psi.ArrayTokenSequence
import com.intellij.psi.FleetPsiParser
import com.intellij.psi.ITokenSequence
import com.jetbrains.lang.parsing.AstMarkers
import com.jetbrains.lang.parsing.AstMarkersChameleon
import com.jetbrains.lang.parsing.AstMarkersSyntaxNode
import com.jetbrains.lang.parsing.TokenizationPolicy
import com.jetbrains.lang.syntax.children

fun FleetPsiParser.parse2(text: CharSequence): AstMarkersSyntaxNode {
  val tokens = ArrayTokenSequence.Builder(text, lexer).performLexing()
  val markerPsiBuilder: MarkerPsiBuilder<*> = MarkerPsiBuilder<Any?>(
    /* text = */ text,
    /* tokens = */ tokens,
    /* whitespaceTokens = */ whitespaces,
    /* commentTokens = */ comments,
    /* startLexeme = */ 0,
    /* lexemeCount = */ tokens.lexemeCount,
  )
  parse(wrap(markerPsiBuilder))
  val astMarkers = markerPsiBuilder.root
  return AstMarkersSyntaxNode.root(
    text = text,
    markers = astMarkers as AstMarkers,
    lexer = lexer,
    tokenizationPolicy = TokenizationPolicy { text, emptyType, lexer, cancellation ->
      ArrayTokenSequence.Builder(text, lexer).performLexing()
    },
    builderFactory = {
      ijLanguage: Language?,
      text: CharSequence,
      tokens: ITokenSequence,
      startLexeme: Int,
      lexemeCount: Int,
      ->
      wrap(
        MarkerPsiBuilder<AstMarkersChameleon>(
          /* text = */ text,
          /* tokens = */ tokens,
          /* whitespaceTokens = */ whitespaces,
          /* commentTokens = */ comments,
          /* startLexeme = */ startLexeme,
          /* lexemeCount = */ lexemeCount,
        ),
      ) as MarkerPsiBuilder<AstMarkersChameleon>
    },
    tokens = tokens,
  )
}

fun AstMarkersSyntaxNode.toDebugString(): String =
  StringBuilder().also { toDebugString(0, it) }.toString()

private fun AstMarkersSyntaxNode.toDebugString(indent: Int, stringBuild: StringBuilder) {
  stringBuild.appendLine("${"\t".repeat(indent)}$elementType($startOffset..$endOffset)")
  children().forEach { (it as AstMarkersSyntaxNode).toDebugString(indent + 1, stringBuild) }
}
