package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleHelper {
  public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object @NotNull ... params) {
    try {
      String message = bundle.getString(key);
      if (params.length > 0) {
        try {
          return new MessageFormat(message).format(params);
        } catch (IllegalArgumentException e) {
          Logger.getInstance(bundle.getBaseBundleName()).warn(e);
        }
      }
      return message;
    } catch (MissingResourceException e) {
      Logger.getInstance(bundle.getBaseBundleName()).warn(e);
      return "";
    }
  }
}
