/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class WalkingState<T> {
    private boolean isDown;
    protected boolean startedWalking;
    private final TreeGuide<T> myWalker;
    private boolean stopped;

    public void elementFinished(@NotNull T element) {
    }

    public WalkingState(@NotNull TreeGuide<T> delegate) {
        this.myWalker = delegate;
    }

    public void visit(@NotNull T element) {
        this.elementStarted(element);
    }

    public void elementStarted(@NotNull T element) {
        this.isDown = true;
        if (!this.startedWalking) {
            this.stopped = false;
            this.startedWalking = true;
            try {
                this.walkChildren(element);
            }
            finally {
                this.startedWalking = false;
            }
        }
    }

    private void walkChildren(@NotNull T root) {
        T element = this.next(root, root, this.isDown);
        while (element != null && !this.stopped) {
            this.isDown = false;
            T parent = this.myWalker.getParent(element);
            T next = this.myWalker.getNextSibling(element);
            this.visit(element);
            assert (this.myWalker.getNextSibling(element) == next) : "Next sibling of the element '" + String.valueOf(element) + "' changed. Was: " + String.valueOf(next) + "; Now:" + String.valueOf(this.myWalker.getNextSibling(element)) + "; Root:" + String.valueOf(root);
            assert (this.myWalker.getParent(element) == parent) : "Parent of the element '" + String.valueOf(element) + "' changed. Was: " + String.valueOf(parent) + "; Now:" + String.valueOf(this.myWalker.getParent(element)) + "; Root:" + String.valueOf(root);
            element = this.next(element, root, this.isDown);
        }
    }

    public T next(T element, @NotNull T root, boolean isDown) {
        T child;
        if (isDown && (child = this.myWalker.getFirstChild(element)) != null) {
            return child;
        }
        while (element != root && element != null) {
            T next = this.myWalker.getNextSibling(element);
            this.elementFinished(element);
            if (next != null) {
                T nextPrev = this.myWalker.getPrevSibling(next);
                if (nextPrev != element) {
                    T top;
                    String msg = "Element: " + String.valueOf(element) + "; next: " + String.valueOf(next) + "; next.prev: " + String.valueOf(nextPrev);
                    while ((top = this.myWalker.getParent(element)) != null && top != root) {
                        element = top;
                    }
                    assert (false) : msg + " Top:" + String.valueOf(element);
                }
                return next;
            }
            element = this.myWalker.getParent(element);
        }
        if (element != null) {
            this.elementFinished(element);
        }
        return null;
    }

    public void startedWalking() {
        this.startedWalking = true;
    }

    public void stopWalking() {
        this.stopped = true;
    }

    public static <T> boolean processAll(@NotNull T root, @NotNull TreeGuide<T> treeGuide, final @NotNull Processor<? super T> processor) {
        final boolean[] result = new boolean[]{true};
        new WalkingState<T>(treeGuide){

            @Override
            public void visit(@NotNull T element) {
                if (!processor.process(element)) {
                    this.stopWalking();
                    result[0] = false;
                } else {
                    super.visit(element);
                }
            }
        }.visit(root);
        return result[0];
    }

    public static interface TreeGuide<T> {
        public T getNextSibling(@NotNull T var1);

        public T getPrevSibling(@NotNull T var1);

        public T getFirstChild(@NotNull T var1);

        public T getParent(@NotNull T var1);
    }
}

